/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.common.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ivyde.common.model.IvyModelSettings;

public abstract class IvyFile {
    private static final Pattern ATTRIBUTE_NAME_PATTERN = Pattern.compile("[^\"]*\"[\\s]*=[\\s]*([\\w\\-]+)");
    private static final Pattern QUALIFIER_PATTERN = Pattern.compile("[\\w\\-<]*");
    private static final Pattern ATTRIBUTE_VALUE_PATTERN = Pattern.compile("([a-zA-Z0-9]+)[ ]*=[ ]*\"([^\"]*)\"");
    private String doc;
    private int currentOffset;
    private String reversed;
    private String projectName;
    private IvyModelSettings settings;

    public IvyFile(IvyModelSettings settings, String projectName, String doc) {
        this(settings, projectName, doc, 0);
    }

    public IvyFile(IvyModelSettings settings, String projectName, String doc, int currentOffset) {
        this.settings = settings;
        this.projectName = projectName;
        this.doc = doc;
        this.reversed = new StringBuffer(doc).reverse().toString();
        this.currentOffset = currentOffset;
    }

    protected String getDoc() {
        return this.doc;
    }

    protected int getCurrentOffset() {
        return this.currentOffset;
    }

    protected String getReversedDoc() {
        return this.reversed;
    }

    public boolean inTag() {
        return this.inTag(this.currentOffset);
    }

    public boolean inTag(int documentOffset) {
        char c;
        boolean hasSpace = false;
        do {
            if (documentOffset == 0) {
                return false;
            }
            if (Character.isWhitespace(c = this.doc.charAt(--documentOffset))) {
                hasSpace = true;
            }
            if (c != '>' || documentOffset != 0 && this.doc.charAt(documentOffset - 1) == '-') continue;
            return false;
        } while (c != '<' || documentOffset + 1 < this.doc.length() && (this.doc.charAt(documentOffset + 1) == '!' || this.doc.charAt(documentOffset + 1) == '?'));
        return hasSpace;
    }

    public String getTagName() {
        return this.getTagName(this.currentOffset);
    }

    public String getTagName(int documentOffset) {
        int offset;
        int lastSpaceIndex = offset = documentOffset;
        while (true) {
            char c;
            if (Character.isWhitespace(c = this.doc.charAt(--offset))) {
                lastSpaceIndex = offset;
                continue;
            }
            if (c == '<') break;
        }
        return this.doc.substring(offset + 1, lastSpaceIndex).trim();
    }

    public boolean readyForValue() {
        return this.readyForValue(this.currentOffset);
    }

    public boolean readyForValue(int documentOffset) {
        return this.getAttributeName(documentOffset) != null;
    }

    public int getStringIndexBackward(String string) {
        return this.getStringIndexBackward(string, this.currentOffset);
    }

    public int getStringIndexBackward(String string, int documentOffset) {
        String text = this.doc.substring(0, documentOffset);
        return text.lastIndexOf(string);
    }

    public int getStringIndexForward(String string) {
        return this.getStringIndexForward(string, this.currentOffset);
    }

    public int getStringIndexForward(String string, int documentOffset) {
        return this.doc.indexOf(string, documentOffset);
    }

    public Map getAllAttsValues() {
        return this.getAllAttsValues(this.currentOffset);
    }

    public Map getAllAttsValues(int documentOffset) {
        HashMap<String, String> result;
        block3: {
            Pattern p;
            Matcher m;
            result = new HashMap<String, String>();
            int start = this.reversed.indexOf(60, this.getReverseOffset(documentOffset));
            start = start != -1 ? this.getReverseOffset(start) : 0;
            int end = this.doc.charAt(documentOffset) == '>' && this.getAttributeName(documentOffset) == null ? documentOffset + 1 : ((m = (p = Pattern.compile("[^\\-]>")).matcher(this.doc)).find(documentOffset) ? m.end() : this.doc.length());
            Pattern regexp = ATTRIBUTE_VALUE_PATTERN;
            try {
                String tag = this.doc.substring(start, end);
                tag = tag.substring(tag.indexOf(32));
                Matcher m2 = regexp.matcher(tag);
                while (m2.find()) {
                    String key = m2.group(1);
                    String val = m2.group(2);
                    result.put(key, val);
                    if (m2.end() + m2.group(0).length() >= tag.length()) continue;
                    tag = tag.substring(m2.end());
                    m2 = regexp.matcher(tag);
                }
            }
            catch (Exception e) {
                if (this.settings == null) break block3;
                this.settings.logError("Something bad happened", e);
            }
        }
        return result;
    }

    public String getQualifier() {
        return this.getQualifier(this.currentOffset);
    }

    public String getQualifier(int documentOffset) {
        Pattern p = QUALIFIER_PATTERN;
        Matcher m = p.matcher(this.reversed);
        if (m.find(this.getReverseOffset(documentOffset))) {
            return this.doc.substring(this.getReverseOffset(m.end()), documentOffset);
        }
        return "";
    }

    public String getAttributeValueQualifier() {
        return this.getAttributeValueQualifier(this.currentOffset);
    }

    public String getAttributeValueQualifier(int documentOffset) {
        int index = this.reversed.indexOf("\"", this.getReverseOffset(documentOffset));
        if (index == -1) {
            return "";
        }
        return this.doc.substring(this.getReverseOffset(index), documentOffset);
    }

    public String getAttributeName() {
        return this.getAttributeName(this.currentOffset);
    }

    public String getAttributeName(int documentOffset) {
        Pattern p = ATTRIBUTE_NAME_PATTERN;
        Matcher m = p.matcher(this.reversed.substring(this.getReverseOffset(documentOffset)));
        if (m.find() && m.start() == 0) {
            String attName = new StringBuffer(m.group(1)).reverse().toString();
            return attName;
        }
        return null;
    }

    public String getParentTagName() {
        return this.getParentTagName(this.currentOffset);
    }

    public String getParentTagName(int documentOffset) {
        int[] indexes = this.getParentTagIndex(documentOffset);
        String foundParent = this.getString(indexes);
        return foundParent == null ? null : foundParent.trim();
    }

    public String getString(int[] indexes) {
        if (indexes != null) {
            return this.doc.substring(indexes[0], indexes[1]);
        }
        return null;
    }

    public String getString(int start, int end) {
        return this.doc.substring(start, end);
    }

    public int[] getParentTagIndex(int documentOffset) {
        int offset;
        if (this.doc.length() <= documentOffset) {
            return null;
        }
        int lastSpaceIndex = offset = documentOffset;
        int parentEndTagIndex = -1;
        boolean parentEndTagReached = false;
        boolean inSimpleTag = false;
        Stack<String> stack = new Stack<String>();
        while (offset > 0) {
            char c;
            if ((c = this.doc.charAt(--offset)) == '>' && this.doc.charAt(offset - 1) != '-') {
                if (this.doc.charAt(offset - 1) != '/') {
                    parentEndTagReached = true;
                    parentEndTagIndex = offset;
                    lastSpaceIndex = offset;
                    continue;
                }
                inSimpleTag = true;
                continue;
            }
            if (c == '<') {
                if (inSimpleTag) {
                    inSimpleTag = false;
                    continue;
                }
                if (this.doc.charAt(offset + 1) == '/') {
                    if (!parentEndTagReached) continue;
                    parentEndTagReached = false;
                    stack.push(this.doc.substring(offset + 2, parentEndTagIndex).trim());
                    lastSpaceIndex = offset + 2;
                    continue;
                }
                if (this.doc.charAt(offset + 1) == '!' || this.doc.charAt(offset + 1) == '?') continue;
                if (!stack.isEmpty()) {
                    String closedName = (String)stack.peek();
                    if (!closedName.equalsIgnoreCase(this.doc.substring(offset + 1, offset + 1 + closedName.length()))) continue;
                    stack.pop();
                    continue;
                }
                if (!parentEndTagReached) continue;
                return new int[]{offset + 1, lastSpaceIndex};
            }
            if (!Character.isWhitespace(c)) continue;
            lastSpaceIndex = offset;
        }
        return null;
    }

    private int getReverseOffset(int documentOffset) {
        return this.doc.length() - documentOffset;
    }

    public int getOffset() {
        return this.currentOffset;
    }

    public int[] getParentTagIndex() {
        return this.getParentTagIndex(this.currentOffset);
    }

    public String getProjectName() {
        return this.projectName;
    }
}

