/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.common.model;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ivy.Ivy;
import org.apache.ivyde.common.model.IvyFile;
import org.apache.ivyde.common.model.IvyModelSettings;
import org.apache.ivyde.common.model.IvyTag;

public abstract class IvyModel {
    private final Map model = new HashMap();
    private Properties defaults;
    private IvyModelSettings settings;
    static /* synthetic */ Class class$0;

    public IvyModel(IvyModelSettings settings) {
        this.loadDefaults();
        this.settings = settings;
    }

    public IvyTag getIvyTag(String tagName, String parentName) {
        Object tag = this.model.get(tagName);
        if (tag instanceof List) {
            List all = (List)tag;
            Iterator iter = all.iterator();
            while (iter.hasNext()) {
                IvyTag t = (IvyTag)iter.next();
                if (t.getParent() == null || !t.getParent().getName().equals(parentName)) continue;
                return t;
            }
            return null;
        }
        return (IvyTag)tag;
    }

    private void loadDefaults() {
        this.defaults = new Properties();
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.apache.ivyde.common.model.IvyModel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.defaults.load(clazz.getResourceAsStream("defaults.properties"));
        }
        catch (IOException e) {
            this.settings.logError("The default properties could not be loaded", e);
        }
    }

    public IvyTag getRootIvyTag() {
        return (IvyTag)this.model.get(this.getRootIvyTagName());
    }

    protected abstract String getRootIvyTagName();

    protected Ivy getIvy() {
        return this.settings.getIvyInstance();
    }

    public IvyModelSettings getSettings() {
        return this.settings;
    }

    protected void addTag(String name, List list) {
        this.model.put(name, list);
    }

    public void addTag(IvyTag ivyTag) {
        if (!this.model.containsKey(ivyTag.getName())) {
            this.model.put(ivyTag.getName(), ivyTag);
            Iterator it = ivyTag.getChilds().iterator();
            while (it.hasNext()) {
                IvyTag child = (IvyTag)it.next();
                this.addTag(child);
            }
        }
    }

    protected String getDefault(String name) {
        return this.defaults.getProperty(name);
    }

    public abstract IvyFile newIvyFile(String var1, String var2, int var3);

    public void refreshIfNeeded(IvyFile file) {
    }

    protected void clearModel() {
        this.model.clear();
    }
}

