/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.internal.eclipse.ui.views;

import org.apache.ivyde.internal.eclipse.IvyPlugin;
import org.apache.ivyde.internal.eclipse.cpcontainer.IvyClasspathContainerImpl;
import org.apache.ivyde.internal.eclipse.handlers.OpenIvyFileHandler;
import org.apache.ivyde.internal.eclipse.revdepexplorer.IvyUtil;
import org.apache.ivyde.internal.eclipse.revdepexplorer.MultiRevDependencyDescriptor;
import org.apache.ivyde.internal.eclipse.revdepexplorer.SyncIvyFilesJob;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class ReverseDependencyExplorerView
extends ViewPart {
    private static final int COLUMN_MIN_WITH = 75;
    private static final int COLUMN_DEFAULT_WEIGHT = 50;
    private static final int COLUMN_LIGHT_WEIGHT = 25;
    private static final RGB LIGHT_GREEEN = new RGB(50, 150, 50);
    private static TreeViewer viewer;
    private static MultiRevDependencyDescriptor[] dependencies;
    private static Display display;
    private static IProject[] selectedProjects;
    private static final String NEW_REVISION = "New Revision";
    private static final String[] PROPS;

    static {
        PROPS = new String[]{"Organization", "Module", "Revision", NEW_REVISION};
    }

    public void createPartControl(Composite parent) {
        display = parent.getDisplay();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        Action syncAction = new Action(){

            public void run() {
                if (MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"Fix dependencies", (String)"Alter dependencies?\n\nAnything marked in green will be synchronized.")) {
                    SyncIvyFilesJob job = new SyncIvyFilesJob(dependencies);
                    job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(this){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void done(IJobChangeEvent arg0) {
                            ReverseDependencyExplorerView.refresh(true);
                        }
                    });
                    job.schedule();
                }
            }
        };
        syncAction.setToolTipText("Synchronize ivy dependencies");
        syncAction.setImageDescriptor(IvyPlugin.getImageDescriptor("icons/synced.gif"));
        Action refreshAction = new Action(){

            public void run() {
                ReverseDependencyExplorerView.refresh(true);
            }
        };
        refreshAction.setToolTipText("Refresh");
        refreshAction.setImageDescriptor(IvyPlugin.getImageDescriptor("icons/refresh.gif"));
        Action refreshAllAction = new Action(){

            public void run() {
                ReverseDependencyExplorerView.setSelectedProjects(null);
                ReverseDependencyExplorerView.refresh(true);
            }
        };
        refreshAllAction.setToolTipText("Show all projects in workspace");
        refreshAllAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_UP"));
        IToolBarManager toolbar = this.getViewSite().getActionBars().getToolBarManager();
        toolbar.add((IAction)syncAction);
        toolbar.add((IAction)refreshAction);
        toolbar.add((IAction)refreshAllAction);
        this.newTreeViewer(composite);
        ReverseDependencyExplorerView.refresh(true);
    }

    private void newTreeViewer(Composite composite) {
        viewer = new TreeViewer(composite, 65536);
        IvyRevisionProvider ivyRevisionProvider = new IvyRevisionProvider();
        viewer.setContentProvider((IContentProvider)ivyRevisionProvider);
        viewer.setLabelProvider((IBaseLabelProvider)ivyRevisionProvider);
        viewer.setColumnProperties(PROPS);
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
                Object element = selection.getFirstElement();
                if (element instanceof CPDependencyDescriptor) {
                    IvyClasspathContainerImpl cp = ((CPDependencyDescriptor)element).container;
                    OpenIvyFileHandler.open(cp);
                }
            }
        });
        Tree tree = viewer.getTree();
        tree.setLayoutData((Object)new GridData(1808));
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 75, true));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 75, true));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(25, 75, true));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 75, true));
        tree.setLayout((Layout)layout);
        new TreeColumn(tree, 16384).setText("Organization");
        new TreeColumn(tree, 16384).setText("Module");
        new TreeColumn(tree, 16384).setText("Revision");
        new TreeColumn(tree, 16384).setText(NEW_REVISION);
        int i = 0;
        int n = tree.getColumnCount();
        while (i < n) {
            tree.getColumn(i).pack();
            ++i;
        }
        tree.setHeaderVisible(true);
        tree.setLinesVisible(false);
        CellEditor[] editors = new CellEditor[PROPS.length];
        editors[0] = new TextCellEditor((Composite)tree);
        editors[1] = new TextCellEditor((Composite)tree);
        editors[2] = new TextCellEditor((Composite)tree);
        editors[3] = new TextCellEditor((Composite)tree);
        viewer.setCellModifier((ICellModifier)new CellModifier());
        viewer.setCellEditors(editors);
    }

    public static void refresh(final boolean reloadData) {
        display.syncExec(new Runnable(){

            public void run() {
                if (reloadData) {
                    if (selectedProjects == null) {
                        dependencies = IvyUtil.getAllDependencyDescriptorsInWorkspace();
                    } else {
                        dependencies = IvyUtil.getDependencyDescriptorsByProjects(selectedProjects);
                    }
                    viewer.setInput((Object)dependencies);
                }
                viewer.refresh();
                TreeItem[] items = viewer.getTree().getItems();
                int i = 0;
                while (i < items.length) {
                    TreeItem item = items[i];
                    MultiRevDependencyDescriptor multiRD = (MultiRevDependencyDescriptor)item.getData();
                    if (multiRD.hasMultipleRevisons() && !multiRD.hasNewRevision()) {
                        item.setForeground(display.getSystemColor(3));
                    } else if (multiRD.hasNewRevision()) {
                        item.setForeground(new Color((Device)Display.getDefault(), LIGHT_GREEEN));
                    } else {
                        item.setForeground(display.getSystemColor(2));
                    }
                    ++i;
                }
            }
        });
    }

    public void setFocus() {
        viewer.getControl().setFocus();
    }

    public static void setSelectedProjects(IProject[] projects) {
        selectedProjects = projects;
    }

    class CPDependencyDescriptor {
        private IvyClasspathContainerImpl container;
        private MultiRevDependencyDescriptor multiRevisionDescriptor;

        public CPDependencyDescriptor(IvyClasspathContainerImpl container, MultiRevDependencyDescriptor multiRevisionDescriptor) {
            this.container = container;
            this.multiRevisionDescriptor = multiRevisionDescriptor;
        }

        public String[] getRevisions() {
            return this.multiRevisionDescriptor.getRevisions(this.container);
        }

        public IvyClasspathContainerImpl getIvyClasspathContainer() {
            return this.container;
        }

        public MultiRevDependencyDescriptor getMultiRevisionDescriptor() {
            return this.multiRevisionDescriptor;
        }
    }

    class CellModifier
    implements ICellModifier {
        CellModifier() {
        }

        public boolean canModify(Object element, String property) {
            return property.equals(ReverseDependencyExplorerView.NEW_REVISION);
        }

        public Object getValue(Object element, String property) {
            if (!property.equals(ReverseDependencyExplorerView.NEW_REVISION) || !(element instanceof MultiRevDependencyDescriptor)) {
                return null;
            }
            MultiRevDependencyDescriptor mrdd = (MultiRevDependencyDescriptor)element;
            String revision = mrdd.getNewRevision();
            if (revision == null) {
                return "";
            }
            return revision;
        }

        public void modify(Object element, String property, Object value) {
            if (element instanceof Item) {
                element = ((Item)element).getData();
            }
            if (element instanceof MultiRevDependencyDescriptor && property.equals(ReverseDependencyExplorerView.NEW_REVISION)) {
                ((MultiRevDependencyDescriptor)element).setNewRevision((String)value);
                ReverseDependencyExplorerView.refresh(false);
            }
        }
    }

    class IvyRevisionProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITreeContentProvider {
        IvyRevisionProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object parent) {
            return dependencies;
        }

        public String getColumnText(Object obj, int index) {
            if (obj instanceof MultiRevDependencyDescriptor) {
                MultiRevDependencyDescriptor mrdd = (MultiRevDependencyDescriptor)obj;
                switch (index) {
                    case 0: {
                        return mrdd.getOrganization();
                    }
                    case 1: {
                        return mrdd.getModule();
                    }
                    case 2: {
                        return this.toRevisionList(mrdd.getRevisions());
                    }
                    case 3: {
                        return mrdd.getNewRevision();
                    }
                }
            } else if (obj instanceof CPDependencyDescriptor) {
                CPDependencyDescriptor containerDescriptorComposite = (CPDependencyDescriptor)obj;
                switch (index) {
                    case 0: {
                        IJavaProject javaProject = containerDescriptorComposite.getIvyClasspathContainer().getConf().getJavaProject();
                        return String.valueOf(containerDescriptorComposite.getIvyClasspathContainer().getDescription()) + (javaProject == null ? "" : " in \"" + javaProject.getElementName() + "\"");
                    }
                    case 2: {
                        return this.toRevisionList(containerDescriptorComposite.getRevisions());
                    }
                }
                return null;
            }
            return null;
        }

        private String toRevisionList(String[] revisions) {
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < revisions.length) {
                buffer.append(revisions[i]);
                if (i + 1 < revisions.length) {
                    buffer.append(", ");
                }
                ++i;
            }
            return buffer.toString();
        }

        public Image getColumnImage(Object obj, int index) {
            if (index == 0) {
                return this.getImage(obj);
            }
            return null;
        }

        public Image getImage(Object obj) {
            ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
            if (obj instanceof MultiRevDependencyDescriptor) {
                MultiRevDependencyDescriptor mrdd = (MultiRevDependencyDescriptor)obj;
                if (mrdd.hasMultipleRevisons() && !mrdd.hasNewRevision()) {
                    return sharedImages.getImage("IMG_OBJS_WARN_TSK");
                }
                return IvyPlugin.getImageDescriptor("icons/synced.gif").createImage();
            }
            if (obj instanceof CPDependencyDescriptor) {
                return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.library_obj.gif");
            }
            return null;
        }

        public Object[] getChildren(Object parent) {
            if (parent instanceof MultiRevDependencyDescriptor) {
                MultiRevDependencyDescriptor mrdd = (MultiRevDependencyDescriptor)parent;
                IvyClasspathContainerImpl[] containers = mrdd.getIvyClasspathContainers();
                Object[] wrappedProjects = new Object[containers.length];
                int i = 0;
                while (i < containers.length) {
                    wrappedProjects[i] = new CPDependencyDescriptor(containers[i], mrdd);
                    ++i;
                }
                return wrappedProjects;
            }
            return new Object[0];
        }

        public Object getParent(Object parent) {
            return null;
        }

        public boolean hasChildren(Object parent) {
            MultiRevDependencyDescriptor mrdd;
            return parent instanceof MultiRevDependencyDescriptor && (mrdd = (MultiRevDependencyDescriptor)parent).getIvyClasspathContainers().length > 0;
        }
    }
}

