/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.internal.eclipse.ui.wizards;

import org.apache.ivyde.internal.eclipse.IvyPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class IvyNewWizardPage
extends WizardPage {
    private Text containerText;
    private Text fileText;
    private Text orgText;
    private Text moduleText;
    private Combo statusText;
    private ISelection selection;

    public IvyNewWizardPage(ISelection selection) {
        super("wizardPage");
        this.setTitle("Ivy File");
        this.setDescription("This wizard creates a new ivy.xml that can be opened by the ivy multi-page editor.");
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        Label label = new Label(container, 0);
        label.setText("&Container:");
        this.containerText = new Text(container, 2052);
        GridData gd = new GridData(768);
        this.containerText.setLayoutData((Object)gd);
        this.containerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IvyNewWizardPage.this.dialogChanged();
            }
        });
        Button button = new Button(container, 8);
        button.setText("Browse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IvyNewWizardPage.this.handleBrowse();
            }
        });
        label = new Label(container, 0);
        label.setText("&File name:");
        this.fileText = new Text(container, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fileText.setLayoutData((Object)gd);
        this.fileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IvyNewWizardPage.this.dialogChanged();
            }
        });
        label = new Label(container, 0);
        label.setText("&Organisation:");
        this.orgText = new Text(container, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.orgText.setLayoutData((Object)gd);
        this.orgText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IvyNewWizardPage.this.dialogChanged();
            }
        });
        label = new Label(container, 0);
        label.setText("&Module name:");
        this.moduleText = new Text(container, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.moduleText.setLayoutData((Object)gd);
        this.moduleText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IvyNewWizardPage.this.dialogChanged();
            }
        });
        label = new Label(container, 0);
        label.setText("&Status:");
        this.statusText = new Combo(container, 12);
        this.statusText.add("integration");
        this.statusText.add("milestone");
        this.statusText.add("release");
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.statusText.setLayoutData((Object)gd);
        this.statusText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IvyNewWizardPage.this.dialogChanged();
            }
        });
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    private void initialize() {
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            if (obj instanceof IResource) {
                IContainer container = obj instanceof IContainer ? (IContainer)obj : ((IResource)obj).getParent();
                this.containerText.setText(container.getFullPath().toString());
                this.moduleText.setText(container.getProject().getName());
            }
        }
        this.fileText.setText("ivy.xml");
        this.statusText.select(0);
        this.orgText.setText(IvyPlugin.getDefault().getPreferenceStore().getString("ivy_org"));
    }

    private void handleBrowse() {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, "Select new file container");
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.containerText.setText(((Path)result[0]).toString());
        }
    }

    private void dialogChanged() {
        String ext;
        IResource container = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.getContainerName()));
        String fileName = this.getFileName();
        if (this.getContainerName().length() == 0) {
            this.updateStatus("File container must be specified");
            return;
        }
        if (container == null || (container.getType() & 6) == 0) {
            this.updateStatus("File container must exist");
            return;
        }
        if (!container.isAccessible()) {
            this.updateStatus("Project must be writable");
            return;
        }
        if (fileName.length() == 0) {
            this.updateStatus("File name must be specified");
            return;
        }
        if (fileName.replace('\\', '/').indexOf(47, 1) > 0) {
            this.updateStatus("File name must be valid");
            return;
        }
        int dotLoc = fileName.lastIndexOf(46);
        if (dotLoc != -1 && !(ext = fileName.substring(dotLoc + 1)).equalsIgnoreCase("xml")) {
            this.updateStatus("File extension must be \".xml\"");
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getContainerName() {
        return this.containerText.getText();
    }

    public String getFileName() {
        return this.fileText.getText();
    }

    public String getOrganisationName() {
        return this.orgText.getText();
    }

    public String getModuleName() {
        return this.moduleText.getText();
    }

    public String getStatus() {
        return this.statusText.getText();
    }
}

