/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.freemarker.model;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.source.ISourceViewer;
import org.jboss.ide.eclipse.freemarker.model.AbstractDirective;
import org.jboss.ide.eclipse.freemarker.model.GenericNestableEndDirective;
import org.jboss.ide.eclipse.freemarker.model.Item;

public class GenericNestableDirective
extends AbstractDirective {
    private String image;
    private String name;
    private GenericNestableEndDirective endDirective;
    private Item[] relatedItems;

    public GenericNestableDirective(String name, String image) {
        this.name = name;
        this.image = image;
    }

    protected void init(ITypedRegion region, ISourceViewer viewer, IResource resource) throws Exception {
    }

    public String getTreeImage() {
        return this.image;
    }

    public Item getStartItem() {
        return this;
    }

    public boolean isNestable() {
        return !this.getContents().trim().endsWith("/");
    }

    public boolean isStartItem() {
        return true;
    }

    public boolean relatesToItem(Item directive) {
        if (directive instanceof GenericNestableEndDirective) {
            return ((GenericNestableEndDirective)directive).getName().equals(this.name);
        }
        return false;
    }

    public void relateItem(Item directive) {
        if (directive instanceof GenericNestableEndDirective) {
            this.endDirective = (GenericNestableEndDirective)directive;
        }
    }

    public String getName() {
        return this.name;
    }

    public Item getEndItem() {
        return this.endDirective;
    }

    public Item[] getRelatedItems() {
        if (this.relatedItems == null) {
            this.relatedItems = this.endDirective != null ? new Item[]{this.endDirective} : new Item[0];
        }
        return this.relatedItems;
    }
}

