/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.maven.core;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.maven.core.MavenUtil;
import com.liferay.ide.maven.core.ThemePluginBuildParticipant;
import java.io.File;
import java.util.Set;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildCSSBuildParticipant
extends ThemePluginBuildParticipant {
    @Override
    public Set<IProject> build(int kind, IProgressMonitor monitor) throws Exception {
        SubProgressMonitor sub = new SubProgressMonitor(monitor, 100);
        sub.beginTask(Msgs.sassToCssBuilder, 100);
        Set<IProject> retval = super.build(kind, monitor);
        sub.done();
        return retval;
    }

    @Override
    protected void configureExecution(IMavenProjectFacade facade, Xpp3Dom config) {
        super.configureExecution(facade, config);
        IPath m2eLiferayFolder = MavenUtil.getM2eLiferayFolder(facade.getMavenProject(), facade.getProject());
        IPath themeResourcesFolder = m2eLiferayFolder.append("theme-resources");
        File projectDir = new File(facade.getProject().getLocationURI());
        File themeResourcesDir = new File(projectDir, themeResourcesFolder.toOSString());
        MavenUtil.setConfigValue(config, "sassDirNames", themeResourcesDir.getAbsolutePath());
    }

    @Override
    protected String getGoal() {
        return "liferay:build-css";
    }

    @Override
    protected boolean shouldBuild(int kind, IMavenProjectFacade facade) {
        boolean retval = false;
        IResourceDelta delta = this.getDelta(facade.getProject());
        String warSourceDirectory = MavenUtil.getWarSouceDirectory(facade);
        if (!CoreUtil.isNullOrEmpty((String)warSourceDirectory)) {
            IPath cssFolderPath = facade.getProject().getFolder(String.valueOf(warSourceDirectory) + "/css").getProjectRelativePath();
            if (delta != null) {
                delta.findMember(cssFolderPath);
            }
        }
        return retval;
    }

    private static class Msgs
    extends NLS {
        public static String sassToCssBuilder;

        static {
            Msgs.initializeMessages((String)BuildCSSBuildParticipant.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

