/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.maven.core;

import com.liferay.ide.core.util.NodeUtil;
import com.liferay.ide.maven.core.LiferayMavenCore;
import com.liferay.ide.project.core.model.NewLiferayProfile;
import com.liferay.ide.server.core.ILiferayRuntime;
import com.liferay.ide.server.util.ServerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.cli.MavenCli;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.lifecycle.MavenExecutionPlan;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.embedder.IMavenConfiguration;
import org.eclipse.m2e.core.embedder.IMavenExecutionContext;
import org.eclipse.m2e.core.embedder.MavenRuntimeManager;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.core.project.ResolverConfiguration;
import org.eclipse.m2e.wtp.ProjectUtils;
import org.eclipse.m2e.wtp.WarPluginConfiguration;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.xml.core.internal.provisional.format.NodeFormatter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MavenUtil {
    public static Node createNewLiferayProfileNode(Document pomDocument, NewLiferayProfile newLiferayProfile, String pluginVersion) {
        Element newNode = null;
        String liferayVersion = (String)newLiferayProfile.getLiferayVersion().content();
        try {
            String runtimeName = (String)newLiferayProfile.getRuntimeName().content();
            ILiferayRuntime liferayRuntime = ServerUtil.getLiferayRuntime((IRuntime)ServerUtil.getRuntime((String)runtimeName));
            Element root = pomDocument.getDocumentElement();
            Element profiles = NodeUtil.findChildElement((Element)root, (String)"profiles");
            if (profiles == null) {
                newNode = profiles = NodeUtil.appendChildElement((Element)root, (String)"profiles");
            }
            Element newProfile = null;
            if (profiles != null) {
                NodeUtil.appendTextNode((Element)profiles, (String)"\n");
                newProfile = NodeUtil.appendChildElement((Element)profiles, (String)"profile");
                NodeUtil.appendTextNode((Element)profiles, (String)"\n");
                if (newNode == null) {
                    newNode = newProfile;
                }
            }
            if (newProfile != null) {
                IPath autoDeployDir = liferayRuntime.getAppServerDir().removeLastSegments(1).append("deploy");
                NodeUtil.appendTextNode((Element)newProfile, (String)"\n\t");
                NodeUtil.appendChildElement((Element)newProfile, (String)"id", (String)((String)newLiferayProfile.getId().content()));
                NodeUtil.appendTextNode((Element)newProfile, (String)"\n\t");
                Element propertiesElement = NodeUtil.appendChildElement((Element)newProfile, (String)"properties");
                NodeUtil.appendTextNode((Element)newProfile, (String)"\n\t");
                NodeUtil.appendTextNode((Element)propertiesElement, (String)"\n\t\t");
                NodeUtil.appendChildElement((Element)propertiesElement, (String)"liferay.version", (String)liferayVersion);
                NodeUtil.appendTextNode((Element)propertiesElement, (String)"\n\t\t");
                NodeUtil.appendChildElement((Element)propertiesElement, (String)"liferay.maven.plugin.version", (String)pluginVersion);
                NodeUtil.appendTextNode((Element)propertiesElement, (String)"\n\t\t");
                NodeUtil.appendChildElement((Element)propertiesElement, (String)"liferay.auto.deploy.dir", (String)autoDeployDir.toOSString());
                NodeUtil.appendTextNode((Element)propertiesElement, (String)"\n\t\t");
                NodeUtil.appendChildElement((Element)propertiesElement, (String)"liferay.app.server.deploy.dir", (String)liferayRuntime.getAppServerDeployDir().toOSString());
                NodeUtil.appendTextNode((Element)propertiesElement, (String)"\n\t\t");
                NodeUtil.appendChildElement((Element)propertiesElement, (String)"liferay.app.server.lib.global.dir", (String)liferayRuntime.getAppServerLibGlobalDir().toOSString());
                NodeUtil.appendTextNode((Element)propertiesElement, (String)"\n\t\t");
                NodeUtil.appendChildElement((Element)propertiesElement, (String)"liferay.app.server.portal.dir", (String)liferayRuntime.getAppServerPortalDir().toOSString());
                NodeUtil.appendTextNode((Element)propertiesElement, (String)"\n\t");
                NodeFormatter formatter = new NodeFormatter();
                formatter.format((Node)newNode);
            }
        }
        catch (Exception e) {
            LiferayMavenCore.logError("Unable to add new liferay profile.", e);
        }
        return newNode;
    }

    public static IStatus executeMojoGoal(IMavenProjectFacade projectFacade, IMavenExecutionContext context, String goal, IProgressMonitor monitor) throws CoreException {
        List exceptions;
        IStatus retval = null;
        IMaven maven = MavenPlugin.getMaven();
        List<String> goals = Collections.singletonList(goal);
        MavenExecutionPlan plan = maven.calculateExecutionPlan(projectFacade.getMavenProject(), goals, true, monitor);
        MojoExecution liferayMojoExecution = MavenUtil.getExecution(plan, "liferay-maven-plugin");
        if (liferayMojoExecution != null) {
            ResolverConfiguration configuration = projectFacade.getResolverConfiguration();
            configuration.setResolveWorkspaceProjects(true);
            maven.execute(projectFacade.getMavenProject(), liferayMojoExecution, monitor);
        }
        if ((exceptions = context.getSession().getResult().getExceptions()).size() == 1) {
            retval = LiferayMavenCore.createErrorStatus((Throwable)exceptions.get(0));
        } else if (exceptions.size() > 1) {
            ArrayList<IStatus> statues = new ArrayList<IStatus>();
            for (Throwable t : exceptions) {
                statues.add(LiferayMavenCore.createErrorStatus(t));
            }
            IStatus firstStatus = (IStatus)statues.get(0);
            retval = new MultiStatus("com.liferay.ide.maven.core", 4, statues.toArray(new IStatus[0]), firstStatus.getMessage(), firstStatus.getException());
        }
        return retval == null ? Status.OK_STATUS : retval;
    }

    public static MojoExecution getExecution(MavenExecutionPlan plan, String artifactId) {
        if (plan != null) {
            for (MojoExecution execution : plan.getMojoExecutions()) {
                if (!artifactId.equals(execution.getArtifactId())) continue;
                return execution;
            }
        }
        return null;
    }

    public static IFolder getGeneratedThemeResourcesFolder(MavenProject mavenProject, IProject project) {
        IPath m2eLiferayFolder = MavenUtil.getM2eLiferayFolder(mavenProject, project);
        return project.getFolder(m2eLiferayFolder).getFolder("theme-resources");
    }

    public static Plugin getLiferayMavenPlugin(MavenProject mavenProject) {
        Plugin retval = null;
        if (mavenProject != null) {
            retval = mavenProject.getPlugin("com.liferay.maven.plugins:liferay-maven-plugin");
        }
        if (retval == null) {
            retval = (Plugin)mavenProject.getPluginManagement().getPluginsAsMap().get("com.liferay.maven.plugins:liferay-maven-plugin");
        }
        return retval;
    }

    public static Xpp3Dom getLiferayMavenPluginConfig(MavenProject mavenProject) {
        Plugin plugin;
        Xpp3Dom retval = null;
        if (mavenProject != null && (plugin = mavenProject.getPlugin("com.liferay.maven.plugins:liferay-maven-plugin")) != null) {
            retval = (Xpp3Dom)plugin.getConfiguration();
        }
        return retval;
    }

    public static String getLiferayMavenPluginConfig(MavenProject mavenProject, String childElement) {
        Xpp3Dom childNode;
        String retval = null;
        Xpp3Dom liferayMavenPluginConfig = MavenUtil.getLiferayMavenPluginConfig(mavenProject);
        if (liferayMavenPluginConfig != null && (childNode = liferayMavenPluginConfig.getChild(childElement)) != null) {
            retval = childNode.getValue();
        }
        return retval;
    }

    public static String getLiferayMavenPluginType(MavenProject mavenProject) {
        String pluginType = MavenUtil.getLiferayMavenPluginConfig(mavenProject, "pluginType");
        if (pluginType == null) {
            pluginType = "portlet";
        }
        return pluginType;
    }

    public static String getLocalRepositoryDir() {
        String retval = null;
        IMavenConfiguration mavenConfiguration = MavenPlugin.getMavenConfiguration();
        String userSettings = mavenConfiguration.getUserSettingsFile();
        if (userSettings == null || userSettings.length() == 0) {
            userSettings = MavenCli.DEFAULT_USER_SETTINGS_FILE.getAbsolutePath();
        }
        MavenRuntimeManager runtimeManager = MavenPlugin.getMavenRuntimeManager();
        String globalSettings = runtimeManager.getGlobalSettingsFile();
        IMaven maven = MavenPlugin.getMaven();
        try {
            Settings settings = maven.buildSettings(globalSettings, userSettings);
            retval = settings.getLocalRepository();
        }
        catch (CoreException e) {
            LiferayMavenCore.logError("Unable to get local repository dir.", e);
        }
        if (retval == null) {
            retval = RepositorySystem.defaultUserLocalRepository.getAbsolutePath();
        }
        return retval;
    }

    public static IPath getM2eLiferayFolder(MavenProject mavenProject, IProject project) {
        String buildOutputDir = mavenProject.getBuild().getDirectory();
        String relativeBuildOutputDir = ProjectUtils.getRelativePath((IProject)project, (String)buildOutputDir);
        return new Path(relativeBuildOutputDir).append("m2e-liferay");
    }

    public static IMavenProjectFacade getProjectFacade(IProject project) {
        return MavenUtil.getProjectFacade(project, (IProgressMonitor)new NullProgressMonitor());
    }

    public static IMavenProjectFacade getProjectFacade(IProject project, IProgressMonitor monitor) {
        IMavenProjectRegistry projectManager = MavenPlugin.getMavenProjectRegistry();
        IFile pomResource = project.getFile("pom.xml");
        IMavenProjectFacade projectFacade = projectManager.create(project, monitor);
        if (projectFacade == null || projectFacade.isStale()) {
            try {
                projectManager.refresh(Collections.singleton(pomResource), monitor);
            }
            catch (CoreException e) {
                LiferayMavenCore.logError(e);
            }
            projectFacade = projectManager.create(project, monitor);
        }
        return projectFacade;
    }

    public static String getVersion(String version) {
        DefaultArtifactVersion v = new DefaultArtifactVersion(version);
        return String.valueOf(v.getMajorVersion()) + "." + v.getMinorVersion() + "." + v.getIncrementalVersion();
    }

    public static String getWarSouceDirectory(IMavenProjectFacade facade) {
        MavenProject mavenProject = facade.getMavenProject();
        IProject project = facade.getProject();
        return new WarPluginConfiguration(mavenProject, project).getWarSourceDirectory();
    }

    public static boolean isMavenProject(IProject project) throws CoreException {
        return project != null && project.exists() && (project.hasNature("org.eclipse.m2e.core.maven2Nature") || project.getFile("pom.xml").exists());
    }

    public static boolean isPomFile(IFile pomFile) {
        return pomFile != null && pomFile.exists() && "pom.xml".equals(pomFile.getName()) && pomFile.getParent() instanceof IProject;
    }

    public static boolean loadParentHierarchy(IMaven maven, IMavenProjectFacade facade, IMavenExecutionContext context, IProgressMonitor monitor) throws CoreException {
        boolean loadedParent = false;
        MavenProject mavenProject = facade.getMavenProject();
        try {
            if (mavenProject.getModel().getParent() == null || mavenProject.getParent() != null) {
                return false;
            }
        }
        catch (IllegalStateException illegalStateException) {}
        MavenExecutionRequest request = null;
        while (mavenProject != null && mavenProject.getModel().getParent() != null) {
            MavenProject parentProject;
            if (monitor.isCanceled()) break;
            if (request == null) {
                request = context.getExecutionRequest();
            }
            if ((parentProject = maven.resolveParentProject(mavenProject, monitor)) != null) {
                mavenProject.setParent(parentProject);
                loadedParent = true;
            }
            mavenProject = parentProject;
        }
        return loadedParent;
    }

    public static void setConfigValue(Xpp3Dom configuration, String childName, Object value) {
        Xpp3Dom childNode = configuration.getChild(childName);
        if (childNode == null) {
            childNode = new Xpp3Dom(childName);
            configuration.addChild(childNode);
        }
        childNode.setValue(value == null ? null : value.toString());
    }
}

