/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.maven.core;

import com.liferay.ide.maven.core.LiferayMavenCore;
import com.liferay.ide.maven.core.MavenUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.maven.lifecycle.MavenExecutionPlan;
import org.apache.maven.plugin.MojoExecution;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ICallable;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.embedder.IMavenExecutionContext;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.core.project.ResolverConfiguration;
import org.eclipse.m2e.core.project.configurator.AbstractBuildParticipant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ThemePluginBuildParticipant
extends AbstractBuildParticipant {
    protected final IMaven maven = MavenPlugin.getMaven();
    protected final IMavenProjectRegistry projectManager = MavenPlugin.getMavenProjectRegistry();

    public Set<IProject> build(int kind, IProgressMonitor monitor) throws Exception {
        final IMavenProjectFacade facade = this.getMavenProjectFacade();
        if (!this.shouldBuild(kind, facade)) {
            return null;
        }
        ICallable<IStatus> callable = new ICallable<IStatus>(){

            public IStatus call(IMavenExecutionContext context, IProgressMonitor monitor) throws CoreException {
                return ThemePluginBuildParticipant.this.executeThemeMojo(facade, context, monitor);
            }
        };
        IStatus retval = null;
        try {
            retval = this.executeMaven(facade, callable, monitor);
        }
        catch (Exception e) {
            retval = LiferayMavenCore.createErrorStatus(String.valueOf(this.getGoal()) + " build error", e);
        }
        if (retval != null && !retval.isOK()) {
            LiferayMavenCore.log(retval);
        }
        try {
            facade.getProject().refreshLocal(2, monitor);
        }
        catch (CoreException coreException) {}
        monitor.worked(10);
        return null;
    }

    protected void configureExecution(IMavenProjectFacade facade, Xpp3Dom config) {
        IPath m2eLiferayFolder = MavenUtil.getM2eLiferayFolder(facade.getMavenProject(), facade.getProject());
        IPath themeResourcesFolder = m2eLiferayFolder.append("theme-resources");
        String targetFolderValue = themeResourcesFolder.toPortableString();
        MavenUtil.setConfigValue(config, "webappDir", targetFolderValue);
    }

    protected IStatus executeMaven(final IMavenProjectFacade projectFacade, final ICallable<IStatus> callable, IProgressMonitor monitor) throws CoreException {
        return (IStatus)this.maven.execute((ICallable)new ICallable<IStatus>(){

            public IStatus call(IMavenExecutionContext context, IProgressMonitor monitor) throws CoreException {
                return (IStatus)ThemePluginBuildParticipant.this.projectManager.execute(projectFacade, callable, monitor);
            }
        }, monitor);
    }

    protected IStatus executeThemeMojo(IMavenProjectFacade facade, IMavenExecutionContext context, IProgressMonitor monitor) throws CoreException {
        IStatus retval = null;
        List<String> goals = Collections.singletonList(this.getGoal());
        MavenExecutionPlan plan = this.maven.calculateExecutionPlan(facade.getMavenProject(), goals, true, monitor);
        monitor.worked(10);
        MojoExecution liferayMojoExecution = MavenUtil.getExecution(plan, "liferay-maven-plugin");
        Xpp3Dom originalConfig = liferayMojoExecution.getConfiguration();
        Xpp3Dom config = Xpp3DomUtils.mergeXpp3Dom((Xpp3Dom)new Xpp3Dom("configuration"), (Xpp3Dom)originalConfig);
        this.configureExecution(facade, config);
        boolean parentHierarchyLoaded = false;
        try {
            try {
                parentHierarchyLoaded = MavenUtil.loadParentHierarchy(this.maven, facade, context, monitor);
                monitor.worked(10);
                ResolverConfiguration configuration = facade.getResolverConfiguration();
                configuration.setResolveWorkspaceProjects(true);
                liferayMojoExecution.setConfiguration(config);
                this.maven.execute(facade.getMavenProject(), liferayMojoExecution, monitor);
                monitor.worked(50);
                List exceptions = context.getSession().getResult().getExceptions();
                if (exceptions.size() == 1) {
                    retval = LiferayMavenCore.createErrorStatus((Throwable)exceptions.get(0));
                } else if (exceptions.size() > 1) {
                    ArrayList<IStatus> statuses = new ArrayList<IStatus>();
                    for (Throwable t : exceptions) {
                        statuses.add(LiferayMavenCore.createErrorStatus(t));
                    }
                    retval = LiferayMavenCore.createMultiStatus(4, statuses.toArray(new IStatus[0]));
                }
                retval = retval == null ? Status.OK_STATUS : retval;
            }
            catch (CoreException e) {
                retval = LiferayMavenCore.createErrorStatus(e);
                liferayMojoExecution.setConfiguration(originalConfig);
                if (parentHierarchyLoaded) {
                    facade.getMavenProject().setParent(null);
                }
            }
        }
        finally {
            liferayMojoExecution.setConfiguration(originalConfig);
            if (parentHierarchyLoaded) {
                facade.getMavenProject().setParent(null);
            }
        }
        return retval;
    }

    protected abstract String getGoal();

    protected abstract boolean shouldBuild(int var1, IMavenProjectFacade var2);
}

