/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.maven.core.aether;

import com.liferay.ide.maven.core.LiferayMavenCore;
import com.liferay.ide.maven.core.MavenUtil;
import com.liferay.ide.maven.core.aether.ConsoleRepositoryListener;
import com.liferay.ide.maven.core.aether.ConsoleTransferListener;
import java.util.List;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.aether.version.Version;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.m2e.core.internal.MavenPluginActivator;

public class AetherUtil {
    public static RemoteRepository newCentralRepository() {
        return new RemoteRepository.Builder("central", "default", "http://repo1.maven.org/maven2/").build();
    }

    public static RemoteRepository newLiferayRepository() {
        return new RemoteRepository.Builder("liferay", "default", "https://repository.liferay.com/nexus/content/groups/public/").build();
    }

    public static RepositorySystem newRepositorySystem() {
        return MavenPluginActivator.getDefault().getRepositorySystem();
    }

    public static DefaultRepositorySystemSession newRepositorySystemSession(RepositorySystem system) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        LocalRepository localRepo = new LocalRepository(MavenUtil.getLocalRepositoryDir());
        session.setLocalRepositoryManager(system.newLocalRepositoryManager((RepositorySystemSession)session, localRepo));
        session.setTransferListener((TransferListener)new ConsoleTransferListener());
        session.setRepositoryListener((RepositoryListener)new ConsoleRepositoryListener());
        return session;
    }

    public static Artifact getLatestAvailableLiferayArtifact(String groupId, String artifactId) {
        Artifact retval = null;
        RepositorySystem system = AetherUtil.newRepositorySystem();
        DefaultRepositorySystemSession session = AetherUtil.newRepositorySystemSession(system);
        String latestVersion = AetherUtil.getLatestVersion(groupId, artifactId, "6", "6.2.0-RC5", system, (RepositorySystemSession)session);
        DefaultArtifact defaultArtifact = new DefaultArtifact(String.valueOf(groupId) + ":" + artifactId + ":" + latestVersion);
        ArtifactRequest artifactRequest = new ArtifactRequest();
        artifactRequest.setArtifact((Artifact)defaultArtifact);
        artifactRequest.addRepository(AetherUtil.newCentralRepository());
        try {
            ArtifactResult artifactResult = system.resolveArtifact((RepositorySystemSession)session, artifactRequest);
            retval = artifactResult.getArtifact();
        }
        catch (ArtifactResolutionException e) {
            LiferayMavenCore.logError("Unable to get latest Liferay archetype", e);
        }
        if (retval == null) {
            retval = defaultArtifact;
        }
        return retval;
    }

    public static String getLatestVersion(String group, String artifactId, String startVersion, String defaultVersion, RepositorySystem system, RepositorySystemSession session) {
        String retval = null;
        DefaultArtifact artifact = new DefaultArtifact(String.valueOf(group) + ":" + artifactId + ":[" + startVersion + ",)");
        VersionRangeRequest rangeRequest = new VersionRangeRequest();
        rangeRequest.setArtifact((Artifact)artifact);
        rangeRequest.addRepository(AetherUtil.newCentralRepository());
        try {
            VersionRangeResult rangeResult = system.resolveVersionRange(session, rangeRequest);
            Version newestVersion = rangeResult.getHighestVersion();
            List versions = rangeResult.getVersions();
            if (versions.size() > 1 && newestVersion.toString().endsWith("-SNAPSHOT") && !AetherUtil.shouldUseSnapshotVersions()) {
                retval = ((Version)versions.get(versions.size() - 2)).toString();
            } else if (newestVersion != null) {
                retval = newestVersion.toString();
            }
        }
        catch (VersionRangeResolutionException e) {
            LiferayMavenCore.logError("Unable to get latest artifact version.", e);
        }
        if (retval == null) {
            retval = defaultVersion;
        }
        return retval;
    }

    private static boolean shouldUseSnapshotVersions() {
        IScopeContext[] prefContexts = new IScopeContext[]{DefaultScope.INSTANCE, InstanceScope.INSTANCE};
        return Platform.getPreferencesService().getBoolean("com.liferay.ide.project.core", "use-snapshot-version", false, prefContexts);
    }
}

