/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.eclipse.cp;

import java.util.Arrays;
import java.util.List;
import org.apache.ivyde.eclipse.cp.AdvancedSetup;
import org.apache.ivyde.eclipse.cp.ClasspathSetup;
import org.apache.ivyde.eclipse.cp.MappingSetup;
import org.apache.ivyde.eclipse.cp.SettingsSetup;
import org.apache.ivyde.internal.eclipse.IvyPlugin;
import org.apache.ivyde.internal.eclipse.cpcontainer.IvyClasspathContainerConfAdapter;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IJavaProject;

public class IvyClasspathContainerConfiguration {
    private IJavaProject javaProject;
    private String ivyXmlPath;
    private List confs = Arrays.asList("*");
    private SettingsSetup settingsSetup = new SettingsSetup();
    private ClasspathSetup classpathSetup = new ClasspathSetup();
    private MappingSetup mappingSetup = new MappingSetup();
    private AdvancedSetup advancedSetup = new AdvancedSetup();
    private boolean settingsProjectSpecific;
    private boolean classthProjectSpecific;
    private boolean mappingProjectSpecific;
    private boolean advancedProjectSpecific;
    private IClasspathAttribute[] attributes = new IClasspathAttribute[0];

    public IvyClasspathContainerConfiguration(IJavaProject javaProject, String ivyXmlPath, boolean editing) {
        this.javaProject = javaProject;
        this.ivyXmlPath = ivyXmlPath;
    }

    public IvyClasspathContainerConfiguration(IJavaProject javaProject, IPath path, boolean editing, IClasspathAttribute[] attributes) {
        this.javaProject = javaProject;
        IvyClasspathContainerConfAdapter.load(this, path, attributes);
    }

    public IPath getPath() {
        return IvyClasspathContainerConfAdapter.getPath(this);
    }

    public String getIvyXmlPath() {
        return this.ivyXmlPath;
    }

    public void setIvyXmlPath(String ivyXmlPath) {
        this.ivyXmlPath = ivyXmlPath;
    }

    public List getConfs() {
        return this.confs;
    }

    public void setConfs(List confs) {
        this.confs = confs;
    }

    public SettingsSetup getIvySettingsSetup() {
        return this.settingsSetup;
    }

    public void setIvySettingsSetup(SettingsSetup ivySettingsSetup) {
        this.settingsSetup = ivySettingsSetup;
    }

    public ClasspathSetup getClasspathSetup() {
        return this.classpathSetup;
    }

    public void setClasspathSetup(ClasspathSetup classpathSetup) {
        this.classpathSetup = classpathSetup;
    }

    public MappingSetup getMappingSetup() {
        return this.mappingSetup;
    }

    public void setMappingSetup(MappingSetup mappingSetup) {
        this.mappingSetup = mappingSetup;
    }

    public AdvancedSetup getAdvancedSetup() {
        return this.advancedSetup;
    }

    public void setAdvancedSetup(AdvancedSetup advancedSetup) {
        this.advancedSetup = advancedSetup;
    }

    public boolean isClassthProjectSpecific() {
        return this.classthProjectSpecific;
    }

    public void setClassthProjectSpecific(boolean classthProjectSpecific) {
        this.classthProjectSpecific = classthProjectSpecific;
    }

    public boolean isMappingProjectSpecific() {
        return this.mappingProjectSpecific;
    }

    public void setMappingProjectSpecific(boolean mappingProjectSpecific) {
        this.mappingProjectSpecific = mappingProjectSpecific;
    }

    public boolean isSettingsProjectSpecific() {
        return this.settingsProjectSpecific;
    }

    public void setSettingsProjectSpecific(boolean isSettingsProjectSpecific) {
        this.settingsProjectSpecific = isSettingsProjectSpecific;
    }

    public boolean isAdvancedProjectSpecific() {
        return this.advancedProjectSpecific;
    }

    public void setAdvancedProjectSpecific(boolean advancedProjectSpecific) {
        this.advancedProjectSpecific = advancedProjectSpecific;
    }

    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    public void setProject(IJavaProject javaProject) {
        this.javaProject = javaProject;
    }

    public void setAttributes(IClasspathAttribute[] attributes) {
        this.attributes = attributes;
    }

    public IClasspathAttribute[] getAttributes() {
        return this.attributes;
    }

    public IProject getProject() {
        if (this.javaProject == null) {
            return null;
        }
        return this.javaProject.getProject();
    }

    public SettingsSetup getInheritedSettingsSetup() {
        if (!this.settingsProjectSpecific) {
            return IvyPlugin.getPreferenceStoreHelper().getSettingsSetup();
        }
        return this.settingsSetup;
    }

    public ClasspathSetup getInheritedClasspathSetup() {
        if (!this.classthProjectSpecific) {
            return IvyPlugin.getPreferenceStoreHelper().getClasspathSetup();
        }
        return this.classpathSetup;
    }

    public MappingSetup getInheritedMappingSetup() {
        if (!this.mappingProjectSpecific) {
            return IvyPlugin.getPreferenceStoreHelper().getMappingSetup();
        }
        return this.mappingSetup;
    }

    public AdvancedSetup getInheritedAdvancedSetup() {
        if (!this.advancedProjectSpecific) {
            return IvyPlugin.getPreferenceStoreHelper().getAdvancedSetup();
        }
        return this.advancedSetup;
    }

    public String toString() {
        return String.valueOf(this.ivyXmlPath) + this.confs + (this.javaProject == null ? "" : " in '" + this.javaProject.getProject().getName() + "'");
    }
}

