/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.internal.eclipse.retrieve;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.ivyde.internal.eclipse.IvyPlugin;
import org.apache.ivyde.internal.eclipse.retrieve.StandaloneRetrieveSerializer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;

public class RetrieveSetupManager
implements ISaveParticipant {
    private static final String PREF_ID = "org.apache.ivyde.eclipse.standaloneretrieve";
    private Map projectPrefs = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List getSetup(IProject project) throws IOException {
        List retrieveSetups;
        String retrieveSetup;
        IEclipsePreferences pref;
        Map map = this.projectPrefs;
        synchronized (map) {
            pref = (IEclipsePreferences)this.projectPrefs.get(project);
        }
        if (pref == null) {
            ProjectScope projectScope = new ProjectScope(project);
            pref = projectScope.getNode("org.apache.ivyde.eclipse");
        }
        if ((retrieveSetup = pref.get(PREF_ID, null)) == null) {
            return new ArrayList();
        }
        StandaloneRetrieveSerializer serializer = new StandaloneRetrieveSerializer();
        ByteArrayInputStream in = new ByteArrayInputStream(retrieveSetup.getBytes());
        try {
            retrieveSetups = serializer.read(in, project);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        try {}
        catch (IOException iOException) {
            return retrieveSetups;
        }
        in.close();
        return retrieveSetups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void save(IProject project, List retrieveSetups) throws IOException {
        StandaloneRetrieveSerializer serializer = new StandaloneRetrieveSerializer();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            serializer.write(out, retrieveSetups);
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            try {
                out.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var5_8 = null;
        }
        try {}
        catch (IOException iOException) {}
        out.close();
        String retrieveSetup = new String(out.toByteArray());
        Map map = this.projectPrefs;
        synchronized (map) {
            IEclipsePreferences pref = (IEclipsePreferences)this.projectPrefs.get(project);
            if (pref == null) {
                ProjectScope projectScope = new ProjectScope(project);
                pref = projectScope.getNode("org.apache.ivyde.eclipse");
                this.projectPrefs.put(project, pref);
            }
            pref.put(PREF_ID, retrieveSetup);
            return;
        }
    }

    public void prepareToSave(ISaveContext context) throws CoreException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saving(ISaveContext context) throws CoreException {
        HashMap toFlush = new HashMap();
        Map map = this.projectPrefs;
        synchronized (map) {
            toFlush.putAll(this.projectPrefs);
            this.projectPrefs.clear();
        }
        Iterator itPrefs = toFlush.entrySet().iterator();
        while (itPrefs.hasNext()) {
            Map.Entry entry = itPrefs.next();
            try {
                ((IEclipsePreferences)entry.getValue()).flush();
            }
            catch (BackingStoreException e) {
                IvyPlugin.logError("Failed to save the state of the Ivy preferences of " + ((IProject)entry.getKey()).getName(), e);
            }
        }
    }

    public void rollback(ISaveContext context) {
    }

    public void doneSaving(ISaveContext context) {
    }
}

