/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.internal.eclipse.ui;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class DecorationOverlayIcon
extends CompositeImageDescriptor {
    private Image baseImage;
    private Point size;
    private final ImageDescriptor overlayImage;

    public DecorationOverlayIcon(Image baseImage, ImageDescriptor overlayImage, int quadrant) {
        this.baseImage = baseImage;
        this.overlayImage = overlayImage;
        this.size = new Point(baseImage.getBounds().width, baseImage.getBounds().height);
    }

    protected void drawCompositeImage(int width, int height) {
        this.drawImage(this.baseImage.getImageData(), 0, 0);
        ImageData overlayData = this.overlayImage.getImageData();
        if (overlayData == null) {
            overlayData = ImageDescriptor.getMissingImageDescriptor().getImageData();
        }
        this.drawImage(overlayData, 0, this.size.y - overlayData.height);
    }

    protected Point getSize() {
        return this.size;
    }

    protected int getTransparentPixel() {
        return this.baseImage.getImageData().transparentPixel;
    }
}

