/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.internal.eclipse.ui.console;

import java.util.ArrayList;
import java.util.List;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.MessageLogger;
import org.apache.ivy.util.MessageLoggerHelper;
import org.apache.ivyde.internal.eclipse.IvyPlugin;
import org.apache.ivyde.internal.eclipse.ui.console.ConsoleDocument;
import org.apache.ivyde.internal.eclipse.ui.console.IvyConsoleFactory;
import org.apache.ivyde.internal.eclipse.ui.console.IvyDEMessageLogger;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleListener;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class IvyConsole
extends MessageConsole
implements MessageLogger {
    public static final String PREF_CONSOLE_DEBUG_COLOR = "org.apache.ivyde.eclipse.console.color.debug";
    public static final String PREF_CONSOLE_VERBOSE_COLOR = "org.apache.ivyde.eclipse.console.color.verbose";
    public static final String PREF_CONSOLE_INFO_COLOR = "org.apache.ivyde.eclipse.console.color.info";
    public static final String PREF_CONSOLE_WARN_COLOR = "org.apache.ivyde.eclipse.console.color.warn";
    public static final String PREF_CONSOLE_ERROR_COLOR = "org.apache.ivyde.eclipse.console.color.error";
    private MessageConsoleStream[] streams = new MessageConsoleStream[5];
    private ConsoleDocument document;
    private boolean initialized = false;
    private boolean visible = false;
    private boolean showOnMessage;
    private IConsoleManager consoleManager;
    private int logLevel;
    private IvyDEMessageLogger ivyDEMessageLogger;
    private List problems = new ArrayList();
    private List warns = new ArrayList();
    private List errors = new ArrayList();
    private boolean showProgress = true;

    public IvyConsole() {
        this("Ivy", IvyPlugin.getImageDescriptor("icons/logo16x16.gif"));
    }

    public IvyConsole(String name, ImageDescriptor imageDescriptor) {
        super(name, imageDescriptor);
        this.consoleManager = ConsolePlugin.getDefault().getConsoleManager();
        this.document = new ConsoleDocument();
        Message.setDefaultLogger((MessageLogger)this);
        this.logLevel = IvyPlugin.getPreferenceStoreHelper().getIvyConsoleLogLevel();
        this.ivyDEMessageLogger = new IvyDEMessageLogger(this);
    }

    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
        IvyPlugin.getPreferenceStoreHelper().setIvyConsoleLogLevel(logLevel);
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public IvyDEMessageLogger getIvyDEMessageLogger() {
        return this.ivyDEMessageLogger;
    }

    public void endProgress(String msg) {
    }

    public void progress() {
    }

    public void log(String msg, int level) {
        this.appendLine(level, msg);
    }

    public void rawlog(String msg, int level) {
        this.appendLine(level, msg);
    }

    protected void init() {
        super.init();
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                IvyConsole.this.initializeStreams();
                IvyConsole.this.dump();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeStreams() {
        ConsoleDocument consoleDocument = this.document;
        synchronized (consoleDocument) {
            if (!this.initialized) {
                int i = 0;
                while (i < this.streams.length) {
                    this.streams[i] = this.newMessageStream();
                    ++i;
                }
                Color color = this.createColor(Display.getDefault(), PREF_CONSOLE_DEBUG_COLOR);
                this.streams[4].setColor(color);
                color = this.createColor(Display.getDefault(), PREF_CONSOLE_VERBOSE_COLOR);
                this.streams[3].setColor(color);
                color = this.createColor(Display.getDefault(), PREF_CONSOLE_INFO_COLOR);
                this.streams[2].setColor(color);
                color = this.createColor(Display.getDefault(), PREF_CONSOLE_WARN_COLOR);
                this.streams[1].setColor(color);
                color = this.createColor(Display.getDefault(), PREF_CONSOLE_ERROR_COLOR);
                this.streams[0].setColor(color);
                this.initialized = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dump() {
        ConsoleDocument consoleDocument = this.document;
        synchronized (consoleDocument) {
            this.visible = true;
            ConsoleDocument.ConsoleLine[] lines = this.document.getLines();
            int i = 0;
            while (i < lines.length) {
                ConsoleDocument.ConsoleLine line = lines[i];
                this.appendLine(line.getType(), line.getLine());
                ++i;
            }
            this.document.clear();
        }
    }

    private void appendLine(int level, String line) {
        if (level > this.logLevel) {
            return;
        }
        this.doAppendLine(level, line);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAppendLine(int level, String line) {
        this.showConsole();
        ConsoleDocument consoleDocument = this.document;
        synchronized (consoleDocument) {
            if (this.visible) {
                this.streams[level].println(line);
            } else {
                this.document.appendConsoleLine(level, line);
            }
        }
    }

    private void showConsole() {
        this.show(false);
    }

    private Color createColor(Display display, String preference) {
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)IvyPlugin.getDefault().getPreferenceStore(), (String)preference);
        if (rgb == PreferenceConverter.COLOR_DEFAULT_DEFAULT) {
            if (PREF_CONSOLE_DEBUG_COLOR.equals(preference)) {
                rgb = new RGB(180, 180, 255);
            } else if (PREF_CONSOLE_VERBOSE_COLOR.equals(preference)) {
                rgb = new RGB(50, 150, 50);
            } else if (PREF_CONSOLE_WARN_COLOR.equals(preference)) {
                rgb = new RGB(255, 80, 20);
            } else if (PREF_CONSOLE_ERROR_COLOR.equals(preference)) {
                rgb = new RGB(255, 0, 0);
            }
        }
        return new Color((Device)display, rgb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispose() {
        ConsoleDocument consoleDocument = this.document;
        synchronized (consoleDocument) {
            this.visible = false;
        }
    }

    public void show(boolean showNoMatterWhat) {
        if (showNoMatterWhat || this.showOnMessage) {
            if (!this.visible) {
                IvyConsoleFactory.showConsole();
            } else {
                this.consoleManager.showConsoleView((IConsole)this);
            }
        }
    }

    public void debug(String msg) {
        this.log(msg, 4);
    }

    public void verbose(String msg) {
        this.log(msg, 3);
    }

    public void deprecated(String msg) {
        this.log("DEPRECATED: " + msg, 1);
    }

    public void info(String msg) {
        this.log(msg, 2);
    }

    public void rawinfo(String msg) {
        this.rawlog(msg, 2);
    }

    public void warn(String msg) {
        this.log("WARN: " + msg, 3);
        this.problems.add("WARN:  " + msg);
        this.getWarns().add(msg);
    }

    public void error(String msg) {
        this.log("ERROR: " + msg, 3);
        this.problems.add("\tERROR: " + msg);
        this.getErrors().add(msg);
    }

    public List getProblems() {
        return this.problems;
    }

    public void sumupProblems() {
        MessageLoggerHelper.sumupProblems((MessageLogger)this);
        this.clearProblems();
    }

    public void clearProblems() {
        this.problems.clear();
        this.warns.clear();
        this.errors.clear();
    }

    public List getErrors() {
        return this.errors;
    }

    public List getWarns() {
        return this.warns;
    }

    public void endProgress() {
        this.endProgress("");
    }

    public boolean isShowProgress() {
        return this.showProgress;
    }

    public void setShowProgress(boolean progress) {
        this.showProgress = progress;
    }

    public class MyLifecycle
    implements IConsoleListener {
        public void consolesAdded(IConsole[] consoles) {
            int i = 0;
            while (i < consoles.length) {
                IConsole console = consoles[i];
                if (console == IvyConsole.this) {
                    IvyConsole.this.init();
                }
                ++i;
            }
        }

        public void consolesRemoved(IConsole[] consoles) {
            int i = 0;
            while (i < consoles.length) {
                IConsole console = consoles[i];
                if (console == IvyConsole.this) {
                    ConsolePlugin.getDefault().getConsoleManager().removeConsoleListener((IConsoleListener)this);
                    IvyConsole.this.dispose();
                }
                ++i;
            }
        }
    }
}

