/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.internal.eclipse.workspaceresolver;

import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.plugins.latest.LatestStrategy;
import org.apache.ivy.plugins.resolver.ChainResolver;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.plugins.resolver.ResolverSettings;
import org.apache.ivyde.internal.eclipse.workspaceresolver.IvyDEStrategy;
import org.apache.ivyde.internal.eclipse.workspaceresolver.WorkspaceResolver;
import org.eclipse.core.resources.IProject;

public class WorkspaceIvySettings
extends IvySettings {
    private final IProject project;

    public WorkspaceIvySettings(IProject project) {
        this.project = project;
        this.setDefaultLatestStrategy((LatestStrategy)new IvyDEStrategy());
    }

    public DependencyResolver getResolver(ModuleRevisionId mrid) {
        return this.decorate(super.getResolver(mrid));
    }

    public DependencyResolver getDefaultResolver() {
        return this.decorate(super.getDefaultResolver());
    }

    private DependencyResolver decorate(DependencyResolver resolver) {
        if (resolver == null) {
            return resolver;
        }
        String projectName = this.project == null ? "<null>" : this.project.getName();
        ChainResolver chain = new ChainResolver();
        chain.setName(String.valueOf(projectName) + "-ivyde-workspace-chain-resolver");
        chain.setSettings((ResolverSettings)this);
        chain.setReturnFirst(true);
        chain.add((DependencyResolver)new WorkspaceResolver(this.project, this));
        chain.add(resolver);
        return chain;
    }
}

