/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.theme.core;

import com.liferay.ide.core.util.FileUtil;
import com.liferay.ide.theme.core.ThemeDiffResourceListener;
import java.io.InputStream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ThemeCore
extends Plugin {
    public static final String PLUGIN_ID = "com.liferay.ide.theme.core";
    private static ThemeCore plugin;
    private static ThemeDiffResourceListener themeDiffResourceListener;

    public static IStatus createErrorStatus(Exception ex) {
        return new Status(4, PLUGIN_ID, ex.getMessage(), (Throwable)ex);
    }

    public static IStatus createErrorStatus(String msg) {
        return new Status(4, PLUGIN_ID, msg);
    }

    public static IStatus createErrorStatus(String msg, Exception e) {
        return new Status(4, PLUGIN_ID, msg, (Throwable)e);
    }

    public static IStatus createWarningStatus(String msg) {
        return new Status(2, PLUGIN_ID, msg);
    }

    public static ThemeCore getDefault() {
        return plugin;
    }

    public static String getThemeProperty(String propertyName, IProject project) {
        String retval = null;
        try {
            Document buildXmlDoc = FileUtil.readXML((InputStream)project.getFile("build.xml").getContents(), null, null);
            NodeList properties = buildXmlDoc.getElementsByTagName("property");
            int i = 0;
            while (i < properties.getLength()) {
                Node item = properties.item(i);
                Node name = item.getAttributes().getNamedItem("name");
                if (name != null && propertyName.equals(name.getNodeValue())) {
                    Node value = item.getAttributes().getNamedItem("value");
                    retval = value.getNodeValue();
                    break;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (retval == null) {
            if (propertyName.equals("theme.parent")) {
                retval = "_styled";
            }
            if (propertyName.equals("theme.type")) {
                retval = "vm";
            }
        }
        return retval;
    }

    public static void logError(Exception ex) {
        ThemeCore.getDefault().getLog().log(ThemeCore.createErrorStatus(ex));
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
        if (themeDiffResourceListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)themeDiffResourceListener);
        }
    }

    public static void logError(String msg) {
        ThemeCore.getDefault().getLog().log(ThemeCore.createErrorStatus(msg));
    }

    public static void logError(String msg, Exception e) {
        ThemeCore.getDefault().getLog().log(ThemeCore.createErrorStatus(msg, e));
    }
}

