/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.theme.core;

import com.liferay.ide.core.ILiferayProject;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.util.ProjectUtil;
import com.liferay.ide.sdk.core.SDK;
import com.liferay.ide.sdk.core.SDKUtil;
import com.liferay.ide.server.util.ServerUtil;
import com.liferay.ide.theme.core.ThemeCore;
import com.liferay.ide.theme.core.operation.ThemeDescriptorHelper;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;

public class ThemeDiffResourceListener
implements IResourceChangeListener {
    public void resourceChanged(IResourceChangeEvent event) {
        if (event == null) {
            return;
        }
        if (this.shouldProcessResourceChangedEvent(event)) {
            IResourceDelta delta = event.getDelta();
            try {
                delta.accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        if (ThemeDiffResourceListener.this.shouldProcessResourceDelta(delta)) {
                            ThemeDiffResourceListener.this.processResourceChanged(delta);
                            return false;
                        }
                        return true;
                    }
                });
            }
            catch (CoreException coreException) {}
        }
    }

    private IFile getWorkspaceFile(IPath path) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        return root.getFile(path);
    }

    protected boolean isLiferayPluginProject(IPath deltaPath) {
        IFile pluginPackagePropertiesFile = this.getWorkspaceFile(deltaPath);
        if (pluginPackagePropertiesFile != null && pluginPackagePropertiesFile.exists()) {
            return ProjectUtil.isThemeProject((IProject)pluginPackagePropertiesFile.getProject());
        }
        return false;
    }

    protected void processResourceChanged(final IResourceDelta delta) throws CoreException {
        new WorkspaceJob(Msgs.compilingTheme){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                int n;
                IProject project = delta.getResource().getProject();
                SDK sdk = SDKUtil.getSDK((IProject)project);
                if (sdk == null) {
                    throw new CoreException(ThemeCore.createErrorStatus("No SDK for project configured. Could not deploy theme module"));
                }
                Map appServerProperties = ServerUtil.configureAppServerProperties((IProject)project);
                IStatus status = sdk.compileThemePlugin(project, null, appServerProperties);
                if (!status.isOK()) {
                    throw new CoreException(status);
                }
                IVirtualFolder webappRoot = CoreUtil.getDocroot((IProject)project);
                IFile lookAndFeelFile = null;
                if (webappRoot != null) {
                    IContainer[] iContainerArray = webappRoot.getUnderlyingFolders();
                    n = iContainerArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Path path;
                        IFile file;
                        IContainer container = iContainerArray[n2];
                        if (container != null && container.exists() && (file = container.getFile((IPath)(path = new Path("WEB-INF/liferay-look-and-feel.xml")))).exists()) {
                            lookAndFeelFile = file;
                            break;
                        }
                        ++n2;
                    }
                }
                if (lookAndFeelFile == null) {
                    String id = project.getName().replaceAll("-theme", "");
                    IContainer[] iContainerArray = webappRoot.getUnderlyingFolders();
                    int n3 = iContainerArray.length;
                    n = 0;
                    while (n < n3) {
                        IContainer container = iContainerArray[n];
                        if (container != null && container.exists()) {
                            IFile propsFile = container.getFile((IPath)new Path("WEB-INF/liferay-plugin-package.properties"));
                            String name = id;
                            if (propsFile.exists()) {
                                Properties props = new Properties();
                                try {
                                    props.load(propsFile.getContents());
                                    String nameValue = props.getProperty("name");
                                    if (!CoreUtil.isNullOrEmpty((String)nameValue)) {
                                        name = nameValue;
                                    }
                                }
                                catch (IOException e) {
                                    ThemeCore.logError("Unable to load plugin package properties.", e);
                                }
                            }
                            ThemeDescriptorHelper themeDescriptorHelper = new ThemeDescriptorHelper(project);
                            IFolder descriptorParent = container.getFolder((IPath)new Path("WEB-INF"));
                            ILiferayProject lProject = LiferayCore.create((Object)project);
                            themeDescriptorHelper.createDefaultFile((IContainer)descriptorParent, lProject.getPortalVersion(), id, name, ThemeCore.getThemeProperty("theme.type", project));
                            try {
                                container.refreshLocal(2, null);
                            }
                            catch (Exception e) {
                                ThemeCore.logError(e);
                            }
                        }
                        ++n;
                    }
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    protected boolean shouldProcessResourceChangedEvent(IResourceChangeEvent event) {
        if (event == null) {
            return false;
        }
        IResourceDelta delta = event.getDelta();
        int deltaKind = delta.getKind();
        return deltaKind != 2 && deltaKind != 16;
    }

    protected boolean shouldProcessResourceDelta(IResourceDelta delta) {
        IPath fullPath = delta.getFullPath();
        IVirtualFolder webappRoot = CoreUtil.getDocroot((IProject)delta.getResource().getProject());
        if (webappRoot == null) {
            return false;
        }
        IContainer[] iContainerArray = webappRoot.getUnderlyingFolders();
        int n = iContainerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContainer container = iContainerArray[n2];
            if (container != null && container.exists()) {
                IPath diffPath = container.getFolder((IPath)new Path("_diffs")).getFullPath();
                return diffPath.isPrefixOf(fullPath);
            }
            ++n2;
        }
        return false;
    }

    private static class Msgs
    extends NLS {
        public static String compilingTheme;

        static {
            Msgs.initializeMessages((String)ThemeDiffResourceListener.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

