/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.theme.core.operation;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.core.util.DescriptorHelper;
import com.liferay.ide.core.util.NodeUtil;
import com.liferay.ide.project.core.util.LiferayDescriptorHelper;
import com.liferay.ide.theme.core.ThemeCore;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.format.FormatProcessorXML;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ThemeDescriptorHelper
extends LiferayDescriptorHelper {
    public static final String DEFUALT_FILE_TEMPLATE = "<?xml version=\"1.0\"?>\n<!DOCTYPE look-and-feel PUBLIC \"-//Liferay//DTD Look and Feel {0}//EN\" \"http://www.liferay.com/dtd/liferay-look-and-feel_{1}.dtd\">\n\n<look-and-feel>\n\t<compatibility>\n\t\t<version>__VERSION__</version>\n\t</compatibility>\n\t<theme id=\"__ID__\" name=\"__NAME__\" />\n</look-and-feel>";

    public ThemeDescriptorHelper(IProject project) {
        super(project);
    }

    public void createDefaultFile(IContainer container, String version, String id, String name, String themeType) {
        if (container == null || id == null || name == null) {
            return;
        }
        try {
            Path path = new Path("liferay-look-and-feel.xml");
            IFile lookAndFeelFile = container.getFile((IPath)path);
            String descriptorVersion = this.getDescriptorVersionFromPortalVersion(version);
            CoreUtil.prepareFolder((IFolder)((IFolder)lookAndFeelFile.getParent()));
            String contents = MessageFormat.format(DEFUALT_FILE_TEMPLATE, descriptorVersion, descriptorVersion.replace('.', '_'));
            contents = contents.replaceAll("__VERSION__", String.valueOf(version) + "+").replaceAll("__ID__", id).replaceAll("__NAME__", name);
            lookAndFeelFile.create((InputStream)new ByteArrayInputStream(contents.getBytes()), true, null);
            if (!themeType.equals("vm")) {
                this.setTemplateExtension(lookAndFeelFile, themeType);
            }
            FormatProcessorXML processor = new FormatProcessorXML();
            try {
                processor.formatFile(lookAndFeelFile);
            }
            catch (IOException iOException) {}
        }
        catch (CoreException e) {
            ThemeCore.logError("Error creating default descriptor file", (Exception)((Object)e));
        }
    }

    protected void setTemplateExtension(IFile lookAndFeelFile, final String extension) {
        new DescriptorHelper.DOMModelEditOperation((DescriptorHelper)this, lookAndFeelFile){

            protected void createDefaultFile() {
            }

            protected IStatus doExecute(IDOMDocument document) {
                try {
                    NodeList themeElements = document.getElementsByTagName("theme");
                    Element themeElement = (Element)themeElements.item(0);
                    NodeUtil.appendChildElement((Element)themeElement, (String)"template-extension", (String)extension);
                }
                catch (Exception e) {
                    return ThemeCore.createErrorStatus(e);
                }
                return Status.OK_STATUS;
            }
        }.execute();
    }
}

