/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.core.remote;

import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.remote.APIException;
import com.liferay.ide.core.remote.IRemoteConnection;
import com.liferay.ide.core.util.CoreUtil;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RemoteConnection
implements IRemoteConnection {
    private String hostname;
    private HttpClient httpClient;
    private int httpPort;
    private String password;
    private String username;

    protected Object deleteJSONAPI(Object ... args) throws APIException {
        if (!(args[0] instanceof String)) {
            throw new IllegalArgumentException("First argument must be a string.");
        }
        HttpDelete deleteAPIMethod = new HttpDelete();
        return this.httpJSONAPI(deleteAPIMethod, args);
    }

    public String getHost() {
        return this.hostname;
    }

    private HttpClient getHttpClient() {
        if (this.httpClient == null) {
            DefaultHttpClient newDefaultHttpClient = null;
            if (this.getUsername() != null || this.getPassword() != null) {
                block9: {
                    try {
                        IProxyData data;
                        IProxyData[] proxyDataForHost;
                        IProxyService proxyService = LiferayCore.getProxyService();
                        URI uri = new URI("http://" + this.getHost() + ":" + this.getHttpPort());
                        IProxyData[] iProxyDataArray = proxyDataForHost = proxyService.select(uri);
                        int n = proxyDataForHost.length;
                        int n2 = 0;
                        while (n2 < n) {
                            data = iProxyDataArray[n2];
                            if (data.getHost() != null && data.getPort() > 0) {
                                SchemeRegistry schemeRegistry = new SchemeRegistry();
                                schemeRegistry.register(new Scheme("http", data.getPort(), (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
                                PoolingClientConnectionManager cm = new PoolingClientConnectionManager(schemeRegistry);
                                cm.setMaxTotal(200);
                                cm.setDefaultMaxPerRoute(20);
                                DefaultHttpClient newHttpClient = new DefaultHttpClient((ClientConnectionManager)cm);
                                HttpHost proxy = new HttpHost(data.getHost(), data.getPort());
                                newHttpClient.getParams().setParameter("http.route.default-proxy", (Object)proxy);
                                newDefaultHttpClient = newHttpClient;
                                break;
                            }
                            ++n2;
                        }
                        if (newDefaultHttpClient != null) break block9;
                        uri = new URI("SOCKS://" + this.getHost() + ":" + this.getHttpPort());
                        iProxyDataArray = proxyDataForHost = proxyService.select(uri);
                        n = proxyDataForHost.length;
                        n2 = 0;
                        while (n2 < n) {
                            data = iProxyDataArray[n2];
                            if (data.getHost() != null) {
                                DefaultHttpClient newHttpClient = new DefaultHttpClient();
                                newHttpClient.getParams().setParameter("socks.host", (Object)data.getHost());
                                newHttpClient.getParams().setParameter("socks.port", (Object)data.getPort());
                                newHttpClient.getConnectionManager().getSchemeRegistry().register(new Scheme("socks", data.getPort(), (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
                                newDefaultHttpClient = newHttpClient;
                                break;
                            }
                            ++n2;
                        }
                    }
                    catch (URISyntaxException e) {
                        LiferayCore.logError("Unable to read proxy data", e);
                    }
                }
                if (newDefaultHttpClient == null) {
                    newDefaultHttpClient = new DefaultHttpClient();
                }
                newDefaultHttpClient.getCredentialsProvider().setCredentials(new AuthScope(this.getHost(), this.getHttpPort()), (Credentials)new UsernamePasswordCredentials(this.getUsername(), this.getPassword()));
                this.httpClient = newDefaultHttpClient;
            }
        }
        return this.httpClient;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    protected String getHttpResponse(HttpUriRequest request) throws Exception {
        HttpResponse response = this.getHttpClient().execute(request);
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 200) {
            HttpEntity entity = response.getEntity();
            String body = CoreUtil.readStreamToString(entity.getContent(), false);
            EntityUtils.consume((HttpEntity)entity);
            return body;
        }
        return response.getStatusLine().getReasonPhrase();
    }

    protected Object getJSONAPI(Object ... args) throws APIException {
        if (!(args[0] instanceof String)) {
            throw new IllegalArgumentException("First argument must be a string.");
        }
        HttpGet getAPIMethod = new HttpGet();
        return this.httpJSONAPI(getAPIMethod, args);
    }

    private Object getJSONResponse(String response) {
        JSONObject retval = null;
        try {
            retval = new JSONObject(response);
        }
        catch (JSONException jSONException) {
            try {
                retval = new JSONArray(response);
            }
            catch (JSONException jSONException2) {}
        }
        return retval;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }

    protected Object httpJSONAPI(Object ... args) throws APIException {
        if (!(args[0] instanceof HttpRequestBase)) {
            throw new IllegalArgumentException("First argument must be a HttpRequestBase.");
        }
        Object retval = null;
        String api = null;
        Object[] params = new Object[]{};
        HttpRequestBase request = (HttpRequestBase)args[0];
        if (args[1] instanceof String) {
            api = args[1].toString();
        } else if (args[1] instanceof Object[]) {
            params = (Object[])args[1];
            api = params[0].toString();
        } else {
            throw new IllegalArgumentException("2nd argument must be either String or Object[]");
        }
        try {
            try {
                URIBuilder builder = new URIBuilder();
                builder.setScheme("http");
                builder.setHost(this.getHost());
                builder.setPort(this.getHttpPort());
                builder.setPath(api);
                if (params.length >= 2) {
                    int i = 0;
                    while (i < params.length) {
                        String name = null;
                        String value = "";
                        if (params[i] != null) {
                            name = params[i].toString();
                        }
                        if (params[i + 1] != null) {
                            value = params[i + 1].toString();
                        }
                        builder.setParameter(name, value);
                        i += 2;
                    }
                }
                request.setURI(builder.build());
                String response = this.getHttpResponse((HttpUriRequest)request);
                if (response != null && response.length() > 0) {
                    Object jsonResponse = this.getJSONResponse(response);
                    if (jsonResponse == null) {
                        throw new APIException(api, "Unable to get response: " + response);
                    }
                    retval = jsonResponse;
                }
            }
            catch (APIException e) {
                throw e;
            }
            catch (Exception e) {
                throw new APIException(api, e);
            }
        }
        finally {
            request.releaseConnection();
        }
        return retval;
    }

    protected Object postJSONAPI(Object ... args) throws APIException {
        if (!(args[0] instanceof String)) {
            throw new IllegalArgumentException("First argument must be a string.");
        }
        HttpPost post = new HttpPost();
        return this.httpJSONAPI(post, args);
    }

    public void setHost(String host) {
        this.hostname = host;
        this.releaseHttpClient();
    }

    public void setHttpPort(String httpPort) {
        this.httpPort = httpPort != null ? Integer.parseInt(httpPort) : -1;
        this.releaseHttpClient();
    }

    public void setPassword(String password) {
        this.password = password;
        this.releaseHttpClient();
    }

    public void setUsername(String username) {
        this.username = username;
        this.releaseHttpClient();
    }

    public void releaseHttpClient() {
        if (this.httpClient != null) {
            this.httpClient.getConnectionManager().shutdown();
            this.httpClient = null;
        }
    }
}

