/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.core.util;

import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.util.CoreUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescriptorHelper {
    protected String descriptorPath;
    protected IProject project;

    public static IFile getDescriptorFile(IProject project, String fileName) {
        IVirtualFolder webappRoot;
        IFile retval = null;
        IFolder defaultDocrootFolder = CoreUtil.getDefaultDocrootFolder(project);
        if (defaultDocrootFolder != null && defaultDocrootFolder.exists()) {
            retval = defaultDocrootFolder.getFile(new Path("WEB-INF").append(fileName));
        }
        if (retval == null && (webappRoot = CoreUtil.getDocroot(project)) != null) {
            IContainer[] iContainerArray = webappRoot.getUnderlyingFolders();
            int n = iContainerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFile descriptorFile;
                IContainer container = iContainerArray[n2];
                if (container != null && container.exists() && (descriptorFile = container.getFile(new Path("WEB-INF").append(fileName))).exists()) {
                    retval = descriptorFile;
                    break;
                }
                ++n2;
            }
        }
        return retval;
    }

    public DescriptorHelper(IProject project) {
        this.project = project;
    }

    public List<Element> getChildElements(Element parent) {
        ArrayList<Element> retval = new ArrayList<Element>();
        if (parent != null) {
            NodeList children = parent.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                if (child instanceof Element) {
                    retval.add((Element)child);
                }
                ++i;
            }
        }
        return retval;
    }

    protected IFile getDescriptorFile(String fileName) {
        return DescriptorHelper.getDescriptorFile(this.project, fileName);
    }

    public String getDescriptorPath() {
        return this.descriptorPath;
    }

    protected IProject getProject() {
        return this.project;
    }

    public void setDescriptorPath(String path) {
        this.descriptorPath = path;
    }

    public abstract class DOMModelEditOperation
    extends DOMModelOperation {
        public DOMModelEditOperation(IFile descriptorFile) {
            super(descriptorFile);
        }

        public void createDefaultDescriptor(String templateString, String version) {
            String content = MessageFormat.format(templateString, version, version.replace('.', '_'));
            try {
                this.file.create((InputStream)new ByteArrayInputStream(content.getBytes("UTF-8")), 1, null);
            }
            catch (Exception e) {
                LiferayCore.logError(e);
            }
        }

        protected abstract void createDefaultFile();

        public IStatus execute() {
            IStatus retval = null;
            if (!this.file.exists()) {
                this.createDefaultFile();
            }
            IDOMModel domModel = null;
            try {
                try {
                    domModel = (IDOMModel)StructuredModelManager.getModelManager().getModelForEdit(this.file);
                    domModel.aboutToChangeModel();
                    IDOMDocument document = domModel.getDocument();
                    retval = this.doExecute(document);
                    domModel.changedModel();
                    domModel.save();
                }
                catch (Exception e) {
                    retval = LiferayCore.createErrorStatus(e);
                    if (domModel != null) {
                        domModel.releaseFromEdit();
                    }
                }
            }
            finally {
                if (domModel != null) {
                    domModel.releaseFromEdit();
                }
            }
            return retval;
        }
    }

    protected static abstract class DOMModelOperation {
        protected IFile file;

        public DOMModelOperation(IFile descriptorFile) {
            this.file = descriptorFile;
        }

        protected abstract IStatus doExecute(IDOMDocument var1);

        public abstract IStatus execute();
    }

    protected abstract class DOMModelReadOperation
    extends DOMModelOperation {
        public DOMModelReadOperation(IFile descriptorFile) {
            super(descriptorFile);
        }

        public IStatus execute() {
            IStatus retval = null;
            if (!this.file.exists()) {
                return LiferayCore.createErrorStatus(String.valueOf(this.file.getName()) + " doesn't exist");
            }
            IDOMModel domModel = null;
            try {
                try {
                    domModel = (IDOMModel)StructuredModelManager.getModelManager().getModelForRead(this.file);
                    IDOMDocument document = domModel.getDocument();
                    retval = this.doExecute(document);
                }
                catch (Exception e) {
                    retval = LiferayCore.createErrorStatus(e);
                    if (domModel != null) {
                        domModel.releaseFromRead();
                    }
                }
            }
            finally {
                if (domModel != null) {
                    domModel.releaseFromRead();
                }
            }
            return retval;
        }
    }
}

