/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.sdk.ui;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.sdk.core.ISDKConstants;
import com.liferay.ide.sdk.core.SDK;
import com.liferay.ide.sdk.core.SDKUtil;
import com.liferay.ide.sdk.ui.SDKUIPlugin;
import com.liferay.ide.ui.util.SWTUtil;
import java.io.File;
import java.net.URL;
import java.util.HashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.ServerCore;

public class AddSDKDialog
extends TitleAreaDialog
implements ModifyListener {
    protected SDK[] existingSDKs;
    protected String lastLocation;
    protected String lastName;
    protected Text location;
    protected Text name;
    protected SDK sdkToEdit;
    protected Combo serverTargetCombo;
    protected boolean shouldAddProject = true;
    protected boolean shouldOpenInEclipse = false;

    public AddSDKDialog(Shell parent, SDK[] existingSDKs) {
        super(parent);
        this.configure(existingSDKs);
    }

    public AddSDKDialog(Shell shell, SDK[] existingSDKs, SDK sdk) {
        super(shell);
        this.sdkToEdit = sdk;
        this.configure(existingSDKs);
    }

    public boolean getAddProject() {
        return this.shouldAddProject;
    }

    public String getLocation() {
        return this.lastLocation;
    }

    public String getName() {
        return this.lastName;
    }

    public boolean getOpenInEclipse() {
        return this.shouldOpenInEclipse;
    }

    public void modifyText(ModifyEvent e) {
        IStatus status = this.validate();
        if (!status.isOK()) {
            switch (status.getSeverity()) {
                case 2: {
                    this.setMessage(status.getMessage(), 2);
                    break;
                }
                case 4: {
                    this.setMessage(status.getMessage(), 3);
                    this.getButton(0).setEnabled(false);
                }
            }
        } else {
            this.getButton(0).setEnabled(true);
            this.setMessage(this.getDefaultMessage(), 0);
        }
    }

    protected void configure(SDK[] existingSdks) {
        this.existingSDKs = existingSdks;
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setTitleImage(ImageDescriptor.createFromURL((URL)SDKUIPlugin.getDefault().getBundle().getEntry("/icons/wizban/sdk_wiz.png")).createImage());
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(NLS.bind((String)Msgs.liferayPluginSDK, (Object)(this.sdkToEdit == null ? Msgs.newSDKAction : Msgs.editSDKAction)));
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(NLS.bind((String)Msgs.liferayPluginSDK, (Object)(this.sdkToEdit == null ? Msgs.addSDKAction : Msgs.editSDKAction)));
        this.setMessage(this.getDefaultMessage());
        Composite container = SWTUtil.createTopComposite((Composite)parent, (int)3);
        container.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        SWTUtil.createLabel((Composite)container, (String)Msgs.locationLabel, (int)1);
        this.location = SWTUtil.createSingleText((Composite)container, (int)1);
        Button browse = SWTUtil.createButton((Composite)container, (String)Msgs.browse);
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddSDKDialog.this.doBrowse();
            }
        });
        if (this.sdkToEdit != null) {
            this.location.setText(this.sdkToEdit.getLocation().toOSString());
        }
        this.location.addModifyListener((ModifyListener)this);
        SWTUtil.createLabel((Composite)container, (String)Msgs.nameLabel, (int)1);
        this.name = SWTUtil.createSingleText((Composite)container, (int)1);
        if (this.sdkToEdit != null) {
            this.name.setText(this.sdkToEdit.getName());
        }
        this.name.addModifyListener((ModifyListener)this);
        SWTUtil.createLabel((Composite)container, (String)"", (int)1);
        SWTUtil.createLabel((Composite)container, (String)"", (int)1);
        final Button addProject = SWTUtil.createCheckButton((Composite)container, (String)Msgs.addEclipseProjectFile, null, (boolean)true, (int)1);
        SWTUtil.createLabel((Composite)container, (String)"", (int)1);
        SWTUtil.createLabel((Composite)container, (String)"", (int)1);
        final Button openInEclipse = SWTUtil.createCheckButton((Composite)container, (String)Msgs.openEclipse, null, (boolean)true, (int)1);
        openInEclipse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddSDKDialog.this.shouldOpenInEclipse = openInEclipse.getSelection();
            }
        });
        openInEclipse.setEnabled(this.shouldAddProject);
        openInEclipse.setSelection(this.shouldOpenInEclipse);
        addProject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selection;
                AddSDKDialog.this.shouldAddProject = selection = addProject.getSelection();
                openInEclipse.setEnabled(selection);
            }
        });
        if (this.sdkToEdit != null) {
            this.validate();
        }
        return container;
    }

    protected void doBrowse() {
        String dir;
        DirectoryDialog dd = new DirectoryDialog(this.getShell(), 4096);
        String filterPath = this.location.getText();
        if (filterPath != null) {
            dd.setFilterPath(filterPath);
            dd.setText(NLS.bind((String)Msgs.selectFolderParamLabel, (Object)filterPath));
        } else {
            dd.setText(Msgs.selectFolderLabel);
        }
        if (CoreUtil.isNullOrEmpty((String)this.location.getText())) {
            dd.setFilterPath(this.location.getText());
        }
        if (!CoreUtil.isNullOrEmpty((String)(dir = dd.open()))) {
            Path path;
            this.location.setText(dir);
            if (SDKUtil.isValidSDKLocation((String)dir) && CoreUtil.isNullOrEmpty((String)this.name.getText()) && (path = new Path(dir)).isValidPath(dir)) {
                this.name.setText(path.lastSegment());
            }
        }
    }

    protected String getDefaultMessage() {
        return Msgs.configureLiferayPluginSDKLocation;
    }

    protected void updateRuntimeItems() {
        HashSet<String> validRuntimes = new HashSet<String>();
        IRuntime[] iRuntimeArray = ServerCore.getRuntimes();
        int n = iRuntimeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntime runtime = iRuntimeArray[n2];
            if (runtime.getRuntimeType().getId().startsWith("com.liferay.ide.eclipse.server")) {
                validRuntimes.add(runtime.getName());
            }
            ++n2;
        }
        String[] runtimes = validRuntimes.toArray(new String[0]);
        this.serverTargetCombo.setItems(runtimes);
        if (this.serverTargetCombo.getSelectionIndex() < 0 && runtimes.length > 0) {
            this.serverTargetCombo.select(0);
        }
    }

    protected IStatus validate() {
        this.lastName = this.name.getText();
        if (CoreUtil.isNullOrEmpty((String)this.lastName)) {
            return CoreUtil.createErrorStatus((String)Msgs.nameHaveValue);
        }
        this.lastLocation = this.location.getText();
        if (CoreUtil.isNullOrEmpty((String)this.lastLocation)) {
            return CoreUtil.createErrorStatus((String)Msgs.locationHaveValue);
        }
        if (!new File(this.lastLocation).exists()) {
            return CoreUtil.createErrorStatus((String)Msgs.locationExists);
        }
        if (!SDKUtil.isValidSDKLocation((String)this.lastLocation)) {
            return CoreUtil.createErrorStatus((String)Msgs.locationValidLiferayPluginSDK);
        }
        if (!SDKUtil.isSDKSupported((String)this.lastLocation)) {
            return CoreUtil.createErrorStatus((String)NLS.bind((String)Msgs.SDKVersionGreaterEqual, (Object)ISDKConstants.LEAST_SUPPORTED_SDK_VERSION));
        }
        return Status.OK_STATUS;
    }

    private static class Msgs
    extends NLS {
        public static String addEclipseProjectFile;
        public static String addSDKAction;
        public static String browse;
        public static String configureLiferayPluginSDKLocation;
        public static String editSDKAction;
        public static String liferayPluginSDK;
        public static String locationExists;
        public static String locationHaveValue;
        public static String locationLabel;
        public static String locationValidLiferayPluginSDK;
        public static String nameHaveValue;
        public static String nameLabel;
        public static String newSDKAction;
        public static String openEclipse;
        public static String SDKVersionGreaterEqual;
        public static String selectFolderLabel;
        public static String selectFolderParamLabel;

        static {
            Msgs.initializeMessages((String)AddSDKDialog.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

