/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.layouttpl.ui.editor;

import com.liferay.ide.layouttpl.core.model.ILayoutTplDiagramFactory;
import com.liferay.ide.layouttpl.core.model.LayoutTplDiagramElement;
import com.liferay.ide.layouttpl.core.util.LayoutTplUtil;
import com.liferay.ide.layouttpl.ui.LayoutTplUI;
import com.liferay.ide.layouttpl.ui.action.LayoutTplEditorSelectAllAction;
import com.liferay.ide.layouttpl.ui.editor.LayoutTplContextMenuProvider;
import com.liferay.ide.layouttpl.ui.editor.LayoutTplEditorPaletteFactory;
import com.liferay.ide.layouttpl.ui.editor.LayoutTplOutlinePage;
import com.liferay.ide.layouttpl.ui.editor.LayoutTplPaletteViewerPreferences;
import com.liferay.ide.layouttpl.ui.editor.PortletLayoutFactory;
import com.liferay.ide.layouttpl.ui.editor.PortletLayoutTemplate;
import com.liferay.ide.layouttpl.ui.model.LayoutTplDiagram;
import com.liferay.ide.layouttpl.ui.model.LayoutTplDiagramUIFactory;
import com.liferay.ide.layouttpl.ui.parts.LayoutTplEditPartFactory;
import com.liferay.ide.layouttpl.ui.parts.LayoutTplRootEditPart;
import java.util.EventObject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.dnd.TemplateTransferDragSourceListener;
import org.eclipse.gef.dnd.TemplateTransferDropTargetListener;
import org.eclipse.gef.dnd.TransferDragSourceListener;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.requests.SimpleFactory;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.palette.FlyoutPaletteComposite;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.PaletteViewerPreferences;
import org.eclipse.gef.ui.palette.PaletteViewerProvider;
import org.eclipse.gef.ui.parts.GraphicalEditorWithFlyoutPalette;
import org.eclipse.gef.ui.parts.GraphicalViewerImpl;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.gef.ui.parts.SelectionSynchronizer;
import org.eclipse.gef.ui.parts.TreeViewer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class LayoutTplEditor
extends GraphicalEditorWithFlyoutPalette {
    protected static PaletteRoot PALETTE_MODEL;
    protected LayoutTplDiagramElement diagram;
    protected StructuredTextEditor sourceEditor;
    protected boolean visualEditorSupported;

    public LayoutTplEditor(StructuredTextEditor sourceEditor, boolean supported) {
        this.visualEditorSupported = supported;
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
        this.sourceEditor = sourceEditor;
    }

    public void commandStackChanged(EventObject event) {
        this.firePropertyChange(257);
        super.commandStackChanged(event);
    }

    protected void createActions() {
        super.createActions();
        this.getActionRegistry().removeAction(this.getActionRegistry().getAction((Object)ActionFactory.SELECT_ALL.getId()));
        LayoutTplEditorSelectAllAction action = new LayoutTplEditorSelectAllAction(this);
        this.getActionRegistry().registerAction((IAction)action);
    }

    public void dispose() {
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            this.refreshSourceModel();
            this.getCommandStack().markSaveLocation();
        }
        catch (Exception e) {
            LayoutTplUI.logError(e);
        }
    }

    public void doSaveAs() {
    }

    public ActionRegistry getActionRegistry() {
        return super.getActionRegistry();
    }

    public Object getAdapter(Class type) {
        if (type == IContentOutlinePage.class) {
            return new LayoutTplOutlinePage(this, (EditPartViewer)new TreeViewer());
        }
        return super.getAdapter(type);
    }

    public LayoutTplDiagramElement getDiagram() {
        return this.diagram;
    }

    public DefaultEditDomain getEditDomain() {
        return super.getEditDomain();
    }

    protected FlyoutPaletteComposite.FlyoutPreferences getPalettePreferences() {
        return FlyoutPaletteComposite.createFlyoutPreferences((Preferences)LayoutTplUI.getDefault().getPluginPreferences());
    }

    public SelectionSynchronizer getSelectionSynchronizer() {
        return super.getSelectionSynchronizer();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void refreshSourceModel() {
        if (!this.visualEditorSupported) {
            return;
        }
        IDOMModel domModel = this.getSourceModel();
        domModel.aboutToChangeModel();
        String name = this.getSourceFileName();
        String templateSource = LayoutTplUtil.getTemplateSource((LayoutTplDiagramElement)this.diagram, (String)name);
        domModel.getStructuredDocument().setText((Object)this, templateSource);
        domModel.changedModel();
        domModel.releaseFromEdit();
        this.getCommandStack().markSaveLocation();
    }

    public void refreshVisualModel() {
        GraphicalViewer viewer;
        IDOMModel domModel;
        this.diagram = null;
        if (this.visualEditorSupported && (domModel = this.getSourceModel(true)) != null) {
            this.diagram = LayoutTplDiagramElement.createFromModel((IDOMModel)domModel, (ILayoutTplDiagramFactory)LayoutTplDiagramUIFactory.INSTANCE);
            domModel.releaseFromRead();
        }
        if (this.diagram == null) {
            this.diagram = LayoutTplDiagram.createDefaultDiagram();
        }
        if ((viewer = this.getGraphicalViewer()) != null) {
            viewer.setContents((Object)this.diagram);
            this.refreshViewer(viewer);
        }
    }

    public void updateActions() {
        this.updateActions(this.getSelectionActions());
    }

    private void refreshViewer(final GraphicalViewer viewer) {
        viewer.getControl().addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                LayoutTplEditor.this.getGraphicalViewer().getContents().refresh();
                viewer.getControl().removePaintListener((PaintListener)this);
            }
        });
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.setEditPartFactory((EditPartFactory)new LayoutTplEditPartFactory(this.visualEditorSupported));
        viewer.setRootEditPart((RootEditPart)new LayoutTplRootEditPart());
        viewer.setKeyHandler((KeyHandler)new GraphicalViewerKeyHandler(viewer));
        LayoutTplContextMenuProvider cmProvider = new LayoutTplContextMenuProvider((EditPartViewer)viewer, this.getActionRegistry());
        viewer.setContextMenu((MenuManager)cmProvider);
        this.getSite().registerContextMenu((MenuManager)cmProvider, (ISelectionProvider)viewer);
    }

    protected void createGraphicalViewer(Composite parent) {
        GraphicalViewerImpl viewer = new GraphicalViewerImpl();
        viewer.createControl(parent);
        this.setGraphicalViewer((GraphicalViewer)viewer);
        this.configureGraphicalViewer();
        this.hookGraphicalViewer();
        this.initializeGraphicalViewer();
    }

    protected PaletteViewerProvider createPaletteViewerProvider() {
        return new PaletteViewerProvider((EditDomain)this.getEditDomain()){

            protected void configurePaletteViewer(PaletteViewer viewer) {
                super.configurePaletteViewer(viewer);
                viewer.setPaletteViewerPreferences((PaletteViewerPreferences)new LayoutTplPaletteViewerPreferences());
                viewer.addDragSourceListener((TransferDragSourceListener)new TemplateTransferDragSourceListener((EditPartViewer)viewer));
            }
        };
    }

    protected TransferDropTargetListener createTransferDropTargetListener() {
        return new TemplateTransferDropTargetListener((EditPartViewer)this.getGraphicalViewer()){

            protected CreationFactory getFactory(Object template) {
                if (template instanceof PortletLayoutTemplate) {
                    PortletLayoutTemplate portletLayoutTemplate = (PortletLayoutTemplate)template;
                    return new PortletLayoutFactory(portletLayoutTemplate.getNumCols(), portletLayoutTemplate.getWeights());
                }
                return new SimpleFactory((Class)template);
            }

            protected void updateTargetRequest() {
                this.updateTargetEditPart();
                CreateRequest request = this.getCreateRequest();
                request.setLocation(this.getDropLocation());
                Command command = this.getTargetEditPart().getCommand((Request)request);
                if (command == null || command.equals(UnexecutableCommand.INSTANCE)) {
                    this.getCurrentEvent().detail = 0;
                    this.getCurrentEvent().feedback = 0;
                }
            }
        };
    }

    protected PaletteRoot getPaletteRoot() {
        PALETTE_MODEL = this.visualEditorSupported ? LayoutTplEditorPaletteFactory.createPalette() : new PaletteRoot();
        return PALETTE_MODEL;
    }

    protected String getSourceFileName() {
        IEditorInput editorInput = this.getEditorInput();
        IPath path = null;
        if (editorInput instanceof IFileEditorInput) {
            path = ((IFileEditorInput)editorInput).getFile().getFullPath();
        } else if (editorInput instanceof FileStoreEditorInput) {
            path = new Path(((FileStoreEditorInput)editorInput).getURI().getPath());
        }
        if (path == null) {
            return editorInput.getName();
        }
        return path.removeFileExtension().lastSegment();
    }

    protected IDOMModel getSourceModel() {
        return this.getSourceModel(false);
    }

    protected IDOMModel getSourceModel(boolean readOnly) {
        IDOMModel domModel = null;
        if (this.sourceEditor != null && this.sourceEditor.getDocumentProvider() != null) {
            IDocumentProvider documentProvider = this.sourceEditor.getDocumentProvider();
            IDocument doc = documentProvider.getDocument((Object)this.getEditorInput());
            IStructuredModel model = readOnly ? StructuredModelManager.getModelManager().getExistingModelForRead(doc) : StructuredModelManager.getModelManager().getExistingModelForEdit(doc);
            if (model instanceof IDOMModel) {
                domModel = (IDOMModel)model;
            }
        }
        return domModel;
    }

    protected void initializeGraphicalViewer() {
        super.initializeGraphicalViewer();
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.setContents((Object)this.getDiagram());
        this.refreshViewer(viewer);
        viewer.addDropTargetListener(this.createTransferDropTargetListener());
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        this.refreshVisualModel();
        this.setPartName(input.getName());
    }
}

