/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.core;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.debug.core.fm.FMStackFrame;
import com.liferay.ide.debug.core.fm.FMThread;
import freemarker.debug.Breakpoint;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupParticipant;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;

public class PortalSourceLookupParticipant
extends AbstractSourceLookupParticipant {
    public Object[] findSourceElements(Object object) throws CoreException {
        String templateName;
        IProject project;
        Object[] retval = null;
        Object[] sourceElements = super.findSourceElements(object);
        if (object instanceof FMStackFrame && (project = this.getSourceProject(templateName = this.getTemplateName((IStackFrame)object))) != null) {
            ArrayList<IResource> validSourceElements = new ArrayList<IResource>();
            Object[] objectArray = sourceElements;
            int n = sourceElements.length;
            int n2 = 0;
            while (n2 < n) {
                IResource res;
                Object sourceElement = objectArray[n2];
                if (sourceElement instanceof IResource && (res = (IResource)sourceElement).getProject().equals((Object)project)) {
                    validSourceElements.add((IResource)sourceElement);
                }
                ++n2;
            }
            if (validSourceElements.size() > 1) {
                Iterator i = validSourceElements.iterator();
                while (i.hasNext()) {
                    IResource res = (IResource)i.next();
                    if (!res.getProjectRelativePath().toPortableString().contains("target/m2e-liferay/theme-resources")) continue;
                    i.remove();
                }
            }
            retval = validSourceElements.toArray(new Object[0]);
        }
        if (retval == null) {
            retval = sourceElements;
        }
        return retval;
    }

    public String getSourceName(Object object) throws CoreException {
        String retval = null;
        if (object instanceof FMStackFrame) {
            try {
                FMStackFrame frame = (FMStackFrame)object;
                String templateName = this.getTemplateName((IStackFrame)frame);
                Path templatePath = new Path(templateName);
                String firstSegment = templatePath.segment(0);
                String resourcePath = templatePath.removeFirstSegments(1).toPortableString();
                IProject project = CoreUtil.findProjectByContextName((String)firstSegment);
                IVirtualFolder webappRoot = CoreUtil.getDocroot((IProject)project);
                String diffsPath = "_diffs/" + resourcePath;
                IVirtualFile diffsResourceFile = webappRoot.getFile(diffsPath);
                if (diffsResourceFile.exists()) {
                    retval = diffsPath;
                } else {
                    IVirtualFile resourceFile = webappRoot.getFile(resourcePath);
                    if (resourceFile.exists()) {
                        retval = resourcePath;
                    }
                }
            }
            catch (Exception exception) {}
        }
        return retval;
    }

    private IProject getSourceProject(String templateName) {
        String firstTemplateNameSegment;
        IProject project;
        IProject retval = null;
        if (!CoreUtil.isNullOrEmpty((String)templateName) && CoreUtil.isLiferayProject((IProject)(project = CoreUtil.getProject((String)(firstTemplateNameSegment = new Path(templateName).segment(0)))))) {
            retval = project;
        }
        return retval;
    }

    private String getTemplateName(IStackFrame frame) throws DebugException {
        FMThread fmThread;
        Breakpoint stepBp;
        String retval = null;
        IThread thread = frame.getThread();
        IBreakpoint[] bps = thread.getBreakpoints();
        if (bps.length == 1) {
            IBreakpoint bp = thread.getBreakpoints()[0];
            retval = bp.getMarker().getAttribute("templateName", null);
        } else if (thread instanceof FMThread && (stepBp = (fmThread = (FMThread)thread).getStepBreakpoint()) != null) {
            retval = stepBp.getTemplateName().replaceAll("_SERVLET_CONTEXT_", "");
        }
        return retval;
    }
}

