/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.remote;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.server.core.LiferayServerCore;
import com.liferay.ide.server.remote.IRemoteServerWorkingCopy;
import com.liferay.ide.server.remote.IServerManagerConnection;
import com.liferay.ide.server.util.ServerUtil;
import com.liferay.ide.server.util.SocketUtil;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.model.ServerDelegate;

public class RemoteServer
extends ServerDelegate
implements IRemoteServerWorkingCopy {
    private static final String CONNECT_ERROR_MSG = Msgs.notConnectRemoteIDEConnectorPlugin;
    public static final String ATTR_REMOTE_SERVER_MODULE_IDS_LIST = "remote-server-module-ids-list";

    public boolean canMakeHttpConnection() {
        String host = this.getServer().getHost();
        String http = this.getHTTPPort();
        final Socket socket = new Socket();
        new Thread(){

            public void run() {
                try {
                    1.sleep(3000L);
                    socket.close();
                }
                catch (Exception exception) {}
            }
        }.start();
        IStatus status = SocketUtil.canConnect(socket, host, http);
        if (status != null && status.isOK()) {
            return true;
        }
        Socket socket1 = new Socket();
        status = SocketUtil.canConnectProxy(socket1, host, http);
        return status != null && status.isOK();
    }

    public IStatus canModifyModules(IModule[] add, IModule[] remove) {
        block8: {
            block7: {
                if (CoreUtil.isNullOrEmpty((Object[])add)) break block7;
                IModule[] iModuleArray = add;
                int n = add.length;
                int n2 = 0;
                while (n2 < n) {
                    IModule addModule = iModuleArray[n2];
                    IProject addModuleProject = addModule.getProject();
                    if (!CoreUtil.isLiferayProject((IProject)addModuleProject)) {
                        return LiferayServerCore.createErrorStatus(Msgs.notAddNonLiferayPluginProjectModule);
                    }
                    IStatus facetStatus = FacetUtil.verifyFacets((IProject)addModuleProject, (IServer)this.getServer());
                    if (facetStatus != null && !facetStatus.isOK()) {
                        return facetStatus;
                    }
                    if (ServerUtil.isExtProject(addModuleProject)) {
                        return LiferayServerCore.createErrorStatus(Msgs.extPluginDeployment);
                    }
                    ++n2;
                }
                break block8;
            }
            if (CoreUtil.isNullOrEmpty((Object[])remove)) break block8;
            IModule[] iModuleArray = remove;
            int n = remove.length;
            int n3 = 0;
            while (n3 < n) {
                IModule removeModule = iModuleArray[n3];
                IProject removeModuleProject = removeModule.getProject();
                if (removeModuleProject == null) {
                    return Status.OK_STATUS;
                }
                IStatus facetStatus = FacetUtil.verifyFacets((IProject)removeModuleProject, (IServer)this.getServer());
                if (facetStatus != null && !facetStatus.isOK()) {
                    return facetStatus;
                }
                ++n3;
            }
        }
        return Status.OK_STATUS;
    }

    public boolean getAdjustDeploymentTimestamp() {
        return this.getAttribute("adjust-deployment-timestamp", DEFAULT_ADJUST_DEPLOYMENT_TIMESTAMP);
    }

    public IModule[] getChildModules(IModule[] module) {
        if (CoreUtil.isNullOrEmpty((Object[])module)) {
            return null;
        }
        ArrayList<Object> childModules = new ArrayList<Object>();
        IModule[] iModuleArray = module;
        int n = module.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] webModules;
            IWebModule webModule;
            IModule m = iModuleArray[n2];
            IProject project = m.getProject();
            if (CoreUtil.isLiferayProject((IProject)project) && (webModule = (IWebModule)m.loadAdapter(IWebModule.class, null)) != null && !CoreUtil.isNullOrEmpty((Object[])(webModules = webModule.getModules()))) {
                Object[] objectArray = webModules;
                int n3 = webModules.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object childWebModule = objectArray[n4];
                    childModules.add(childWebModule);
                    ++n4;
                }
            }
            ++n2;
        }
        return childModules.toArray(new IModule[0]);
    }

    public String getHost() {
        return this.getServer().getHost();
    }

    public String getHttpPort() {
        return this.getHTTPPort();
    }

    public String getHTTPPort() {
        return this.getAttribute("http-port", DEFAULT_HTTP_PORT);
    }

    public String getId() {
        return this.getServer().getId();
    }

    public String getLiferayPortalContextPath() {
        return this.getAttribute("liferay-portal-context-path", DEFAULT_LIFERAY_PORTAL_CONTEXT_PATH);
    }

    public URL getModuleRootURL(IModule module) {
        return this.getPortalHomeUrl();
    }

    public String getPassword() {
        return this.getAttribute("password", DEFAULT_PASSWORD);
    }

    public URL getPluginContextURL(String context) {
        String httpPort = this.getHTTPPort();
        if (httpPort != null) {
            try {
                return new URL("http://" + this.getServer().getHost() + ":" + httpPort + context);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return null;
    }

    public URL getPortalHomeUrl() {
        String httpPort = this.getHTTPPort();
        String contextUrl = this.getLiferayPortalContextPath();
        if (httpPort != null && !CoreUtil.isNullOrEmpty((String)contextUrl)) {
            try {
                return new URL("http://" + this.getServer().getHost() + ":" + httpPort + contextUrl);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return null;
    }

    public IModule[] getRootModules(IModule module) throws CoreException {
        IModule[] modules = new IModule[]{module};
        IStatus status = this.canModifyModules(modules, null);
        if (status == null || !status.isOK()) {
            throw new CoreException(status);
        }
        return modules;
    }

    public String getServerManagerContextPath() {
        return this.getAttribute("server-manager-context-path", DEFAULT_SERVER_MANAGER_CONTEXT_PATH);
    }

    public String getUsername() {
        return this.getAttribute("username", DEFAULT_USERNAME);
    }

    public URL getWebServicesListURL() {
        try {
            return new URL("http://" + this.getServer().getHost() + ":" + this.getHTTPPort() + "/tunnel-web/axis");
        }
        catch (MalformedURLException e) {
            LiferayServerCore.logError("Unable to get web services list URL", e);
            return null;
        }
    }

    public void modifyModules(IModule[] add, IModule[] remove, IProgressMonitor monitor) throws CoreException {
        int n;
        int n2;
        IModule[] iModuleArray;
        ArrayList<String> moduleIds = this.getAttribute(this.getModuleListAttr(), null);
        if (!CoreUtil.isNullOrEmpty((Object[])add)) {
            if (moduleIds == null) {
                moduleIds = new ArrayList<String>(add.length);
            }
            iModuleArray = add;
            n2 = add.length;
            n = 0;
            while (n < n2) {
                IModule addModule = iModuleArray[n];
                if (!moduleIds.contains(addModule.getId())) {
                    moduleIds.add(addModule.getId());
                }
                ++n;
            }
        }
        if (!CoreUtil.isNullOrEmpty((Object[])remove) && !CoreUtil.isNullOrEmpty((List)moduleIds)) {
            iModuleArray = remove;
            n2 = remove.length;
            n = 0;
            while (n < n2) {
                IModule removeModule = iModuleArray[n];
                moduleIds.remove(removeModule.getId());
                ++n;
            }
        }
        if (moduleIds != null) {
            this.setAttribute(this.getModuleListAttr(), moduleIds);
        }
    }

    public void setAdjustDeploymentTimestamp(boolean adjustTimestamp) {
        this.setAttribute("adjust-deployment-timestamp", adjustTimestamp);
    }

    public void setDefaults(IProgressMonitor monitor) {
        String baseName;
        super.setDefaults(monitor);
        String defaultName = baseName = "Remote Liferay Server at " + this.getServer().getHost();
        int collision = 1;
        while (ServerPlugin.isNameInUse((Object)this.getServer(), (String)defaultName)) {
            defaultName = String.valueOf(baseName) + " (" + collision++ + ")";
        }
        this.getServerWorkingCopy().setName(defaultName);
    }

    public void setHTTPPort(String httpPort) {
        this.setAttribute("http-port", httpPort);
    }

    public void setLiferayPortalContextPath(String path) {
        this.setAttribute("liferay-portal-context-path", path);
    }

    public void setPassword(String pw) {
        this.setAttribute("password", pw);
    }

    public void setServerManagerContextPath(String path) {
        this.setAttribute("server-manager-context-path", path);
    }

    public void setUsername(String username) {
        this.setAttribute("username", username);
    }

    public IStatus validate(IProgressMonitor monitor) {
        IStatus status = null;
        try {
            URL url;
            String host = this.getServerWorkingCopy().getHost();
            if (monitor != null) {
                monitor.beginTask(NLS.bind((String)Msgs.validatingConnection, (Object)host, (Object)this.getHTTPPort()), -1);
            }
            if (!this.canMakeHttpConnection()) {
                return LiferayServerCore.createWarningStatus((String)NLS.bind((String)Msgs.serverNotAvailable, (Object)host, (Object)this.getHTTPPort()));
            }
            IServerManagerConnection connection = LiferayServerCore.getRemoteConnection(this);
            IStatus createErrorStatus = LiferayServerCore.createErrorStatus(CONNECT_ERROR_MSG);
            IStatus iStatus = status = connection.isAlive() ? Status.OK_STATUS : createErrorStatus;
            if (status.isOK() && (url = this.getPortalHomeUrl()) == null) {
                status = createErrorStatus;
            }
            if (monitor != null) {
                monitor.done();
            }
        }
        catch (Exception e) {
            status = LiferayServerCore.createErrorStatus((Exception)e);
        }
        return status;
    }

    protected String getModuleListAttr() {
        return ATTR_REMOTE_SERVER_MODULE_IDS_LIST;
    }

    private static class Msgs
    extends NLS {
        public static String extPluginDeployment;
        public static String notAddNonLiferayPluginProjectModule;
        public static String notConnectRemoteIDEConnectorPlugin;
        public static String serverNotAvailable;
        public static String validatingConnection;

        static {
            Msgs.initializeMessages((String)RemoteServer.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

