/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.layouttpl.core.model;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.layouttpl.core.LayoutTplCore;
import com.liferay.ide.layouttpl.core.model.ILayoutTplDiagramFactory;
import com.liferay.ide.layouttpl.core.model.PortletLayoutElement;
import com.liferay.ide.layouttpl.core.model.PortletRowLayoutElement;
import com.liferay.ide.layouttpl.core.util.LayoutTplUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class LayoutTplDiagramElement
extends PortletRowLayoutElement {
    protected String id = "main-content";
    protected String role = "main";

    public static LayoutTplDiagramElement createDefaultDiagram() {
        return new LayoutTplDiagramElement();
    }

    public static LayoutTplDiagramElement createFromFile(IFile file, ILayoutTplDiagramFactory factory) {
        if (file == null || !file.exists()) {
            return null;
        }
        LayoutTplDiagramElement model = null;
        try {
            IDOMModel domModel = (IDOMModel)StructuredModelManager.getModelManager().getModelForEdit(file);
            model = LayoutTplDiagramElement.createFromModel(domModel, factory);
        }
        catch (Exception e) {
            LayoutTplCore.logError("Unable to read layout template file " + file.getName(), e);
            model = new LayoutTplDiagramElement();
        }
        return model;
    }

    public static LayoutTplDiagramElement createFromModel(IDOMModel model, ILayoutTplDiagramFactory factory) {
        if (model == null) {
            return null;
        }
        LayoutTplDiagramElement newDiagram = factory.newLayoutTplDiagram();
        IDOMDocument rootDocument = model.getDocument();
        IDOMElement mainContentElement = LayoutTplUtil.findMainContentElement(rootDocument);
        newDiagram.setId("main-content");
        if (mainContentElement != null) {
            newDiagram.setRole(LayoutTplUtil.getRoleValue(mainContentElement, "main"));
            Object[] portletLayoutElements = LayoutTplUtil.findChildElementsByClassName(mainContentElement, "div", "portlet-layout");
            if (!CoreUtil.isNullOrEmpty((Object[])portletLayoutElements)) {
                Object[] objectArray = portletLayoutElements;
                int n = portletLayoutElements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object portletLayoutElement = objectArray[n2];
                    PortletLayoutElement newPortletLayout = factory.newPortletLayoutFromElement((IDOMElement)portletLayoutElement);
                    newDiagram.addRow(newPortletLayout);
                    ++n2;
                }
            }
        } else {
            newDiagram.setRole("main");
        }
        return newDiagram;
    }

    public String getId() {
        return this.id;
    }

    public String getRole() {
        return this.role;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setRole(String role) {
        this.role = role;
    }
}

