/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.layouttpl.core.model;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.layouttpl.core.model.ILayoutTplDiagramFactory;
import com.liferay.ide.layouttpl.core.model.ModelElement;
import com.liferay.ide.layouttpl.core.model.PortletColumnElement;
import com.liferay.ide.layouttpl.core.util.LayoutTplUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletLayoutElement
extends ModelElement
implements PropertyChangeListener {
    public static final String CHILD_COLUMN_WEIGHT_CHANGED_PROP = "PortletLayout.ChildColumnWeightChanged";
    public static final String COLUMN_ADDED_PROP = "PortletLayout.ColumnAdded";
    public static final String COLUMN_REMOVED_PROP = "PortletLayout.ColumnRemoved";
    protected String className = "portlet-layout";
    protected List<ModelElement> columns = new ArrayList<ModelElement>();

    public static PortletLayoutElement createFromElement(IDOMElement portletLayoutElement, ILayoutTplDiagramFactory factory) {
        IDOMElement[] portletColumnElements;
        if (portletLayoutElement == null) {
            return null;
        }
        PortletLayoutElement newPortletLayout = factory.newPortletLayout();
        String existingClassName = portletLayoutElement.getAttribute("class");
        if (!CoreUtil.isNullOrEmpty((String)existingClassName) && existingClassName.contains("portlet-layout")) {
            newPortletLayout.setClassName(existingClassName);
        } else {
            newPortletLayout.setClassName("portlet-layout");
        }
        IDOMElement[] iDOMElementArray = portletColumnElements = LayoutTplUtil.findChildElementsByClassName(portletLayoutElement, "div", "portlet-column");
        int n = portletColumnElements.length;
        int n2 = 0;
        while (n2 < n) {
            IDOMElement portletColumnElement = iDOMElementArray[n2];
            PortletColumnElement newPortletColumn = factory.newPortletColumnFromElement(portletColumnElement);
            newPortletLayout.addColumn(newPortletColumn);
            ++n2;
        }
        return newPortletLayout;
    }

    public boolean addColumn(PortletColumnElement newColumn) {
        return this.addColumn(newColumn, -1);
    }

    public boolean addColumn(PortletColumnElement newColumn, int index) {
        if (newColumn != null) {
            if (index < 0) {
                this.columns.add(newColumn);
            } else {
                this.columns.add(index, newColumn);
            }
            newColumn.setParent(this);
            newColumn.addPropertyChangeListener(this);
            this.firePropertyChange(COLUMN_ADDED_PROP, null, newColumn);
            return true;
        }
        return false;
    }

    public String getClassName() {
        return this.className;
    }

    public List<ModelElement> getColumns() {
        return this.columns;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if ("PortletColumn.weight".equals(prop)) {
            this.firePropertyChange(CHILD_COLUMN_WEIGHT_CHANGED_PROP, null, evt.getSource());
        }
    }

    @Override
    public void removeChild(ModelElement child) {
        if (this.columns.contains(child)) {
            this.removeColumn((PortletColumnElement)child);
        }
    }

    public boolean removeColumn(PortletColumnElement existingColumn) {
        if (existingColumn != null && this.columns.remove(existingColumn)) {
            this.firePropertyChange(COLUMN_REMOVED_PROP, null, existingColumn);
            return true;
        }
        return false;
    }

    public void setClassName(String className) {
        this.className = className;
    }
}

