/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.sdk.core;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.sdk.core.ISDKConstants;
import com.liferay.ide.sdk.core.SDK;
import com.liferay.ide.sdk.core.SDKManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.osgi.framework.Version;

public class SDKUtil {
    public static SDK createSDKFromLocation(IPath path) {
        try {
            if (SDKUtil.isValidSDKLocation(path.toOSString())) {
                SDK sdk = new SDK(path);
                sdk.setName(path.lastSegment());
                return sdk;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public static SDK getSDK(IProject project) {
        SDK retval = null;
        IPath projectLocation = project.getRawLocation();
        if (projectLocation == null) {
            projectLocation = project.getLocation();
        }
        if (projectLocation != null) {
            IPath sdkLocation = projectLocation.removeLastSegments(2);
            retval = SDKManager.getInstance().getSDK(sdkLocation);
            if (retval == null && (retval = SDKUtil.createSDKFromLocation(sdkLocation)) != null) {
                SDKManager.getInstance().addSDK(retval);
            }
        }
        if (retval == null) {
            IScopeContext[] context = new IScopeContext[]{new ProjectScope(project)};
            String sdkName = Platform.getPreferencesService().getString("com.liferay.ide.sdk.core", "sdk-name", null, context);
            retval = SDKManager.getInstance().getSDK(sdkName);
        }
        return retval;
    }

    public static SDK getSDKFromProjectDir(File projectDir) {
        File sdkDir = projectDir.getParentFile().getParentFile();
        if (sdkDir.exists() && SDKUtil.isValidSDKLocation(sdkDir.getPath())) {
            Path sdkLocation = new Path(sdkDir.getPath());
            SDK existingSDK = SDKManager.getInstance().getSDK((IPath)sdkLocation);
            if (existingSDK != null) {
                return existingSDK;
            }
            return SDKUtil.createSDKFromLocation((IPath)sdkLocation);
        }
        return null;
    }

    public static boolean isIvyProject(IProject project) {
        try {
            return SDKUtil.isSDKProject(project) && project.hasNature("org.apache.ivyde.eclipse.ivynature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public static boolean isSDKProject(IProject project) {
        if (project == null || !project.exists() || !project.isAccessible()) {
            return false;
        }
        return SDKUtil.getSDK(project) != null;
    }

    public static boolean isSDKSupported(String location) {
        boolean retval = false;
        try {
            String version = SDKUtil.readSDKVersion(location);
            retval = CoreUtil.compareVersions((Version)new Version(version), (Version)ISDKConstants.LEAST_SUPPORTED_SDK_VERSION) >= 0;
        }
        catch (Exception exception) {}
        return retval;
    }

    public static boolean isValidSDKLocation(String loc) {
        boolean retval = false;
        try {
            File sdkDir = new File(loc);
            File buildProperties = new File(sdkDir, "build.properties");
            File portletsBuildXml = new File(sdkDir, ISDKConstants.PORTLET_PLUGIN_ANT_BUILD);
            File hooksBuildXml = new File(sdkDir, ISDKConstants.HOOK_PLUGIN_ANT_BUILD);
            File extBuildXml = new File(sdkDir, ISDKConstants.EXT_PLUGIN_ANT_BUILD);
            retval = buildProperties.exists() && portletsBuildXml.exists() && hooksBuildXml.exists() && extBuildXml.exists();
        }
        catch (Exception exception) {}
        return retval;
    }

    public static boolean isValidSDKVersion(String sdkVersion, Version lowestValidVersion) {
        Version sdkVersionValue = null;
        try {
            sdkVersionValue = new Version(sdkVersion);
        }
        catch (Exception exception) {}
        return sdkVersionValue != null && CoreUtil.compareVersions((Version)sdkVersionValue, (Version)lowestValidVersion) >= 0;
    }

    static String readSDKVersion(String path) throws FileNotFoundException, IOException {
        Properties properties = new Properties();
        properties.load(new FileInputStream(new Path(path).append("build.properties").toFile()));
        return properties.getProperty("lp.version");
    }
}

