/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.tomcat.core;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.server.tomcat.core.ILiferayTomcatConstants;
import com.liferay.ide.server.tomcat.core.ILiferayTomcatRuntime;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.server.tomcat.core.internal.TomcatRuntimeClasspathProvider;
import org.eclipse.wst.server.core.IRuntime;

public class LiferayTomcatRuntimeClasspathProvider
extends TomcatRuntimeClasspathProvider {
    private static final String[] JARS = new String[]{"portal-impl.jar", "portal-service.jar", "support-tomcat.jar"};

    private IClasspathEntry[] getUpdatedJavadocEntries(IClasspathEntry[] entries, ILiferayTomcatRuntime liferayTomcatRuntime) {
        ArrayList<IClasspathEntry> updatedEntries = new ArrayList<IClasspathEntry>();
        String javadocURL = liferayTomcatRuntime.getJavadocURL();
        if (javadocURL != null) {
            IClasspathEntry[] iClasspathEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry existingEntry = iClasspathEntryArray[n2];
                IPath path = existingEntry.getPath();
                IClasspathEntry newEntry = null;
                String[] stringArray = JARS;
                int n3 = JARS.length;
                int n4 = 0;
                while (n4 < n3) {
                    String javadocJar = stringArray[n4];
                    if (path.lastSegment().equalsIgnoreCase(javadocJar)) {
                        Object[] extraAttrs = existingEntry.getExtraAttributes();
                        ArrayList<Object> newExtraAttrs = new ArrayList<Object>();
                        IClasspathAttribute javadocAttr = this.newJavadocAttr(javadocURL);
                        newExtraAttrs.add(javadocAttr);
                        if (!CoreUtil.isNullOrEmpty((Object[])extraAttrs)) {
                            Object[] objectArray = extraAttrs;
                            int n5 = extraAttrs.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                Object attr = objectArray[n6];
                                if (!attr.getName().equals("javadoc_location")) {
                                    newExtraAttrs.add(attr);
                                }
                                ++n6;
                            }
                        }
                        newEntry = JavaCore.newLibraryEntry((IPath)existingEntry.getPath(), (IPath)existingEntry.getSourceAttachmentPath(), (IPath)existingEntry.getSourceAttachmentRootPath(), (IAccessRule[])existingEntry.getAccessRules(), (IClasspathAttribute[])newExtraAttrs.toArray(new IClasspathAttribute[0]), (boolean)existingEntry.isExported());
                        break;
                    }
                    ++n4;
                }
                if (newEntry != null) {
                    updatedEntries.add(newEntry);
                } else {
                    updatedEntries.add(existingEntry);
                }
                ++n2;
            }
        } else {
            Collections.addAll(updatedEntries, entries);
        }
        return updatedEntries.toArray(new IClasspathEntry[0]);
    }

    private IClasspathEntry[] getUpdatedSourceEntries(IClasspathEntry[] entries, ILiferayTomcatRuntime liferayTomcatRuntime) {
        ArrayList<IClasspathEntry> updatedEntries = new ArrayList<IClasspathEntry>();
        IPath sourceLocation = liferayTomcatRuntime.getSourceLocation();
        if (sourceLocation != null) {
            IClasspathEntry[] iClasspathEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry existingEntry = iClasspathEntryArray[n2];
                IPath path = existingEntry.getPath();
                IClasspathEntry newEntry = null;
                String[] stringArray = JARS;
                int n3 = JARS.length;
                int n4 = 0;
                while (n4 < n3) {
                    String sourceJar = stringArray[n4];
                    if (path.lastSegment().equalsIgnoreCase(sourceJar)) {
                        IPath sourcePath = existingEntry.getSourceAttachmentPath();
                        if (sourcePath == null) {
                            sourcePath = sourceLocation;
                        }
                        newEntry = JavaCore.newLibraryEntry((IPath)existingEntry.getPath(), (IPath)sourcePath, (IPath)existingEntry.getSourceAttachmentRootPath(), (IAccessRule[])existingEntry.getAccessRules(), (IClasspathAttribute[])existingEntry.getExtraAttributes(), (boolean)existingEntry.isExported());
                        break;
                    }
                    ++n4;
                }
                if (newEntry != null) {
                    updatedEntries.add(newEntry);
                } else {
                    updatedEntries.add(existingEntry);
                }
                ++n2;
            }
        } else {
            Collections.addAll(updatedEntries, entries);
        }
        return updatedEntries.toArray(new IClasspathEntry[0]);
    }

    private IClasspathAttribute newJavadocAttr(String url) {
        return JavaCore.newClasspathAttribute((String)"javadoc_location", (String)url);
    }

    public IClasspathEntry[] resolveClasspathContainer(IProject project, IRuntime runtime) {
        IPath installPath = runtime.getLocation();
        if (installPath == null) {
            return new IClasspathEntry[0];
        }
        String runtimeId = runtime.getRuntimeType().getId();
        IClasspathEntry[] entries = this.resolveClasspathContainerForPath(installPath, runtimeId);
        ILiferayTomcatRuntime liferayTomcatRuntime = (ILiferayTomcatRuntime)runtime.loadAdapter(ILiferayTomcatRuntime.class, null);
        if (liferayTomcatRuntime != null) {
            if (liferayTomcatRuntime.getJavadocURL() != null) {
                entries = this.getUpdatedJavadocEntries(entries, liferayTomcatRuntime);
            }
            if (liferayTomcatRuntime.getSourceLocation() != null) {
                entries = this.getUpdatedSourceEntries(entries, liferayTomcatRuntime);
            }
        }
        return entries;
    }

    protected IClasspathEntry[] resolveClasspathContainerForPath(IPath installPath, String runtimeTypeId) {
        ArrayList list = new ArrayList();
        if (runtimeTypeId.endsWith("60") || runtimeTypeId.endsWith("70") || installPath.append("lib").toFile().exists()) {
            IPath path = installPath.append("lib");
            LiferayTomcatRuntimeClasspathProvider.addLibraryEntries(list, (File)path.toFile(), (boolean)true);
        }
        ArrayList<IClasspathEntry> optimizedList = new ArrayList<IClasspathEntry>();
        List<String> excludes = Arrays.asList(ILiferayTomcatConstants.LIB_EXCLUDES);
        for (IClasspathEntry entry : list) {
            if (excludes.contains(entry.getPath().lastSegment())) continue;
            optimizedList.add(entry);
        }
        return optimizedList.toArray(new IClasspathEntry[optimizedList.size()]);
    }

    protected void updateClasspath(IProject project, IRuntime runtime) {
    }
}

