/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.BaseLiferayProject;
import com.liferay.ide.project.core.IProjectBuilder;
import com.liferay.ide.project.core.SDKProjectBuilder;
import com.liferay.ide.sdk.core.SDK;
import com.liferay.ide.sdk.core.SDKManager;
import com.liferay.ide.sdk.core.SDKUtil;
import com.liferay.ide.server.core.ILiferayRuntime;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiferayRuntimeProject
extends BaseLiferayProject {
    private ILiferayRuntime liferayRuntime;

    public LiferayRuntimeProject(IProject project, ILiferayRuntime liferayRuntime) {
        super(project);
        this.liferayRuntime = liferayRuntime;
    }

    @Override
    public <T> T adapt(Class<T> adapterType) {
        SDK sdk;
        T adapter = super.adapt(adapterType);
        if (adapter != null) {
            return adapter;
        }
        if (IProjectBuilder.class.equals(adapterType) && (sdk = this.getSDK()) != null) {
            SDKProjectBuilder projectBuilder = new SDKProjectBuilder(this.getProject(), sdk);
            return adapterType.cast(projectBuilder);
        }
        return null;
    }

    public IPath getAppServerPortalDir() {
        return this.liferayRuntime.getAppServerPortalDir();
    }

    public String[] getHookSupportedProperties() {
        return this.liferayRuntime.getHookSupportedProperties();
    }

    public IPath getLibraryPath(String filename) {
        Object[] libs = this.getUserLibs();
        if (!CoreUtil.isNullOrEmpty((Object[])libs)) {
            Object[] objectArray = libs;
            int n = libs.length;
            int n2 = 0;
            while (n2 < n) {
                Object lib = objectArray[n2];
                if (lib.lastSegment().startsWith(filename)) {
                    return lib;
                }
                ++n2;
            }
        }
        return null;
    }

    public String getPortalVersion() {
        return this.liferayRuntime.getPortalVersion();
    }

    public Properties getPortletCategories() {
        return this.liferayRuntime.getPortletCategories();
    }

    public Properties getPortletEntryCategories() {
        return this.liferayRuntime.getPortletEntryCategories();
    }

    protected SDK getSDK() {
        SDK retval = null;
        IPath sdkLocation = this.getProject().getRawLocation().removeLastSegments(2);
        retval = SDKManager.getInstance().getSDK(sdkLocation);
        if (retval == null) {
            retval = SDKUtil.createSDKFromLocation((IPath)sdkLocation);
            SDKManager.getInstance().addSDK(retval);
        }
        return retval;
    }

    public IPath[] getUserLibs() {
        return this.liferayRuntime.getUserLibs();
    }
}

