/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.model.internal;

import com.liferay.ide.project.core.model.NewLiferayProfile;
import com.liferay.ide.server.core.ILiferayRuntime;
import com.liferay.ide.server.util.ServerUtil;
import java.util.ArrayList;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.services.DefaultValueService;
import org.eclipse.sapphire.services.DefaultValueServiceData;
import org.eclipse.sapphire.services.PossibleValuesService;

public class LiferayVersionDefaultValueService
extends DefaultValueService {
    private Set<String> possibleValues;
    private String runtimeVersion;

    protected void initDefaultValueService() {
        super.initDefaultValueService();
        PropertyDef def = (PropertyDef)this.context().find(PropertyDef.class);
        Property property = ((Element)this.context(Element.class)).property(def);
        final PossibleValuesService possibleValuesService = (PossibleValuesService)property.service(PossibleValuesService.class);
        possibleValuesService.attach(new Listener(){

            public void handle(Event event) {
                LiferayVersionDefaultValueService.this.possibleValues = possibleValuesService.values();
                LiferayVersionDefaultValueService.this.refresh();
            }
        });
        ((NewLiferayProfile)this.context(NewLiferayProfile.class)).property(NewLiferayProfile.PROP_RUNTIME_NAME).attach((Listener)new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                LiferayVersionDefaultValueService.this.possibleValues = possibleValuesService.values();
                LiferayVersionDefaultValueService.this.runtimeVersion = null;
                LiferayVersionDefaultValueService.this.refresh();
            }
        });
        this.possibleValues = possibleValuesService.values();
    }

    protected DefaultValueServiceData compute() {
        String data = null;
        if (this.possibleValues.size() > 0) {
            if (this.runtimeVersion == null) {
                new Job("get runtime version"){

                    protected IStatus run(IProgressMonitor monitor) {
                        String runtimeName = (String)((NewLiferayProfile)LiferayVersionDefaultValueService.this.context(NewLiferayProfile.class)).getRuntimeName().content();
                        ILiferayRuntime liferayRuntime = ServerUtil.getLiferayRuntime((String)runtimeName);
                        if (liferayRuntime != null) {
                            LiferayVersionDefaultValueService.this.runtimeVersion = liferayRuntime.getPortalVersion();
                            LiferayVersionDefaultValueService.this.refresh();
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
            } else {
                try {
                    ArrayList<String> filteredVals = new ArrayList<String>();
                    for (String val : this.possibleValues) {
                        if (val.equals(this.runtimeVersion)) {
                            data = val;
                            break;
                        }
                        if (!val.contains(this.runtimeVersion)) continue;
                        filteredVals.add(val);
                    }
                    if (data == null) {
                        data = filteredVals.size() > 0 ? this.checkForSnapshots(filteredVals.toArray(new String[0])) : this.checkForSnapshots(this.possibleValues.toArray(new String[0]));
                    }
                }
                catch (Exception exception) {}
            }
        }
        return new DefaultValueServiceData(data);
    }

    private String checkForSnapshots(String[] values) {
        String retval = null;
        retval = values[values.length - 1];
        if (retval.endsWith("SNAPSHOT") && values.length > 1) {
            retval = values[values.length - 2];
        }
        return retval;
    }
}

