/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.service.core;

import com.liferay.ide.core.ILiferayProject;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.LiferayProjectCore;
import com.liferay.ide.project.core.util.ProjectUtil;
import com.liferay.ide.project.core.util.WizardUtil;
import com.liferay.ide.service.core.ServiceCore;
import com.liferay.ide.service.core.operation.INewServiceBuilderDataModelProperties;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.osgi.framework.Version;

public class AddServiceBuilderOperation
extends AbstractDataModelOperation
implements INewServiceBuilderDataModelProperties {
    public AddServiceBuilderOperation(IDataModel model) {
        super(model);
    }

    public void createDefaultServiceBuilderFile(IFile serviceBuilderFile, IProgressMonitor monitor) throws CoreException {
        String descriptorVersion = null;
        try {
            ILiferayProject liferayProject = LiferayCore.create((Object)serviceBuilderFile.getProject());
            Version portalVersion = new Version(liferayProject.getPortalVersion());
            descriptorVersion = String.valueOf(portalVersion.getMajor()) + "." + portalVersion.getMinor() + ".0";
        }
        catch (Exception e) {
            LiferayProjectCore.logError((String)"Could not determine liferay runtime version", (Exception)e);
            descriptorVersion = "6.0.0";
        }
        WizardUtil.createDefaultServiceBuilderFile((IFile)serviceBuilderFile, (String)descriptorVersion, (boolean)this.getDataModel().getBooleanProperty("INewServiceBuilderDataModelProperties.USE_SAMPLE_TEMPLATE"), (String)this.getDataModel().getStringProperty("INewServiceBuilderDataModelProperties.PACKAGE_PATH"), (String)this.getDataModel().getStringProperty("INewServiceBuilderDataModelProperties.NAMESPACE"), (Object)this.getDataModel().getStringProperty("INewServiceBuilderDataModelProperties.AUTHOR"), (IProgressMonitor)monitor);
        this.getDataModel().setProperty("INewServiceBuilderDataModelProperties.CREATED_SERVICE_FILE", (Object)serviceBuilderFile);
    }

    private IStatus createServiceBuilderFile(IProject project, IProgressMonitor monitor) {
        IVirtualFolder webappRoot = CoreUtil.getDocroot((IProject)project);
        if (webappRoot == null) {
            return ServiceCore.createErrorStatus("Could not find webapp root folder.");
        }
        IContainer[] iContainerArray = webappRoot.getUnderlyingFolders();
        int n = iContainerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Path path;
            IFile serviceBuilderFile;
            IContainer container = iContainerArray[n2];
            if (container != null && container.exists() && !(serviceBuilderFile = container.getFile((IPath)(path = new Path("WEB-INF/" + this.getDataModel().getStringProperty("INewServiceBuilderDataModelProperties.SERVICE_FILE"))))).exists()) {
                try {
                    this.createDefaultServiceBuilderFile(serviceBuilderFile, monitor);
                    break;
                }
                catch (Exception ex) {
                    return ServiceCore.createErrorStatus(ex);
                }
            }
            ++n2;
        }
        return Status.OK_STATUS;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus retval = null;
        IStatus status = this.createServiceBuilderFile(this.getTargetProject(), monitor);
        if (!status.isOK()) {
            return status;
        }
        return retval;
    }

    protected IProject getTargetProject() {
        String projectName = this.model.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME");
        return ProjectUtil.getProject((String)projectName);
    }
}

