/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.service.core.job;

import com.liferay.ide.core.ILiferayProject;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.project.core.IProjectBuilder;
import com.liferay.ide.project.core.util.ProjectUtil;
import com.liferay.ide.service.core.ServiceCore;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

public class BuildServiceJob
extends Job {
    protected IFile serviceXmlFile;

    public BuildServiceJob(IFile serviceXmlFile) {
        super(Msgs.buildServices);
        this.serviceXmlFile = serviceXmlFile;
        this.setUser(true);
    }

    protected IProject getProject() {
        return this.serviceXmlFile != null ? this.serviceXmlFile.getProject() : null;
    }

    protected IProjectBuilder getProjectBuilder() throws CoreException {
        ILiferayProject liferayProject = LiferayCore.create((Object)this.getProject());
        if (liferayProject == null) {
            throw new CoreException(ServiceCore.createErrorStatus(NLS.bind((String)Msgs.couldNotCreateLiferayProject, (Object)this.getProject())));
        }
        IProjectBuilder builder = (IProjectBuilder)liferayProject.adapt(IProjectBuilder.class);
        if (builder == null) {
            throw new CoreException(ServiceCore.createErrorStatus(NLS.bind((String)Msgs.couldNotCreateProjectBuilder, (Object)this.getProject())));
        }
        return builder;
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus retval = null;
        if (this.getProject() == null) {
            return ServiceCore.createErrorStatus(Msgs.useLiferayProjectImportWizard);
        }
        if (!ProjectUtil.isLiferayFacetedProject((IProject)this.getProject())) {
            return ServiceCore.createErrorStatus(MessageFormat.format(Msgs.useConvertLiferayProject, this.getProject().getName()));
        }
        monitor.beginTask(Msgs.buildingLiferayServices, 100);
        IWorkspaceRunnable workspaceRunner = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                BuildServiceJob.this.runBuild(monitor);
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(workspaceRunner, monitor);
        }
        catch (CoreException e1) {
            retval = ServiceCore.createErrorStatus((Exception)((Object)e1));
        }
        return retval == null || retval.isOK() ? Status.OK_STATUS : retval;
    }

    protected void runBuild(IProgressMonitor monitor) throws CoreException {
        IProjectBuilder builder = this.getProjectBuilder();
        monitor.worked(50);
        IStatus retval = builder.buildService(this.serviceXmlFile, monitor);
        if (retval == null) {
            retval = ServiceCore.createErrorStatus(NLS.bind((String)Msgs.errorRunningBuildService, (Object)this.getProject()));
        }
        if (retval == null || !retval.isOK()) {
            throw new CoreException(retval);
        }
        monitor.worked(90);
    }

    protected static class Msgs
    extends NLS {
        public static String buildingLiferayServices;
        public static String buildServices;
        public static String couldNotCreateLiferayProject;
        public static String couldNotCreateProjectBuilder;
        public static String errorRunningBuildService;
        public static String useConvertLiferayProject;
        public static String useLiferayProjectImportWizard;

        static {
            Msgs.initializeMessages((String)BuildServiceJob.class.getName(), Msgs.class);
        }

        protected Msgs() {
        }
    }
}

