/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.service.core.job;

import com.liferay.ide.project.core.IProjectBuilder;
import com.liferay.ide.service.core.ServiceCore;
import com.liferay.ide.service.core.job.BuildServiceJob;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;

public class BuildWSDDJob
extends BuildServiceJob {
    public BuildWSDDJob(IFile serviceXmlFile) {
        super(serviceXmlFile);
        this.setName(Msgs.buildWSDD);
        this.setUser(true);
    }

    protected void runBuild(IProgressMonitor monitor) throws CoreException {
        IProjectBuilder builder = this.getProjectBuilder();
        monitor.worked(50);
        IStatus retval = builder.buildWSDD(this.serviceXmlFile, monitor);
        if (retval == null) {
            retval = ServiceCore.createErrorStatus(NLS.bind((String)Msgs.errorRunningBuildWSDD, (Object)this.getProject()));
        }
        if (retval == null || !retval.isOK()) {
            throw new CoreException(retval);
        }
        monitor.worked(90);
    }

    private static class Msgs
    extends NLS {
        public static String buildWSDD;
        public static String errorRunningBuildWSDD;

        static {
            Msgs.initializeMessages((String)BuildWSDDJob.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

