/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.service.core.operation;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.service.core.AddServiceBuilderOperation;
import com.liferay.ide.service.core.ServiceCore;
import com.liferay.ide.service.core.operation.INewServiceBuilderDataModelProperties;
import com.liferay.ide.service.core.util.ServiceUtil;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jst.j2ee.internal.common.J2EECommonMessages;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.internal.operation.ArtifactEditOperationDataModelProvider;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public class NewServiceBuilderDataModelProvider
extends ArtifactEditOperationDataModelProvider
implements INewServiceBuilderDataModelProperties {
    public IDataModelOperation getDefaultOperation() {
        return new AddServiceBuilderOperation(this.getDataModel());
    }

    public Object getDefaultProperty(String propertyName) {
        if ("INewServiceBuilderDataModelProperties.SERVICE_FILE".equals(propertyName)) {
            return "service.xml";
        }
        if ("INewServiceBuilderDataModelProperties.AUTHOR".equals(propertyName)) {
            return System.getProperty("user.name");
        }
        if ("INewServiceBuilderDataModelProperties.JAVA_PACKAGE_FRAGMENT_ROOT".equals(propertyName)) {
            return this.getJavaPackageFragmentRoot();
        }
        if (propertyName.equals("INewServiceBuilderDataModelProperties.JAVA_SOURCE_FOLDER")) {
            return this.getJavaSourceFolder();
        }
        if (propertyName.equals("INewServiceBuilderDataModelProperties.SOURCE_FOLDER")) {
            IFolder sourceFolder = this.getDefaultJavaSourceFolder();
            if (sourceFolder != null && sourceFolder.exists()) {
                return sourceFolder.getFullPath().toOSString();
            }
        } else {
            if ("NewJavaClassDataModel.OPEN_IN_EDITOR".equals(propertyName)) {
                return true;
            }
            if (propertyName.equals("INewServiceBuilderDataModelProperties.USE_SAMPLE_TEMPLATE")) {
                return true;
            }
        }
        return super.getDefaultProperty(propertyName);
    }

    public Set getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("INewServiceBuilderDataModelProperties.SERVICE_FILE");
        propertyNames.add("INewServiceBuilderDataModelProperties.JAVA_PACKAGE_FRAGMENT_ROOT");
        propertyNames.add("INewServiceBuilderDataModelProperties.JAVA_SOURCE_FOLDER");
        propertyNames.add("INewServiceBuilderDataModelProperties.SOURCE_FOLDER");
        propertyNames.add("INewServiceBuilderDataModelProperties.PACKAGE_PATH");
        propertyNames.add("INewServiceBuilderDataModelProperties.NAMESPACE");
        propertyNames.add("INewServiceBuilderDataModelProperties.AUTHOR");
        propertyNames.add("INewServiceBuilderDataModelProperties.CREATED_SERVICE_FILE");
        propertyNames.add("NewJavaClassDataModel.OPEN_IN_EDITOR");
        propertyNames.add("INewServiceBuilderDataModelProperties.USE_SAMPLE_TEMPLATE");
        return propertyNames;
    }

    public void init() {
        super.init();
    }

    public boolean isPropertyEnabled(String propertyName) {
        if ("INewServiceBuilderDataModelProperties.SERVICE_FILE".equals(propertyName)) {
            return false;
        }
        return super.isPropertyEnabled(propertyName);
    }

    public IStatus validate(String propertyName) {
        if ("INewServiceBuilderDataModelProperties.SERVICE_FILE".equals(propertyName)) {
            IFile serviceFile = this.getServiceFile();
            if (serviceFile == null) {
                return ServiceCore.createErrorStatus(Msgs.serviceFileSpecified);
            }
            if (!"xml".equals(serviceFile.getFileExtension())) {
                return ServiceCore.createErrorStatus(Msgs.serviceFileHaveXmlFileExtension);
            }
            if (serviceFile.exists()) {
                return ServiceCore.createErrorStatus(Msgs.projectContainsServiceXmlFile);
            }
        } else if ("INewServiceBuilderDataModelProperties.PACKAGE_PATH".equals(propertyName)) {
            String packagePath = this.getStringProperty(propertyName);
            if (CoreUtil.empty((String)packagePath)) {
                return ServiceCore.createErrorStatus(Msgs.packagePathNotEmpty);
            }
            if (!CoreUtil.empty((String)packagePath)) {
                return this.validateJavaPackage(packagePath);
            }
        } else if ("INewServiceBuilderDataModelProperties.NAMESPACE".equals(propertyName)) {
            String namespace = this.getStringProperty(propertyName);
            if (CoreUtil.empty((String)namespace)) {
                return ServiceCore.createErrorStatus(Msgs.namespaceNotEmpty);
            }
            if (!ServiceUtil.isValidNamespace(namespace)) {
                return ServiceCore.createErrorStatus(Msgs.namespaceInvalid);
            }
        }
        return super.validate(propertyName);
    }

    private IStatus validateJavaPackage(String packName) {
        if (packName != null && packName.trim().length() > 0) {
            IStatus javaStatus = JavaConventions.validatePackageName((String)packName, (String)"1.5", (String)"1.5");
            if (javaStatus.getSeverity() == 4) {
                String msg = String.valueOf(J2EECommonMessages.ERR_JAVA_PACAKGE_NAME_INVALID) + javaStatus.getMessage();
                return WTPCommonPlugin.createErrorStatus((String)msg);
            }
            if (javaStatus.getSeverity() == 2) {
                String msg = String.valueOf(J2EECommonMessages.ERR_JAVA_PACKAGE_NAME_WARNING) + javaStatus.getMessage();
                return WTPCommonPlugin.createWarningStatus((String)msg);
            }
        }
        return Status.OK_STATUS;
    }

    protected IFolder getDefaultJavaSourceFolder() {
        IProject project = this.getTargetProject();
        if (project == null) {
            return null;
        }
        IPackageFragmentRoot[] sources = J2EEProjectUtilities.getSourceContainers((IProject)project);
        if (sources.length > 0) {
            try {
                return (IFolder)sources[0].getCorrespondingResource();
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    protected IPackageFragmentRoot getJavaPackageFragmentRoot() {
        IFolder sourcefolder;
        IJavaProject aJavaProject;
        IProject project = this.getTargetProject();
        if (project != null && (aJavaProject = JemProjectUtilities.getJavaProject((IProject)project)) != null && (sourcefolder = (IFolder)this.getProperty("INewServiceBuilderDataModelProperties.JAVA_SOURCE_FOLDER")) != null) {
            return aJavaProject.getPackageFragmentRoot((IResource)sourcefolder);
        }
        return null;
    }

    protected final IFolder getJavaSourceFolder() {
        IPackageFragmentRoot[] sources = J2EEProjectUtilities.getSourceContainers((IProject)this.getTargetProject());
        if (sources == null || sources.length == 0) {
            return null;
        }
        String folderFullPath = this.getStringProperty("INewServiceBuilderDataModelProperties.SOURCE_FOLDER");
        int i = 0;
        while (i < sources.length) {
            if (sources[i].getPath().equals((Object)new Path(folderFullPath))) {
                try {
                    return (IFolder)sources[i].getCorrespondingResource();
                }
                catch (Exception exception) {
                    break;
                }
            }
            ++i;
        }
        return null;
    }

    protected IFile getServiceFile() {
        IVirtualFolder webInfFolder;
        String serviceFileProperty = this.getStringProperty("INewServiceBuilderDataModelProperties.SERVICE_FILE");
        if (CoreUtil.isNullOrEmpty((String)serviceFileProperty)) {
            return null;
        }
        IVirtualFolder webappRoot = CoreUtil.getDocroot((IProject)this.getTargetProject());
        if (webappRoot != null && (webInfFolder = webappRoot.getFolder("WEB-INF")) != null) {
            IContainer[] iContainerArray = webInfFolder.getUnderlyingFolders();
            int n = iContainerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IContainer container = iContainerArray[n2];
                if (container != null && container.exists()) {
                    return container.getFile((IPath)new Path(serviceFileProperty));
                }
                ++n2;
            }
        }
        return null;
    }

    protected IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    protected IStatus validateListItems(String propertyName) {
        List itemsList;
        Object items = this.getProperty(propertyName);
        if (items instanceof List && (itemsList = (List)items).size() > 0) {
            return Status.OK_STATUS;
        }
        return ServiceCore.createErrorStatus(Msgs.specifyOneItem);
    }

    private static class Msgs
    extends NLS {
        public static String namespaceInvalid;
        public static String namespaceNotEmpty;
        public static String packagePathNotEmpty;
        public static String projectContainsServiceXmlFile;
        public static String serviceFileHaveXmlFileExtension;
        public static String serviceFileSpecified;
        public static String specifyOneItem;

        static {
            Msgs.initializeMessages((String)NewServiceBuilderDataModelProvider.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

