/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.spec.impl;

import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.spec.BaseQuery;
import org.eclipse.datatools.connectivity.oda.spec.IValidator;
import org.eclipse.datatools.connectivity.oda.spec.QuerySpecification;
import org.eclipse.datatools.connectivity.oda.spec.ValidationContext;
import org.eclipse.datatools.connectivity.oda.spec.ValueExpression;
import org.eclipse.datatools.connectivity.oda.spec.result.AggregateExpression;
import org.eclipse.datatools.connectivity.oda.spec.result.FilterExpression;
import org.eclipse.datatools.connectivity.oda.spec.result.ResultSetSpecification;
import org.eclipse.datatools.connectivity.oda.spec.result.SortSpecification;
import org.eclipse.datatools.connectivity.oda.spec.util.QuerySpecificationHelper;

public class ValidatorBaseImpl
implements IValidator {
    protected ValidatorBaseImpl() {
    }

    @Override
    public void closeConnection(ValidationContext.Connection validationConnection) {
    }

    @Override
    public void validate(QuerySpecification querySpec, ValidationContext context) throws OdaException {
        if (querySpec == null) {
            return;
        }
        boolean hasSetQueryText = this.setContextQueryTextFromSpec(context, querySpec);
        this.validate(querySpec.getResultSetSpecification(), context);
        if (querySpec.getBaseQuery() != null) {
            this.validate(querySpec.getBaseQuery(), context);
        }
        if (hasSetQueryText) {
            context.setQueryText(null);
        }
    }

    protected boolean setContextQueryTextFromSpec(ValidationContext context, QuerySpecification querySpec) {
        if (context == null || context.getQueryText() != null) {
            return false;
        }
        if (!QuerySpecificationHelper.hasAtomicQueryText(querySpec)) {
            return false;
        }
        context.setQueryText(QuerySpecificationHelper.getAtomicQuery(querySpec).getQueryText());
        return true;
    }

    @Override
    public void validate(ResultSetSpecification resultSetSpec, ValidationContext context) throws OdaException {
    }

    @Override
    public void validate(FilterExpression filterExpr, ValidationContext context) throws OdaException {
        this.validateSyntax(filterExpr, context);
    }

    @Override
    public void validate(AggregateExpression aggrExpr, ValidationContext context) throws OdaException {
        this.validateSyntax(aggrExpr, context);
    }

    @Override
    public void validate(ValueExpression valueExpr, ValidationContext context) throws OdaException {
        this.validateSyntax(valueExpr, context);
    }

    @Override
    public void validate(SortSpecification sortSpec, ValidationContext context) throws OdaException {
    }

    @Override
    public void validate(BaseQuery baseQuery, ValidationContext context) throws OdaException {
        this.validateSyntax(baseQuery, context);
    }

    @Override
    public void validateSyntax(FilterExpression filterExpr, ValidationContext context) throws OdaException {
    }

    @Override
    public void validateSyntax(AggregateExpression aggrExpr, ValidationContext context) throws OdaException {
    }

    @Override
    public void validateSyntax(ValueExpression valueExpr, ValidationContext context) throws OdaException {
    }

    @Override
    public void validateSyntax(BaseQuery baseQuery, ValidationContext context) throws OdaException {
    }
}

