/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.portlet.ui.navigator.actions;

import com.liferay.ide.portlet.core.model.Portlet;
import com.liferay.ide.portlet.ui.PortletUIPlugin;
import com.liferay.ide.portlet.ui.navigator.PortletNode;
import com.liferay.ide.portlet.ui.navigator.PortletResourcesRootNode;
import com.liferay.ide.portlet.ui.navigator.PortletsNode;
import com.liferay.ide.project.core.util.ProjectUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.java.JavaTypeName;
import org.eclipse.sapphire.ui.SapphireEditor;
import org.eclipse.sapphire.ui.forms.MasterDetailsContentNodePart;
import org.eclipse.sapphire.ui.forms.MasterDetailsContentOutline;
import org.eclipse.sapphire.ui.forms.swt.MasterDetailsEditorPage;
import org.eclipse.sapphire.ui.swt.xml.editor.SapphireEditorForXml;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public class OpenPortletResourceAction
extends BaseSelectionListenerAction {
    private static final String ACTION_MESSAGE = Msgs.openPortletConfigurationFile;
    private static final String PORTLETS_NODE_LABEL = Msgs.portlets;
    protected IEditorPart editorPart;
    protected Object selectedNode;

    public OpenPortletResourceAction() {
        super(ACTION_MESSAGE);
    }

    protected IEditorDescriptor findEditor(IFile file) {
        IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
        IContentType contentType = IDE.getContentType((IFile)file);
        IEditorDescriptor editorDescriptor = registry.getDefaultEditor(file.getName(), contentType);
        if (editorDescriptor == null) {
            return null;
        }
        return editorDescriptor;
    }

    protected IFile initEditorPart() {
        PortletResourcesRootNode rootNode;
        IFile file = null;
        if (this.selectedNode instanceof PortletsNode) {
            PortletsNode portletsNode = (PortletsNode)this.selectedNode;
            rootNode = portletsNode.getParent();
            file = ProjectUtil.getPortletXmlFile((IProject)rootNode.getProject());
        } else if (this.selectedNode instanceof PortletNode) {
            PortletNode portletNode = (PortletNode)this.selectedNode;
            rootNode = portletNode.getParent().getParent();
            file = ProjectUtil.getPortletXmlFile((IProject)rootNode.getProject());
        }
        if (this.editorPart == null && file != null) {
            IEditorReference[] editorReferences;
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IEditorReference[] iEditorReferenceArray = editorReferences = page.getEditorReferences();
            int n = editorReferences.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference iEditorReference = iEditorReferenceArray[n2];
                if (file.getName().equals(iEditorReference.getName())) {
                    this.editorPart = iEditorReference.getEditor(false);
                }
                ++n2;
            }
        }
        return file;
    }

    protected IEditorPart openEditor(IFile file) {
        IEditorDescriptor editorDescriptor = this.findEditor(file);
        IEditorPart editorPart = null;
        if (editorDescriptor != null) {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                editorPart = page.findEditor((IEditorInput)new FileEditorInput(file));
                if (editorPart == null) {
                    editorPart = page.openEditor((IEditorInput)new FileEditorInput(file), editorDescriptor.getId());
                }
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)page.getWorkbenchWindow().getShell(), (String)Msgs.errorOpeningFile, (String)e.getMessage());
            }
        }
        return editorPart;
    }

    protected void openPortletJavaClass(final IFile file) {
        Element modelElement = ((PortletNode)this.selectedNode).getModel();
        if (modelElement instanceof Portlet) {
            Portlet portlet = (Portlet)modelElement;
            final JavaTypeName portletClassFile = (JavaTypeName)portlet.getPortletClass().content();
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    block5: {
                        IJavaProject project = JavaCore.create((IProject)file.getProject());
                        String fullyQualifiedName = portletClassFile.qualified();
                        try {
                            IResource resource;
                            IType type = project.findType(fullyQualifiedName);
                            if (type == null || !type.exists() || !((resource = type.getResource()) instanceof IFile)) break block5;
                            IFile javaFile = (IFile)resource;
                            IEditorDescriptor editorDescriptor = OpenPortletResourceAction.this.findEditor(javaFile);
                            IEditorPart editorPart = null;
                            if (editorDescriptor == null) break block5;
                            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                            try {
                                editorPart = page.findEditor((IEditorInput)new FileEditorInput(javaFile));
                                if (editorPart == null) {
                                    editorPart = page.openEditor((IEditorInput)new FileEditorInput(javaFile), editorDescriptor.getId());
                                }
                            }
                            catch (Exception e) {
                                MessageDialog.openError((Shell)page.getWorkbenchWindow().getShell(), (String)Msgs.errorOpeningFile, (String)e.getMessage());
                            }
                        }
                        catch (JavaModelException e) {
                            PortletUIPlugin.logError((Exception)((Object)e));
                        }
                    }
                }
            });
        }
    }

    public void run() {
        IFile file;
        if (this.isEnabled() && (file = this.initEditorPart()) != null && file.exists()) {
            this.editorPart = this.openEditor(file);
            if (this.editorPart != null && this.selectedNode instanceof PortletNode) {
                this.selectAndRevealItem(this.editorPart);
                this.openPortletJavaClass(file);
            }
        }
    }

    protected void selectAndRevealItem(IEditorPart editorPart) {
        if (this.editorPart instanceof SapphireEditor) {
            MasterDetailsContentNodePart portletAppNode;
            MasterDetailsContentNodePart portletsNode;
            MasterDetailsContentOutline contentOutline;
            MasterDetailsContentNodePart rootNode;
            MasterDetailsEditorPage mdepDetailsEditorPage;
            SapphireEditorForXml editor = (SapphireEditorForXml)editorPart;
            PortletNode portletNavigatorNode = (PortletNode)this.selectedNode;
            Element selectedModelElement = portletNavigatorNode.getModel();
            if (selectedModelElement != null && (mdepDetailsEditorPage = (MasterDetailsEditorPage)editor.getActivePageInstance()) != null && (rootNode = (contentOutline = mdepDetailsEditorPage.outline()).getRoot()) != null && (portletsNode = (portletAppNode = (MasterDetailsContentNodePart)rootNode.nodes().visible().get(0)).findNode(PORTLETS_NODE_LABEL)) != null && selectedModelElement instanceof Portlet) {
                Portlet selectedPortlet = (Portlet)selectedModelElement;
                for (MasterDetailsContentNodePart childNode : portletsNode.nodes().visible()) {
                    Portlet mpContentNodePortlet;
                    String mpContentNodePortletName;
                    String selectedPortletName = (String)selectedPortlet.getPortletName().content();
                    if (!(childNode.getModelElement() instanceof Portlet) || !selectedPortletName.equals(mpContentNodePortletName = (String)(mpContentNodePortlet = (Portlet)childNode.getModelElement()).getPortletName().content())) continue;
                    childNode.select();
                    childNode.setExpanded(true);
                    break;
                }
            }
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        if (selection.size() == 1) {
            this.selectedNode = selection.getFirstElement();
            if (this.editorPart == null) {
                this.initEditorPart();
            }
            if (this.editorPart != null && this.selectedNode instanceof PortletNode) {
                this.selectAndRevealItem(this.editorPart);
            }
            return true;
        }
        return false;
    }

    private static class Msgs
    extends NLS {
        public static String errorOpeningFile;
        public static String openPortletConfigurationFile;
        public static String portlets;

        static {
            Msgs.initializeMessages((String)OpenPortletResourceAction.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

