/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.debug.ui.fm;

import com.liferay.ide.debug.core.fm.FMStackFrame;
import com.liferay.ide.debug.core.fm.FMThread;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.internal.AbstractEnabledHandler;

public class SuspendFreemarkerThreadHandler
extends AbstractEnabledHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        FMStackFrame stackFrame = this.getSelectedFMStackFrame(event.getApplicationContext());
        if (stackFrame != null) {
            try {
                stackFrame.suspendJavaThread();
            }
            catch (DebugException e) {
                throw new ExecutionException("Could not suspend related freemaker thread", (Throwable)e);
            }
        }
        return null;
    }

    private Object getSelectedElement(Object context) {
        IStructuredSelection selection;
        IEvaluationContext evaluationContext;
        Object currentSelectionVar;
        if (context instanceof IEvaluationContext && (currentSelectionVar = (evaluationContext = (IEvaluationContext)context).getVariable("selection")) instanceof IStructuredSelection && (selection = (IStructuredSelection)currentSelectionVar).size() == 1) {
            return selection.getFirstElement();
        }
        return null;
    }

    private FMStackFrame getSelectedFMStackFrame(Object context) {
        Object selectedElement = this.getSelectedElement(context);
        FMThread fmThread = null;
        FMStackFrame fmStackFrame = null;
        if (selectedElement instanceof FMThread) {
            fmThread = (FMThread)selectedElement;
            if (fmThread.isSuspended()) {
                try {
                    fmStackFrame = (FMStackFrame)fmThread.getTopStackFrame();
                }
                catch (DebugException debugException) {}
            }
        } else if (selectedElement instanceof FMStackFrame) {
            fmStackFrame = (FMStackFrame)selectedElement;
        }
        return fmStackFrame;
    }

    public void setEnabled(Object evaluationContext) {
        super.setEnabled(this.getSelectedFMStackFrame(evaluationContext) != null);
    }
}

