/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.hook.ui.editor;

import com.liferay.ide.core.ILiferayProject;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.hook.core.model.CustomJsp;
import com.liferay.ide.hook.core.model.CustomJspDir;
import com.liferay.ide.hook.core.model.Hook;
import com.liferay.ide.hook.core.model.Hook6xx;
import com.liferay.ide.hook.core.model.internal.PortalPropertiesBindingImpl;
import com.liferay.ide.hook.ui.HookUI;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyBinding;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.xml.XmlResource;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.swt.xml.editor.SapphireEditorForXml;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.FileEditorInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HookXmlEditor
extends SapphireEditorForXml {
    public static final String ID = "com.liferay.ide.eclipse.hook.ui.editor.HookXmlEditor";
    protected boolean customModelDirty = false;
    private boolean ignoreCustomModelChanges;

    public HookXmlEditor() {
        super(Hook6xx.TYPE, DefinitionLoader.sdef(HookXmlEditor.class).page("HookConfigurationPage"));
    }

    protected void adaptModel(Element model) {
        super.adaptModel(model);
        FilteredListener<PropertyContentEvent> listener = new FilteredListener<PropertyContentEvent>(){

            public void handleTypedEvent(PropertyContentEvent event) {
                HookXmlEditor.this.handleCustomJspsPropertyChangedEvent(event);
            }
        };
        this.ignoreCustomModelChanges = true;
        model.attach((Listener)listener, String.valueOf(Hook.PROP_CUSTOM_JSPS.name()) + "/*");
        model.attach((Listener)listener, String.valueOf(Hook.PROP_PORTAL_PROPERTIES_OVERRIDES.name()) + "/*");
        this.ignoreCustomModelChanges = false;
    }

    private void copyCustomJspsToProject(IPath portalDir, ElementList<CustomJsp> customJsps) {
        try {
            CustomJspDir customJspDirElement = (CustomJspDir)((Hook)this.getModelElement().nearest(Hook.class)).getCustomJspDir().content();
            if (customJspDirElement != null && customJspDirElement.validation().ok()) {
                Path customJspDir = (Path)customJspDirElement.getValue().content();
                IFolder defaultDocroot = CoreUtil.getDefaultDocrootFolder((IProject)this.getProject());
                IFolder customJspFolder = defaultDocroot.getFolder(customJspDir.toPortableString());
                for (CustomJsp customJsp : customJsps) {
                    IFile customJspFile;
                    String content = (String)customJsp.getValue().content();
                    if (CoreUtil.empty((String)content) || (customJspFile = customJspFolder.getFile(content)).exists()) continue;
                    IPath portalJsp = portalDir.append(content);
                    try {
                        CoreUtil.makeFolders((IFolder)((IFolder)customJspFile.getParent()));
                        customJspFile.create((InputStream)new FileInputStream(portalJsp.toFile()), true, null);
                    }
                    catch (Exception e) {
                        HookUI.logError(e);
                    }
                }
            }
        }
        catch (Exception e) {
            HookUI.logError(e);
        }
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.customModelDirty) {
            PropertyBinding binding;
            Hook hook = (Hook)this.getModelElement().nearest(Hook.class);
            ElementList customJsps = hook.getCustomJsps();
            ILiferayProject liferayProject = LiferayCore.create((Object)this.getProject());
            IPath portalDir = liferayProject.getAppServerPortalDir();
            if (portalDir != null) {
                this.copyCustomJspsToProject(portalDir, (ElementList<CustomJsp>)customJsps);
            }
            if ((binding = ((XmlResource)hook.resource().adapt(XmlResource.class)).binding((Property)hook.getPortalPropertiesOverrides())) instanceof PortalPropertiesBindingImpl) {
                PortalPropertiesBindingImpl portalPropertiesBindingImpl = (PortalPropertiesBindingImpl)PortalPropertiesBindingImpl.class.cast(binding);
                portalPropertiesBindingImpl.flush();
            }
            this.customModelDirty = false;
            super.doSave(monitor);
            this.firePropertyChange(257);
        } else {
            super.doSave(monitor);
        }
    }

    public InputStream getFileContents() throws CoreException, MalformedURLException, IOException {
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof FileEditorInput) {
            return ((FileEditorInput)editorInput).getFile().getContents();
        }
        if (editorInput instanceof IStorageEditorInput) {
            return ((IStorageEditorInput)editorInput).getStorage().getContents();
        }
        if (editorInput instanceof FileStoreEditorInput) {
            return ((FileStoreEditorInput)editorInput).getURI().toURL().openStream();
        }
        return null;
    }

    protected void handleCustomJspsPropertyChangedEvent(PropertyContentEvent event) {
        if (this.ignoreCustomModelChanges) {
            return;
        }
        this.customModelDirty = true;
        this.firePropertyChange(257);
    }

    public boolean isDirty() {
        if (this.customModelDirty) {
            return true;
        }
        return super.isDirty();
    }

    protected void pageChange(int pageIndex) {
        this.ignoreCustomModelChanges = true;
        super.pageChange(pageIndex);
        this.ignoreCustomModelChanges = false;
    }
}

