/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.hook.ui.wizard;

import com.liferay.ide.core.ILiferayProject;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.hook.ui.HookUI;
import com.liferay.ide.hook.ui.wizard.NewEventActionClassDialog;
import com.liferay.ide.hook.ui.wizard.PropertiesFilteredDialog;
import com.liferay.ide.ui.dialog.FilteredTypesSelectionDialogEx;
import com.liferay.ide.ui.wizard.StringArrayTableWizardSection;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.core.search.BasicSearchEngine;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class EventActionsTableWizardSection
extends StringArrayTableWizardSection {
    protected String[] buttonLabels = new String[]{Msgs.select, Msgs.selectNew};
    protected IProject project;

    public EventActionsTableWizardSection(Composite parent, String componentLabel, String dialogTitle, String addButtonLabel, String editButtonLabel, String removeButtonLabel, String[] columnTitles, String[] fieldLabels, Image labelProviderImage, IDataModel model, String propertyName) {
        super(parent, componentLabel, dialogTitle, addButtonLabel, editButtonLabel, removeButtonLabel, columnTitles, fieldLabels, labelProviderImage, model, propertyName);
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    protected void handleAddButtonSelected() {
        AddEventActionDialog dialog = new AddEventActionDialog(this.getShell(), this.dialogTitle, this.fieldLabels, this.buttonLabels);
        if (dialog.open() == 0) {
            String[] stringArray = dialog.getStringArray();
            this.addStringArray(stringArray);
        }
    }

    protected void handleEditButtonSelected() {
        ISelection s = this.viewer.getSelection();
        if (!(s instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)s;
        if (selection.size() != 1) {
            return;
        }
        Object selectedObj = selection.getFirstElement();
        String[] valuesForText = (String[])selectedObj;
        EditEventActionDialog dialog = new EditEventActionDialog(this.getShell(), this.dialogTitle, this.fieldLabels, valuesForText);
        dialog.open();
        String[] stringArray = dialog.getStringArray();
        this.editStringArray(valuesForText, stringArray);
    }

    protected class AddEventActionDialog
    extends StringArrayTableWizardSection.AddStringArrayDialog {
        protected String[] buttonLabels;
        protected CLabel errorMessageLabel;

        public AddEventActionDialog(Shell shell, String windowTitle, String[] labelsForTextField, String[] buttonLabels) {
            super((StringArrayTableWizardSection)EventActionsTableWizardSection.this, shell, windowTitle, labelsForTextField);
            this.setShellStyle(this.getShellStyle() | 0x10);
            this.buttonLabels = buttonLabels;
            this.setWidthHint(450);
        }

        protected Control createContents(Composite parent) {
            Composite composite = (Composite)super.createContents(parent);
            this.getButton(0).setEnabled(false);
            return composite;
        }

        public Control createDialogArea(Composite parent) {
            super.createDialogArea(parent);
            this.errorMessageLabel = new CLabel(parent, 0x2000000);
            this.errorMessageLabel.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
            this.errorMessageLabel.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK"));
            this.errorMessageLabel.setVisible(false);
            return parent;
        }

        protected Text createField(Composite parent, final int index) {
            Label label = new Label(parent, 16384);
            label.setText(this.labelsForTextField[index]);
            label.setLayoutData((Object)new GridData(32));
            final Text text = new Text(parent, 2052);
            GridData data = new GridData(768);
            text.setLayoutData((Object)data);
            Composite buttonComposite = new Composite(parent, 0);
            String[] buttonLbls = this.buttonLabels[index].split(",");
            GridLayout gl = new GridLayout(buttonLbls.length, true);
            gl.marginWidth = 0;
            gl.horizontalSpacing = 1;
            buttonComposite.setLayout((Layout)gl);
            String[] stringArray = buttonLbls;
            int n = buttonLbls.length;
            int n2 = 0;
            while (n2 < n) {
                final String lbl = stringArray[n2];
                Button button = new Button(buttonComposite, 8);
                button.setText(lbl);
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        AddEventActionDialog.this.handleArrayDialogButtonSelected(index, lbl, text);
                    }
                });
                ++n2;
            }
            return text;
        }

        protected void handleArrayDialogButtonSelected(int index, String label, Text text) {
            if (index == 0) {
                this.handleSelectEventButton(text);
            } else if (index == 1 && Msgs.select.equals(label)) {
                this.handleSelectClassButton(text);
            } else if (index == 1 && Msgs.newLabel.equals(label)) {
                this.handleNewClassButton(text);
            }
        }

        protected void handleNewClassButton(Text text) {
            NewEventActionClassDialog dialog = new NewEventActionClassDialog(this.getShell(), EventActionsTableWizardSection.this.model);
            if (dialog.open() == 0) {
                String qualifiedClassname = dialog.getQualifiedClassname();
                text.setText(qualifiedClassname);
            }
        }

        protected void handleSelectClassButton(Text text) {
            Text control = text;
            IJavaSearchScope scope = null;
            try {
                scope = BasicSearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{JavaCore.create((IProject)CoreUtil.getProject((String)EventActionsTableWizardSection.this.model.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME")))});
            }
            catch (Exception e) {
                HookUI.logError(e);
                return;
            }
            FilteredTypesSelectionDialogEx dialog = new FilteredTypesSelectionDialogEx(this.getShell(), false, null, scope, 5);
            dialog.setTitle(Msgs.eventSelection);
            dialog.setMessage(Msgs.selectEventAction);
            if (dialog.open() == 0) {
                IType type = (IType)dialog.getFirstResult();
                String classFullPath = "";
                if (type != null) {
                    classFullPath = type.getFullyQualifiedName();
                }
                if (control instanceof Text) {
                    control.setText(classFullPath);
                } else if (control instanceof Combo) {
                    ((Combo)control).setText(classFullPath);
                }
                return;
            }
        }

        protected void handleSelectEventButton(Text text) {
            String[] hookProperties = new String[]{};
            ILiferayProject liferayProject = LiferayCore.create((Object)EventActionsTableWizardSection.this.project);
            if (liferayProject != null) {
                hookProperties = liferayProject.getHookSupportedProperties();
            }
            PropertiesFilteredDialog dialog = new PropertiesFilteredDialog(this.getParentShell(), ".*events.*");
            dialog.setTitle(Msgs.propertySelection);
            dialog.setMessage(Msgs.selectProperty);
            dialog.setInput(hookProperties);
            if (dialog.open() == 0) {
                Object[] selected = dialog.getResult();
                text.setText(selected[0].toString());
            }
        }

        public void modifyText(ModifyEvent e) {
            boolean classNameValid = false;
            if (this.texts[1].getText().trim().length() > 0) {
                int classNameStatus = JavaConventions.validateJavaTypeName((String)this.texts[1].getText().trim(), (String)"1.5", (String)"1.5").getSeverity();
                boolean bl = classNameValid = classNameStatus != 4;
            }
            if (!classNameValid) {
                this.errorMessageLabel.setText("Invalid class name");
            }
            this.errorMessageLabel.setVisible(!classNameValid);
            this.getButton(0).setEnabled(classNameValid);
        }
    }

    public class EditEventActionDialog
    extends StringArrayTableWizardSection.EditStringArrayDialog {
        protected CLabel errorMessageLabel;

        public EditEventActionDialog(Shell shell, String windowTitle, String[] labelsForTextField, String[] valuesForTextField) {
            super((StringArrayTableWizardSection)EventActionsTableWizardSection.this, shell, windowTitle, labelsForTextField, valuesForTextField);
        }

        public Control createDialogArea(Composite parent) {
            super.createDialogArea(parent);
            this.errorMessageLabel = new CLabel(parent, 0x2000000);
            this.errorMessageLabel.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
            this.errorMessageLabel.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK"));
            this.errorMessageLabel.setVisible(false);
            return parent;
        }

        public void modifyText(ModifyEvent e) {
            boolean classNameValid = false;
            if (this.texts[1].getText().trim().length() > 0) {
                int classNameStatus = JavaConventions.validateJavaTypeName((String)this.texts[1].getText().trim(), (String)"1.5", (String)"1.5").getSeverity();
                boolean bl = classNameValid = classNameStatus != 4;
            }
            if (!classNameValid) {
                this.errorMessageLabel.setText("Invalid class name");
            }
            this.errorMessageLabel.setVisible(!classNameValid);
            this.getButton(0).setEnabled(classNameValid);
        }
    }

    private static class Msgs
    extends NLS {
        public static String eventSelection;
        public static String newLabel;
        public static String propertySelection;
        public static String select;
        public static String selectEventAction;
        public static String selectNew;
        public static String selectProperty;

        static {
            Msgs.initializeMessages((String)EventActionsTableWizardSection.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

