/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui;

import com.liferay.ide.core.ILiferayConstants;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.ui.ProjectUIPlugin;
import com.liferay.ide.sdk.core.SDK;
import com.liferay.ide.sdk.core.SDKUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.ivyde.eclipse.cp.ClasspathSetup;
import org.apache.ivyde.eclipse.cp.IvyClasspathContainer;
import org.apache.ivyde.eclipse.cp.IvyClasspathContainerConfiguration;
import org.apache.ivyde.eclipse.cp.IvyClasspathContainerHelper;
import org.apache.ivyde.eclipse.cp.SettingsSetup;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.j2ee.classpathdep.ClasspathDependencyUtil;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.osgi.framework.Version;

public class IvyUtil {
    public static IvyClasspathContainer addIvyLibrary(IProject project, IProgressMonitor monitor) {
        StringBuilder builder;
        String projectName = project.getName();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IvyClasspathContainerConfiguration conf = new IvyClasspathContainerConfiguration(javaProject, "ivy.xml", true);
        ClasspathSetup classpathSetup = new ClasspathSetup();
        conf.setAdvancedProjectSpecific(false);
        conf.setClasspathSetup(classpathSetup);
        conf.setClassthProjectSpecific(false);
        conf.setConfs(Collections.singletonList("*"));
        conf.setMappingProjectSpecific(false);
        conf.setSettingsProjectSpecific(true);
        SDK sdk = SDKUtil.getSDK((IProject)project);
        SettingsSetup settingsSetup = new SettingsSetup();
        if (sdk.getLocation().append("ivy-settings.xml").toFile().exists()) {
            builder = new StringBuilder();
            builder.append("${");
            builder.append("liferay_sdk_dir");
            builder.append(":");
            builder.append(projectName);
            builder.append("}/");
            builder.append("ivy-settings.xml");
            settingsSetup.setIvySettingsPath(builder.toString());
        }
        builder = new StringBuilder();
        builder.append("${");
        builder.append("liferay_sdk_dir");
        builder.append(":");
        builder.append(projectName);
        builder.append("}/.ivy");
        settingsSetup.setIvyUserDir(builder.toString());
        conf.setIvySettingsSetup(settingsSetup);
        IPath path = conf.getPath();
        IClasspathAttribute[] atts = conf.getAttributes();
        IClasspathEntry ivyEntry = JavaCore.newContainerEntry((IPath)path, null, (IClasspathAttribute[])atts, (boolean)false);
        IVirtualComponent virtualComponent = ComponentCore.createComponent((IProject)project);
        try {
            IClasspathEntry[] entries = javaProject.getRawClasspath();
            ArrayList<IClasspathEntry> newEntries = new ArrayList<IClasspathEntry>(Arrays.asList(entries));
            IPath runtimePath = ClasspathDependencyUtil.getDefaultRuntimePath((IVirtualComponent)virtualComponent, (IClasspathEntry)ivyEntry);
            IClasspathEntry cpeTagged = ClasspathDependencyUtil.modifyDependencyPath((IClasspathEntry)ivyEntry, (IPath)runtimePath);
            newEntries.add(cpeTagged);
            entries = newEntries.toArray(new IClasspathEntry[newEntries.size()]);
            javaProject.setRawClasspath(entries, javaProject.getOutputLocation(), monitor);
            IvyClasspathContainer ivycp = IvyClasspathContainerHelper.getContainer((IPath)path, (IJavaProject)javaProject);
            return ivycp;
        }
        catch (JavaModelException e) {
            ProjectUIPlugin.logError("Unable to add Ivy library container", (Exception)((Object)e));
            return null;
        }
    }

    public static void addIvyNature(IProject project, IProgressMonitor monitor) throws CoreException {
        CoreUtil.addNaturesToProject((IProject)project, (String[])new String[]{"org.apache.ivyde.eclipse.ivynature"}, (IProgressMonitor)monitor);
    }

    public static IStatus configureIvyProject(IProject project, IProgressMonitor monitor) throws CoreException {
        IFile ivyXmlFile;
        SDK sdk = SDKUtil.getSDK((IProject)project);
        Version version = new Version(sdk.getVersion());
        if ((CoreUtil.compareVersions((Version)version, (Version)ILiferayConstants.V611) >= 0 && CoreUtil.compareVersions((Version)version, (Version)ILiferayConstants.V6110) < 0 || CoreUtil.compareVersions((Version)version, (Version)ILiferayConstants.V620) >= 0) && (ivyXmlFile = project.getFile("ivy.xml")).exists()) {
            IvyUtil.addIvyNature(project, monitor);
            IvyClasspathContainer ivycp = IvyUtil.addIvyLibrary(project, monitor);
            if (ivycp != null) {
                IStatus status = ivycp.launchResolve(false, monitor);
                if (status.isOK()) {
                    IFolder webinfFolder = CoreUtil.getDefaultDocrootFolder((IProject)project).getFolder("WEB-INF");
                    CoreUtil.validateFolder((IFolder)webinfFolder, (IProgressMonitor)monitor);
                } else {
                    return status;
                }
            }
        }
        return Status.OK_STATUS;
    }
}

