/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui;

import com.liferay.ide.project.core.util.ProjectUtil;
import com.liferay.ide.project.ui.ProjectUIPlugin;
import com.liferay.ide.server.util.ServerUtil;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.internal.dialogs.PropertyDialog;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.server.ui.ServerUIUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimaryRuntimeNotSetResolution
implements IMarkerResolution {
    public static final String TARGETED_RUNTIMES_PROPERTY_PAGE_ID = "org.eclipse.wst.common.project.facet.ui.RuntimesPropertyPage";

    public String getLabel() {
        return Msgs.setPrimaryRuntimeForProject;
    }

    public void run(IMarker marker) {
        if (marker.getResource() instanceof IProject) {
            boolean openRuntimesProperty;
            Set<IRuntime> availableFacetRuntimes;
            String runtimeName;
            boolean setAsPrimary;
            boolean openNewRuntimeWizard;
            IProject proj = (IProject)marker.getResource();
            IFacetedProject fproj = ProjectUtil.getFacetedProject((IProject)proj);
            if (ServerUtil.getAvailableLiferayRuntimes().size() == 0 && (openNewRuntimeWizard = MessageDialog.openQuestion(null, null, (String)Msgs.noLiferayRuntimeAvailable))) {
                ServerUIUtil.showNewRuntimeWizard(null, null, null, (String)"com.liferay.");
            }
            if (ServerUtil.getAvailableLiferayRuntimes().size() == 1 && (setAsPrimary = MessageDialog.openQuestion(null, null, (String)NLS.bind((String)Msgs.setOnlyRuntimeAsPrimary, (Object)(runtimeName = ((IRuntime)(availableFacetRuntimes = this.convertToFacetRuntimes(ServerUtil.getAvailableLiferayRuntimes())).toArray()[0]).getName()))))) {
                try {
                    fproj.setTargetedRuntimes(availableFacetRuntimes, null);
                    fproj.setPrimaryRuntime((IRuntime)availableFacetRuntimes.toArray()[0], null);
                }
                catch (CoreException e) {
                    ProjectUIPlugin.logError((Exception)((Object)e));
                }
            }
            if (ServerUtil.getAvailableLiferayRuntimes().size() > 1 && (openRuntimesProperty = MessageDialog.openQuestion(null, null, (String)Msgs.multipleAvailableRuntimes))) {
                PropertyDialog.createDialogOn(null, (String)TARGETED_RUNTIMES_PROPERTY_PAGE_ID, (Object)proj).open();
            }
        }
    }

    private Set<IRuntime> convertToFacetRuntimes(Set<org.eclipse.wst.server.core.IRuntime> serverRuntimes) {
        HashSet<IRuntime> facetRuntimes = new HashSet<IRuntime>();
        Iterator<org.eclipse.wst.server.core.IRuntime> it = serverRuntimes.iterator();
        while (it.hasNext()) {
            facetRuntimes.add(FacetUtil.getRuntime((org.eclipse.wst.server.core.IRuntime)it.next()));
        }
        return facetRuntimes;
    }

    private static class Msgs
    extends NLS {
        public static String noLiferayRuntimeAvailable;
        public static String setOnlyRuntimeAsPrimary;
        public static String multipleAvailableRuntimes;
        public static String setPrimaryRuntimeForProject;

        static {
            Msgs.initializeMessages((String)PrimaryRuntimeNotSetResolution.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

