/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.wizard;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.BinaryProjectRecord;
import com.liferay.ide.project.core.ISDKProjectsImportDataModelProperties;
import com.liferay.ide.project.core.util.ProjectImportUtil;
import com.liferay.ide.project.ui.wizard.LiferaySDKField;
import com.liferay.ide.sdk.core.ISDKConstants;
import com.liferay.ide.ui.util.SWTUtil;
import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.server.ui.ServerUIUtil;
import org.eclipse.wst.web.ui.internal.wizards.DataModelFacetCreationWizardPage;

public class BinaryProjectImportWizardPage
extends DataModelFacetCreationWizardPage
implements ISDKProjectsImportDataModelProperties {
    protected Text binariesLocation;
    protected long lastModified;
    protected String lastPath;
    protected Text sdkLocation;
    protected Text sdkVersion;
    protected BinaryProjectRecord selectedBinary;
    protected Combo serverTargetCombo;
    protected IProject[] wsProjects;

    public BinaryProjectImportWizardPage(IDataModel model, String pageName) {
        super(model, pageName);
        this.setTitle(Msgs.importLiferayBinaryPlugin);
        this.setDescription(Msgs.selectBinaryPlugin);
    }

    protected void createBinaryLocationField(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Msgs.binaryPluginFile);
        label.setLayoutData((Object)new GridData(32));
        this.binariesLocation = SWTUtil.createSingleText((Composite)parent, (int)1);
        Button browse = SWTUtil.createButton((Composite)parent, (String)Msgs.browse);
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BinaryProjectImportWizardPage.this.doBrowse();
            }
        });
    }

    protected void createPluginsSDKField(Composite parent) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BinaryProjectImportWizardPage.this.synchHelper.synchAllUIWithModel();
                BinaryProjectImportWizardPage.this.validatePage(true);
            }
        };
        new LiferaySDKField(parent, this.getDataModel(), selectionAdapter, "ISDKProjectsImportDataModelProperties.LIFERAY_SDK_NAME", this.synchHelper, Msgs.selectSDKLabel);
    }

    protected void createSDKLocationField(Composite topComposite) {
        SWTUtil.createLabel((Composite)topComposite, (int)16384, (String)Msgs.liferayPluginSDKLocationLabel, (int)1);
        this.sdkLocation = SWTUtil.createText((Composite)topComposite, (int)1);
        ((GridData)this.sdkLocation.getLayoutData()).widthHint = 300;
        this.synchHelper.synchText(this.sdkLocation, "ISDKProjectsImportDataModelProperties.SDK_LOCATION", null);
        SWTUtil.createLabel((Composite)topComposite, (int)16384, (String)"", (int)1);
    }

    protected void createSDKVersionField(Composite topComposite) {
        SWTUtil.createLabel((Composite)topComposite, (int)16384, (String)Msgs.liferayPluginSDKVersionLabel, (int)1);
        this.sdkVersion = SWTUtil.createText((Composite)topComposite, (int)1);
        this.synchHelper.synchText(this.sdkVersion, "ISDKProjectsImportDataModelProperties.SDK_VERSION", null);
        SWTUtil.createLabel((Composite)topComposite, (String)"", (int)1);
    }

    protected void createTargetRuntimeGroup(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Msgs.liferayTargetRuntimeLabel);
        label.setLayoutData((Object)new GridData(32));
        this.serverTargetCombo = new Combo(parent, 2056);
        this.serverTargetCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Button newServerTargetButton = new Button(parent, 0);
        newServerTargetButton.setText(Msgs.newButton);
        newServerTargetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataModelPropertyDescriptor[] preAdditionDescriptors = BinaryProjectImportWizardPage.this.model.getValidPropertyDescriptors("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
                boolean isOK = ServerUIUtil.showNewRuntimeWizard((Shell)BinaryProjectImportWizardPage.this.getShell(), (String)BinaryProjectImportWizardPage.this.getModuleTypeID(), null, (String)"com.liferay.");
                if (isOK) {
                    DataModelPropertyDescriptor[] postAdditionDescriptors = BinaryProjectImportWizardPage.this.model.getValidPropertyDescriptors("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
                    Object[] preAddition = new Object[preAdditionDescriptors.length];
                    int i = 0;
                    while (i < preAddition.length) {
                        preAddition[i] = preAdditionDescriptors[i].getPropertyValue();
                        ++i;
                    }
                    Object[] postAddition = new Object[postAdditionDescriptors.length];
                    int i2 = 0;
                    while (i2 < postAddition.length) {
                        postAddition[i2] = postAdditionDescriptors[i2].getPropertyValue();
                        ++i2;
                    }
                    Object newAddition = CoreUtil.getNewObject((Object[])preAddition, (Object[])postAddition);
                    if (newAddition != null) {
                        BinaryProjectImportWizardPage.this.model.setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", newAddition);
                    }
                }
            }
        });
        Control[] deps = new Control[]{newServerTargetButton};
        this.synchHelper.synchCombo(this.serverTargetCombo, "IFacetProjectCreationDataModelProperties.FACET_RUNTIME", deps);
        if (this.serverTargetCombo.getSelectionIndex() == -1 && this.serverTargetCombo.getVisibleItemCount() != 0) {
            this.serverTargetCombo.select(0);
        }
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite topComposite = SWTUtil.createTopComposite((Composite)parent, (int)3);
        GridLayout gl = new GridLayout(3, false);
        topComposite.setLayout((Layout)gl);
        topComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.createBinaryLocationField(topComposite);
        this.createPluginsSDKField(topComposite);
        SWTUtil.createVerticalSpacer((Composite)topComposite, (int)1, (int)3);
        this.createSDKLocationField(topComposite);
        this.createSDKVersionField(topComposite);
        SWTUtil.createVerticalSpacer((Composite)topComposite, (int)1, (int)3);
        this.createTargetRuntimeGroup(topComposite);
        return topComposite;
    }

    protected void doBrowse() {
        String binaryfile;
        FileDialog fd = new FileDialog(this.getShell(), 4096);
        fd.setFilterExtensions(ISDKConstants.BINARY_PLUGIN_EXTENSIONS);
        String filterPath = this.binariesLocation.getText();
        if (filterPath != null) {
            fd.setFilterPath(filterPath);
            fd.setText(NLS.bind((String)Msgs.selectLiferayPluginBinaryFolderPath, (Object)filterPath));
        } else {
            fd.setText(Msgs.selectLiferayPluginBinaryFolder);
        }
        if (CoreUtil.isNullOrEmpty((String)this.binariesLocation.getText())) {
            fd.setFilterPath(this.binariesLocation.getText());
        }
        if (!CoreUtil.isNullOrEmpty((String)(binaryfile = fd.open()))) {
            this.binariesLocation.setText(binaryfile);
            File binaryFile = new File(binaryfile);
            if (ProjectImportUtil.isValidLiferayPlugin((File)binaryFile)) {
                this.selectedBinary = new BinaryProjectRecord(new File(binaryfile));
                this.getDataModel().setProperty("ISDKProjectsImportDataModelProperties.SELECTED_PROJECTS", (Object)new Object[]{this.selectedBinary});
            } else {
                this.setErrorMessage(Msgs.selectValidLiferayPluginBinary);
            }
        }
    }

    protected IProject[] getProjectsInWorkspace() {
        if (this.wsProjects == null) {
            this.wsProjects = IDEWorkbenchPlugin.getPluginWorkspace().getRoot().getProjects();
        }
        return this.wsProjects;
    }

    protected String[] getValidationPropertyNames() {
        return new String[]{"ISDKProjectsImportDataModelProperties.SDK_LOCATION", "ISDKProjectsImportDataModelProperties.SDK_VERSION", "ISDKProjectsImportDataModelProperties.SELECTED_PROJECTS", "IFacetProjectCreationDataModelProperties.FACET_RUNTIME"};
    }

    protected void handleFileBrowseButton(Text text) {
        String dir;
        DirectoryDialog dd = new DirectoryDialog(this.getShell(), 4096);
        dd.setText(Msgs.selectLiferayPluginSDKFolder);
        if (!CoreUtil.isNullOrEmpty((String)this.sdkLocation.getText())) {
            dd.setFilterPath(this.sdkLocation.getText());
        }
        if (!CoreUtil.isNullOrEmpty((String)(dir = dd.open()))) {
            this.sdkLocation.setText(dir);
            this.synchHelper.synchAllUIWithModel();
            this.validatePage();
        }
    }

    protected boolean isProjectInWorkspace(String projectName) {
        if (projectName == null) {
            return false;
        }
        IProject[] workspaceProjects = this.getProjectsInWorkspace();
        int i = 0;
        while (i < workspaceProjects.length) {
            if (projectName.equals(workspaceProjects[i].getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean showValidationErrorsOnEnter() {
        return true;
    }

    private static class Msgs
    extends NLS {
        public static String binaryPluginFile;
        public static String browse;
        public static String importLiferayBinaryPlugin;
        public static String liferayPluginSDKLocationLabel;
        public static String liferayPluginSDKVersionLabel;
        public static String liferayTargetRuntimeLabel;
        public static String newButton;
        public static String selectBinaryPlugin;
        public static String selectLiferayPluginBinaryFolder;
        public static String selectLiferayPluginBinaryFolderPath;
        public static String selectLiferayPluginSDKFolder;
        public static String selectSDKLabel;
        public static String selectValidLiferayPluginBinary;

        static {
            Msgs.initializeMessages((String)BinaryProjectImportWizardPage.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

