/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.wizard;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.LiferayProjectCore;
import com.liferay.ide.project.core.model.NewLiferayPluginProjectOp;
import com.liferay.ide.project.ui.IvyUtil;
import org.eclipse.ant.internal.ui.model.AntProjectNode;
import org.eclipse.ant.internal.ui.model.AntProjectNodeProxy;
import org.eclipse.ant.internal.ui.views.AntView;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.forms.swt.SapphireWizard;
import org.eclipse.sapphire.ui.forms.swt.SapphireWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.eclipse.wst.web.internal.DelegateConfigurationElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewLiferayPluginProjectWizard
extends SapphireWizard<NewLiferayPluginProjectOp>
implements IWorkbenchWizard,
INewWizard {
    private boolean firstErrorMessageRemoved = false;

    public NewLiferayPluginProjectWizard() {
        super((Element)NewLiferayPluginProjectWizard.createDefaultOp(), DefinitionLoader.sdef(NewLiferayPluginProjectWizard.class).wizard());
    }

    private void addToWorkingSets(IProject newProject) {
    }

    public IWizardPage[] getPages() {
        IWizardPage[] wizardPages = super.getPages();
        if (!this.firstErrorMessageRemoved && wizardPages != null) {
            SapphireWizardPage wizardPage = (SapphireWizardPage)wizardPages[0];
            String message = wizardPage.getMessage();
            int messageType = wizardPage.getMessageType();
            if (messageType == 3 && !CoreUtil.isNullOrEmpty((String)message)) {
                wizardPage.setMessage("Please enter a project name.", 0);
                this.firstErrorMessageRemoved = true;
            }
        }
        return wizardPages;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    private void openLiferayPerspective(IProject newProject) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        DelegateConfigurationElement element = new DelegateConfigurationElement(null){

            public String getAttribute(String aName) {
                if (aName.equals("finalPerspective")) {
                    return "com.liferay.ide.eclipse.ui.perspective.liferay";
                }
                return super.getAttribute(aName);
            }
        };
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)element);
        BasicNewResourceWizard.selectAndReveal((IResource)newProject, (IWorkbenchWindow)workbench.getActiveWorkbenchWindow());
    }

    protected void performPostFinish() {
        super.performPostFinish();
        NewLiferayPluginProjectOp op = (NewLiferayPluginProjectOp)((NewLiferayPluginProjectOp)this.element()).nearest(NewLiferayPluginProjectOp.class);
        final IProject project = CoreUtil.getProject((String)((String)op.getFinalProjectName().content()));
        this.addToWorkingSets(project);
        this.openLiferayPerspective(project);
        this.showInAntView(project);
        if (project != null && project.getFile("ivy.xml").exists()) {
            new WorkspaceJob("Configuring project with Ivy dependencies"){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    try {
                        IvyUtil.configureIvyProject(project, monitor);
                    }
                    catch (CoreException e) {
                        return LiferayProjectCore.createErrorStatus((String)"com.liferay.ide.project.core", (String)"Failed to configured ivy project.", (Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    private void showInAntView(final IProject project) {
        Display.getDefault().asyncExec(new Runnable(){

            private void addBuildInAntView() {
                IFile buildXmlFile;
                if (project != null && (buildXmlFile = project.getFile("build.xml")).exists()) {
                    String buildFileName = buildXmlFile.getFullPath().toString();
                    AntProjectNodeProxy antProject = new AntProjectNodeProxy(buildFileName);
                    project.getName();
                    IViewPart antView = PlatformUI.getWorkbench().getWorkbenchWindows()[0].getActivePage().findView("org.eclipse.ant.ui.views.AntView");
                    if (antView instanceof AntView) {
                        ((AntView)antView).addProject((AntProjectNode)antProject);
                    }
                }
            }

            private void refreshProjectExplorer() {
                IViewPart view = null;
                try {
                    view = PlatformUI.getWorkbench().getWorkbenchWindows()[0].getActivePage().findView("org.eclipse.ui.navigator.ProjectExplorer");
                }
                catch (Exception exception) {}
                if (view == null) {
                    return;
                }
                CommonViewer viewer = (CommonViewer)view.getAdapter(CommonViewer.class);
                viewer.refresh(true);
            }

            public void run() {
                this.refreshProjectExplorer();
                this.addBuildInAntView();
            }
        });
    }

    private static NewLiferayPluginProjectOp createDefaultOp() {
        return (NewLiferayPluginProjectOp)NewLiferayPluginProjectOp.TYPE.instantiate();
    }
}

