/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.wizard;

import com.liferay.ide.project.core.util.ProjectUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPage;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPageExtension;
import org.eclipse.jdt.ui.wizards.NewElementWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class PluginClasspathContainerPage
extends NewElementWizardPage
implements IClasspathContainerPage,
IClasspathContainerPageExtension {
    private IProject ownerProject;
    private String type;
    private Combo typeCombo;

    public PluginClasspathContainerPage() {
        super("PluginClasspathContainerPage");
        this.setTitle(Msgs.liferayPluginAPILibrary);
        this.setDescription(Msgs.containerManagesClasspathEntries);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(composite, 0);
        label.setText(Msgs.liferayPluginTypeLabel);
        String[] types = new String[]{"portlet", "hook", "ext", "theme"};
        this.typeCombo = new Combo(composite, 8);
        this.typeCombo.setItems(types);
        int index = this.type != null ? PluginClasspathContainerPage.indexOf(types, this.type) : (ProjectUtil.isPortletProject((IProject)this.ownerProject) ? 0 : (ProjectUtil.isHookProject((IProject)this.ownerProject) ? 1 : (ProjectUtil.isExtProject((IProject)this.ownerProject) ? 2 : (ProjectUtil.isThemeProject((IProject)this.ownerProject) ? 3 : -1))));
        if (index != -1) {
            this.typeCombo.select(index);
        }
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.minimumWidth = 100;
        this.typeCombo.setLayoutData((Object)gd);
        this.setControl((Control)composite);
    }

    public boolean finish() {
        if (this.ownerProject != null && ProjectUtil.isLiferayFacetedProject((IProject)this.ownerProject)) {
            return true;
        }
        this.setErrorMessage(Msgs.selectedProjectNotLiferayProject);
        return false;
    }

    public IClasspathEntry getSelection() {
        Path path = new Path("com.liferay.ide.eclipse.server.plugin.container/");
        int index = this.typeCombo.getSelectionIndex();
        if (index != -1) {
            String type = this.typeCombo.getItem(index);
            path = path.append(type);
        }
        return JavaCore.newContainerEntry((IPath)path);
    }

    public void initialize(IJavaProject project, IClasspathEntry[] currentEntries) {
        this.ownerProject = project == null ? null : project.getProject();
    }

    public void setSelection(IClasspathEntry entry) {
        IPath path;
        IPath iPath = path = entry == null ? null : entry.getPath();
        if (path != null && path.segmentCount() == 2) {
            this.type = path.segment(1);
        }
    }

    private static int indexOf(String[] array, String str) {
        int i = 0;
        while (i < array.length) {
            if (array[i].equals(str)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static class Msgs
    extends NLS {
        public static String containerManagesClasspathEntries;
        public static String liferayPluginAPILibrary;
        public static String liferayPluginTypeLabel;
        public static String selectedProjectNotLiferayProject;

        static {
            Msgs.initializeMessages((String)PluginClasspathContainerPage.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

