/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.portlet.core.descriptor;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.core.util.DescriptorHelper;
import com.liferay.ide.core.util.NodeUtil;
import com.liferay.ide.portlet.core.PortletCore;
import com.liferay.ide.project.core.BaseValidator;
import com.liferay.ide.project.core.LiferayProjectCore;
import com.liferay.ide.project.core.util.ProjectUtil;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.ValidatorMessage;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiferayPortletDescriptorValidator
extends BaseValidator {
    public static final String CONTROL_PANEL_ENTRY_CLASS_ELEMENT = "control-panel-entry-class";
    public static final String CONTROL_PANEL_ENTRY_WEIGHT_ELEMENT = "control-panel-entry-weight";
    public static final String FOOTER_PORTAL_CSS_ELEMENT = "footer-portal-css";
    public static final String FOOTER_PORTAL_JAVASCRIPT_ELEMENT = "footer-portal-javascript";
    public static final String FOOTER_PORTLET_CSS_ELEMENT = "footer-portlet-css";
    public static final String FOOTER_PORTLET_JAVASCRIPT_ELEMENT = "footer-portlet-javascript";
    public static final String HEADER_PORTAL_CSS_ELEMENT = "header-portal-css";
    public static final String HEADER_PORTAL_JAVASCRIPT_ELEMENT = "header-portal-javascript";
    public static final String HEADER_PORTLET_CSS_ELEMENT = "header-portlet-css";
    public static final String HEADER_PORTLET_JAVASCRIPT_ELEMENT = "header-portlet-javascript";
    public static final String ICON_ELEMENT = "icon";
    public static final String MARKER_TYPE = "com.liferay.ide.portlet.core.liferayPortletDescriptorMarker";
    public static final String MESSAGE_ENTRY_WEIGHT_NOT_VALID = Msgs.specifyValidDouble;
    public static final String MESSAGE_FOOTER_PORTAL_CSS_NOT_FOUND = Msgs.footerPortalCssNotFound;
    public static final String MESSAGE_FOOTER_PORTAL_JAVASCRIPT_NOT_FOUND = Msgs.footerPortalJavascriptNotFound;
    public static final String MESSAGE_FOOTER_PORTLET_CSS_NOT_FOUND = Msgs.footerPortletCssNotFound;
    public static final String MESSAGE_FOOTER_PORTLET_JAVASCRIPT_NOT_FOUND = Msgs.footerPortletJavascriptNotFound;
    public static final String MESSAGE_HEADER_PORTAL_CSS_NOT_FOUND = Msgs.headerPortalCssNotFound;
    public static final String MESSAGE_HEADER_PORTAL_JAVASCRIPT_NOT_FOUND = Msgs.headerPortalJavascriptNotFound;
    public static final String MESSAGE_HEADER_PORTLET_CSS_NOT_FOUND = Msgs.headerPortletCssNotFound;
    public static final String MESSAGE_HEADER_PORTLET_JAVASCRIPT_NOT_FOUND = Msgs.headerPortletJavascriptNotFound;
    public static final String MESSAGE_ICON_NOT_FOUND = Msgs.iconNotFound;
    public static final String MESSAGE_PORTLET_NAME_NOT_FOUND = Msgs.portletNameNotFound;
    public static final String PORTLET_NAME_ELEMENT = "portlet-name";
    public static final String PREFERENCE_NODE_QUALIFIER = LiferayProjectCore.getDefault().getBundle().getSymbolicName();

    protected void checkControlPanelEntryWeightElements(IDOMDocument liferayPortletXmlDocument, IScopeContext[] preferenceScopes, String validationKey, String errorMessage, List<Map<String, Object>> problems) {
        NodeList elements = liferayPortletXmlDocument.getElementsByTagName(CONTROL_PANEL_ENTRY_WEIGHT_ELEMENT);
        int i = 0;
        while (i < elements.getLength()) {
            Map problem;
            Node item = elements.item(i);
            String entryWeight = NodeUtil.getTextContent((Node)item);
            if (!CoreUtil.isNumeric((String)entryWeight) && (problem = this.createMarkerValues(PREFERENCE_NODE_QUALIFIER, preferenceScopes, validationKey, (IDOMNode)item, MESSAGE_ENTRY_WEIGHT_NOT_VALID)) != null) {
                problems.add(problem);
            }
            ++i;
        }
    }

    protected void checkDocrootElements(IDOMDocument document, IProject project, IScopeContext[] preferenceScopes, List<Map<String, Object>> problems) {
        this.checkDocrootElement(document, ICON_ELEMENT, project, PREFERENCE_NODE_QUALIFIER, preferenceScopes, "validation-liferay-portlet-xml-icon-not-found", MESSAGE_ICON_NOT_FOUND, problems);
        this.checkDocrootElement(document, HEADER_PORTAL_CSS_ELEMENT, project, PREFERENCE_NODE_QUALIFIER, preferenceScopes, "validation-liferay-portlet-xml-header-portal-css-not-found", MESSAGE_HEADER_PORTAL_CSS_NOT_FOUND, problems);
        this.checkDocrootElement(document, HEADER_PORTLET_CSS_ELEMENT, project, PREFERENCE_NODE_QUALIFIER, preferenceScopes, "validation-liferay-portlet-xml-header-portlet-css-not-found", MESSAGE_HEADER_PORTLET_CSS_NOT_FOUND, problems);
        this.checkDocrootElement(document, HEADER_PORTAL_JAVASCRIPT_ELEMENT, project, PREFERENCE_NODE_QUALIFIER, preferenceScopes, "validation-liferay-portlet-xml-header-portal-javascript-not-found", MESSAGE_HEADER_PORTAL_JAVASCRIPT_NOT_FOUND, problems);
        this.checkDocrootElement(document, HEADER_PORTLET_JAVASCRIPT_ELEMENT, project, PREFERENCE_NODE_QUALIFIER, preferenceScopes, "validation-liferay-portlet-xml-header-portlet-javascript-not-found", MESSAGE_HEADER_PORTLET_JAVASCRIPT_NOT_FOUND, problems);
        this.checkDocrootElement(document, FOOTER_PORTAL_CSS_ELEMENT, project, PREFERENCE_NODE_QUALIFIER, preferenceScopes, "validation-liferay-portlet-xml-footer-portal-css-not-found", MESSAGE_FOOTER_PORTAL_CSS_NOT_FOUND, problems);
        this.checkDocrootElement(document, FOOTER_PORTLET_CSS_ELEMENT, project, PREFERENCE_NODE_QUALIFIER, preferenceScopes, "validation-liferay-portlet-xml-footer-portlet-css-not-found", MESSAGE_FOOTER_PORTLET_CSS_NOT_FOUND, problems);
        this.checkDocrootElement(document, FOOTER_PORTAL_JAVASCRIPT_ELEMENT, project, PREFERENCE_NODE_QUALIFIER, preferenceScopes, "validation-liferay-portlet-xml-footer-portal-javascript-not-found", MESSAGE_FOOTER_PORTAL_JAVASCRIPT_NOT_FOUND, problems);
        this.checkDocrootElement(document, FOOTER_PORTLET_JAVASCRIPT_ELEMENT, project, PREFERENCE_NODE_QUALIFIER, preferenceScopes, "validation-liferay-portlet-xml-footer-portlet-javascript-not-found", MESSAGE_FOOTER_PORTLET_JAVASCRIPT_NOT_FOUND, problems);
    }

    protected void checkPortletName(IDOMDocument portletXmlDocument, Node liferayPortletNameNode, IScopeContext[] preferenceScopes, String validationKey, String errorMessage, List<Map<String, Object>> problems) {
        String msg;
        Map problem;
        NodeList elements = portletXmlDocument.getElementsByTagName(PORTLET_NAME_ELEMENT);
        String liferayPortletName = NodeUtil.getTextContent((Node)liferayPortletNameNode);
        boolean portletNameFound = false;
        int i = 0;
        while (i < elements.getLength()) {
            Node item = elements.item(i);
            String portletName = NodeUtil.getTextContent((Node)item);
            if (CoreUtil.isEqual((Object)portletName, (Object)liferayPortletName)) {
                portletNameFound = true;
                break;
            }
            ++i;
        }
        if (!portletNameFound && (problem = this.createMarkerValues(PREFERENCE_NODE_QUALIFIER, preferenceScopes, validationKey, (IDOMNode)liferayPortletNameNode, msg = MessageFormat.format(errorMessage, liferayPortletName))) != null) {
            problems.add(problem);
        }
    }

    protected void checkPortletNameElements(IDOMDocument liferayPortletXmlDocument, IDOMDocument portletXmlDocument, IScopeContext[] preferenceScopes, List<Map<String, Object>> problems) {
        NodeList elements = liferayPortletXmlDocument.getElementsByTagName(PORTLET_NAME_ELEMENT);
        int i = 0;
        while (i < elements.getLength()) {
            Node liferayPortletNameElement = elements.item(i);
            this.checkPortletName(portletXmlDocument, liferayPortletNameElement, preferenceScopes, "validation-liferay-portlet-xml-portlet-name-not-found", MESSAGE_PORTLET_NAME_NOT_FOUND, problems);
            ++i;
        }
    }

    protected Map<String, Object>[] detectProblems(IJavaProject javaProject, IFile liferayPortletXml, IFile portletXml, IScopeContext[] preferenceScopes) throws CoreException {
        ArrayList<Map<String, Object>> problems;
        block13: {
            problems = new ArrayList<Map<String, Object>>();
            IStructuredModel liferayPortletXmlModel = null;
            IStructuredModel portletXmlModel = null;
            IDOMDocument liferayPortletXmlDocument = null;
            try {
                try {
                    liferayPortletXmlModel = StructuredModelManager.getModelManager().getModelForRead(liferayPortletXml);
                    if (liferayPortletXmlModel != null && liferayPortletXmlModel instanceof IDOMModel) {
                        liferayPortletXmlDocument = ((IDOMModel)liferayPortletXmlModel).getDocument();
                        this.checkDocrootElements(liferayPortletXmlDocument, liferayPortletXml.getProject(), preferenceScopes, problems);
                        this.checkAllClassElements(this.getAllClasseElements("LiferayPortletClassElements.properties"), javaProject, liferayPortletXml, "validation-liferay-portlet-xml-class-not-found", "validation-liferay-portlet-xml-incorrect-class-hierarchy", preferenceScopes, PREFERENCE_NODE_QUALIFIER, problems);
                        this.checkControlPanelEntryWeightElements(liferayPortletXmlDocument, preferenceScopes, "validation-liferay-portlet-xml-entry-weight-not-valid", MESSAGE_ENTRY_WEIGHT_NOT_VALID, problems);
                    }
                    if (portletXml != null && portletXml.exists() && (portletXmlModel = StructuredModelManager.getModelManager().getModelForRead(portletXml)) instanceof IDOMModel) {
                        IDOMDocument portletXmlDocument = ((IDOMModel)portletXmlModel).getDocument();
                        this.checkPortletNameElements(liferayPortletXmlDocument, portletXmlDocument, preferenceScopes, problems);
                    }
                }
                catch (IOException e) {
                    PortletCore.logError(e);
                    if (liferayPortletXmlModel != null) {
                        liferayPortletXmlModel.releaseFromRead();
                    }
                    if (portletXmlModel != null) {
                        portletXmlModel.releaseFromRead();
                    }
                    break block13;
                }
            }
            catch (Throwable throwable) {
                if (liferayPortletXmlModel != null) {
                    liferayPortletXmlModel.releaseFromRead();
                }
                if (portletXmlModel != null) {
                    portletXmlModel.releaseFromRead();
                }
                throw throwable;
            }
            if (liferayPortletXmlModel != null) {
                liferayPortletXmlModel.releaseFromRead();
            }
            if (portletXmlModel != null) {
                portletXmlModel.releaseFromRead();
            }
        }
        Map[] retval = new Map[problems.size()];
        return problems.toArray(retval);
    }

    public ValidationResult validate(IResource resource, int kind, ValidationState state, IProgressMonitor monitor) {
        if (resource.getType() != 1) {
            return null;
        }
        ValidationResult result = new ValidationResult();
        IFile liferayPortletXml = (IFile)resource;
        IFile portletXml = DescriptorHelper.getDescriptorFile((IProject)liferayPortletXml.getProject(), (String)"portlet.xml");
        if (liferayPortletXml.isAccessible() && portletXml != null && portletXml.isAccessible() && ProjectUtil.isPortletProject((IProject)resource.getProject())) {
            IJavaProject javaProject = JavaCore.create((IProject)portletXml.getProject());
            IScopeContext[] scopes = new IScopeContext[]{new InstanceScope(), new DefaultScope()};
            ProjectScope projectScope = new ProjectScope(liferayPortletXml.getProject());
            boolean useProjectSettings = projectScope.getNode(PREFERENCE_NODE_QUALIFIER).getBoolean("use-project-settings", false);
            if (useProjectSettings) {
                scopes = new IScopeContext[]{projectScope, new InstanceScope(), new DefaultScope()};
            }
            try {
                Map<String, Object>[] problems = this.detectProblems(javaProject, liferayPortletXml, portletXml, scopes);
                int i = 0;
                while (i < problems.length) {
                    ValidatorMessage message = ValidatorMessage.create((String)problems[i].get("message").toString(), (IResource)resource);
                    message.setType(MARKER_TYPE);
                    message.setAttributes(problems[i]);
                    result.add(message);
                    ++i;
                }
                if (problems.length > 0) {
                    result.setDependsOn(new IResource[]{portletXml});
                }
            }
            catch (Exception e) {
                PortletCore.logError(e);
            }
        }
        return result;
    }

    private static class Msgs
    extends NLS {
        public static String footerPortalCssNotFound;
        public static String footerPortalJavascriptNotFound;
        public static String footerPortletCssNotFound;
        public static String footerPortletJavascriptNotFound;
        public static String headerPortalCssNotFound;
        public static String headerPortalJavascriptNotFound;
        public static String headerPortletCssNotFound;
        public static String headerPortletJavascriptNotFound;
        public static String iconNotFound;
        public static String portletNameNotFound;
        public static String specifyValidDouble;

        static {
            Msgs.initializeMessages((String)LiferayPortletDescriptorValidator.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

