/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.portlet.core.descriptor;

import com.liferay.ide.core.util.NodeUtil;
import com.liferay.ide.portlet.core.PortletCore;
import com.liferay.ide.project.core.BaseValidator;
import com.liferay.ide.project.core.LiferayProjectCore;
import com.liferay.ide.project.core.util.ProjectUtil;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.ValidatorMessage;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletDescriptorValidator
extends BaseValidator {
    public static final String FILTER_CLASS_ELEMENT = "filter-class";
    public static final String LISTENER_CLASS_ELEMENT = "listener-class";
    public static final String MARKER_TYPE = "com.liferay.ide.portlet.core.portletDescriptorMarker";
    public static final String MESSAGE_RESOURCE_BUNDLE_NOT_FOUND = Msgs.resourceBundleNotFound;
    public static final String PORTLET_CLASS_ELEMENT = "portlet-class";
    public static final String PORTLET_ELEMENT = "portlet";
    public static final String PREFERENCE_NODE_QUALIFIER = LiferayProjectCore.getDefault().getBundle().getSymbolicName();
    public static final String RESOURCE_BUNDLE_ELEMENT = "resource-bundle";
    public static final String SUPPORTED_LOCALE_ELEMENT = "supported-locale";

    protected void checkResourceBundleElements(IDOMDocument document, IJavaProject javaProject, IScopeContext[] preferenceScopes, List<Map<String, Object>> problems) {
        NodeList resourceBundles = document.getElementsByTagName(RESOURCE_BUNDLE_ELEMENT);
        int i = 0;
        while (i < resourceBundles.getLength()) {
            Node item = resourceBundles.item(i);
            Map problem = this.checkClassResource(javaProject, item, PREFERENCE_NODE_QUALIFIER, preferenceScopes, "validation-portlet-xml-resource-bundle-not-found", MESSAGE_RESOURCE_BUNDLE_NOT_FOUND, true);
            if (problem != null) {
                problems.add(problem);
            }
            ++i;
        }
    }

    protected void checkResourceBundleAndSupportedLocaleEncoding(IDOMDocument document, IJavaProject javaProject, String preferenceNodeQualifier, IScopeContext[] preferenceScopes, String resouceBundleEncodingPreferenceKey, String supportedLocaleEncodingPreferenceKey, List<Map<String, Object>> problems) {
        NodeList portlets = document.getElementsByTagName(PORTLET_ELEMENT);
        NodeList allResourceBundles = document.getElementsByTagName(RESOURCE_BUNDLE_ELEMENT);
        NodeList allSupportedLocales = document.getElementsByTagName(SUPPORTED_LOCALE_ELEMENT);
        if (allResourceBundles.getLength() == 0) {
            return;
        }
        if (portlets != null && portlets.getLength() > 0) {
            int i = 0;
            while (i < portlets.getLength()) {
                Node portlet = portlets.item(i);
                Node resourceBundle = null;
                HashSet<Node> supportedLocales = new HashSet<Node>();
                if (allResourceBundles.getLength() > 0) {
                    int j = 0;
                    while (j < allResourceBundles.getLength()) {
                        if (allResourceBundles.item(j).getParentNode().equals(portlet)) {
                            resourceBundle = allResourceBundles.item(j);
                        }
                        ++j;
                    }
                    if (allSupportedLocales.getLength() > 0) {
                        int k = 0;
                        while (k < allSupportedLocales.getLength()) {
                            if (allSupportedLocales.item(k).getParentNode().equals(portlet)) {
                                supportedLocales.add(allSupportedLocales.item(k));
                            }
                            ++k;
                        }
                    }
                    try {
                        IClasspathEntry[] classpathEntrys;
                        IWorkspaceRoot workspaceRoot = javaProject.getJavaModel().getWorkspace().getRoot();
                        IClasspathEntry[] iClasspathEntryArray = classpathEntrys = javaProject.getResolvedClasspath(true);
                        int n = classpathEntrys.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IClasspathEntry entry = iClasspathEntryArray[n2];
                            if (entry.getEntryKind() == 3) {
                                String resourceBundleVal = NodeUtil.getTextContent((Node)resourceBundle);
                                IFile resourceBundleFile = workspaceRoot.getFile(entry.getPath().append(String.valueOf(resourceBundleVal.replaceAll("\\.", "/")) + ".properties"));
                                if (resourceBundleFile.exists() && !"UTF-8".equals(resourceBundleFile.getCharset())) {
                                    String msg = MessageFormat.format(Msgs.resourceBundleEncodingNotDefault, resourceBundleFile.getName());
                                    problems.add(this.createMarkerValues(preferenceNodeQualifier, preferenceScopes, resouceBundleEncodingPreferenceKey, (IDOMNode)resourceBundle, msg));
                                }
                                if (supportedLocales.size() > 0) {
                                    for (Node supportedLocale : supportedLocales) {
                                        String supportedLocaleVal = NodeUtil.getTextContent((Node)supportedLocale);
                                        IFile supportedLocaleFile = workspaceRoot.getFile(entry.getPath().append(String.valueOf(resourceBundleVal.replaceAll("\\.", "/")) + "_" + supportedLocaleVal + ".properties"));
                                        if (!supportedLocaleFile.exists() || supportedLocaleFile.getCharset().equals("UTF-8")) continue;
                                        String msg = MessageFormat.format(Msgs.supportedLocaleEncodingNotDefault, supportedLocaleFile.getName());
                                        problems.add(this.createMarkerValues(preferenceNodeQualifier, preferenceScopes, supportedLocaleEncodingPreferenceKey, (IDOMNode)supportedLocale, msg));
                                    }
                                }
                            }
                            ++n2;
                        }
                    }
                    catch (Exception e) {
                        PortletCore.logError(e);
                    }
                }
                ++i;
            }
        }
    }

    protected Map<String, Object>[] detectProblems(IJavaProject javaProject, IFile portletXml, IScopeContext[] preferenceScopes) throws CoreException {
        ArrayList<Map<String, Object>> problems;
        block9: {
            problems = new ArrayList<Map<String, Object>>();
            IStructuredModel model = null;
            try {
                try {
                    model = StructuredModelManager.getModelManager().getModelForRead(portletXml);
                    if (model instanceof IDOMModel) {
                        IDOMDocument document = ((IDOMModel)model).getDocument();
                        this.checkAllClassElements(this.getAllClasseElements("PortletClassElements.properties"), javaProject, portletXml, "validation-portlet-xml-class-not-found", "validation-portlet-xml-incorrect-class-hierarchy", preferenceScopes, PREFERENCE_NODE_QUALIFIER, problems);
                        this.checkResourceBundleElements(document, javaProject, preferenceScopes, problems);
                        this.checkResourceBundleAndSupportedLocaleEncoding(document, javaProject, PREFERENCE_NODE_QUALIFIER, preferenceScopes, "validation-portlet-xml-resource-bundle-encoding-not-default", "validation-portlet-xml-supported-locale-encoding-not-default", problems);
                    }
                }
                catch (IOException e) {
                    PortletCore.logError(e);
                    if (model != null) {
                        model.releaseFromRead();
                    }
                    break block9;
                }
            }
            catch (Throwable throwable) {
                if (model != null) {
                    model.releaseFromRead();
                }
                throw throwable;
            }
            if (model != null) {
                model.releaseFromRead();
            }
        }
        Map[] retval = new Map[problems.size()];
        return problems.toArray(retval);
    }

    public ValidationResult validate(IResource resource, int kind, ValidationState state, IProgressMonitor monitor) {
        IJavaProject javaProject;
        if (resource.getType() != 1) {
            return null;
        }
        ValidationResult result = new ValidationResult();
        IFile portletXml = (IFile)resource;
        if (portletXml.isAccessible() && ProjectUtil.isPortletProject((IProject)resource.getProject()) && (javaProject = JavaCore.create((IProject)portletXml.getProject())).exists()) {
            IScopeContext[] scopes = new IScopeContext[]{new InstanceScope(), new DefaultScope()};
            ProjectScope projectScope = new ProjectScope(portletXml.getProject());
            boolean useProjectSettings = projectScope.getNode(PREFERENCE_NODE_QUALIFIER).getBoolean("use-project-settings", false);
            if (useProjectSettings) {
                scopes = new IScopeContext[]{projectScope, new InstanceScope(), new DefaultScope()};
            }
            try {
                Map<String, Object>[] problems = this.detectProblems(javaProject, portletXml, scopes);
                int i = 0;
                while (i < problems.length) {
                    ValidatorMessage message = ValidatorMessage.create((String)problems[i].get("message").toString(), (IResource)resource);
                    message.setType(MARKER_TYPE);
                    message.setAttributes(problems[i]);
                    result.add(message);
                    ++i;
                }
            }
            catch (Exception e) {
                PortletCore.logError(e);
            }
        }
        return result;
    }

    private static class Msgs
    extends NLS {
        public static String resourceBundleNotFound;
        public static String resourceBundleEncodingNotDefault;
        public static String supportedLocaleEncodingNotDefault;

        static {
            Msgs.initializeMessages((String)PortletDescriptorValidator.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

