/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.portlet.core.util;

import com.liferay.ide.portlet.core.util.PortletUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PortletModelUtil {
    public static void printDocument(Document doc, OutputStream out) throws IOException, TransformerException {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.transform(new DOMSource(doc), new StreamResult(new OutputStreamWriter(out, "UTF-8")));
    }

    public static String defineNS(XmlElement element, QName currValueAsQName) {
        String name;
        String qualifiedNodeValue = null;
        String namespaceURI = currValueAsQName.getNamespaceURI();
        String defaultPrefix = "x";
        Element domNode = element.getDomNode();
        boolean nsDefined = false;
        String currNodeValue = element.getText();
        Attr attrib = null;
        if (currNodeValue != null && currNodeValue.indexOf(":") != -1 && (attrib = domNode.getAttributeNode(String.format("xmlns:%s", name = PortletUtil.stripSuffix(currNodeValue)))) != null) {
            String nsURI = attrib.getValue();
            if (namespaceURI.equals(nsURI)) {
                nsDefined = true;
                defaultPrefix = name;
            } else {
                attrib.setNodeValue(namespaceURI);
                return element.getText();
            }
        }
        if (nsDefined && attrib != null) {
            domNode.removeAttributeNode(attrib);
        }
        String qualifiedName = String.format("xmlns:%s", defaultPrefix);
        Attr attr = domNode.getAttributeNodeNS(namespaceURI, defaultPrefix);
        if (attr == null) {
            domNode.setAttributeNS(namespaceURI, qualifiedName, namespaceURI);
        }
        qualifiedNodeValue = String.valueOf(defaultPrefix) + ":" + currValueAsQName.getLocalPart();
        return qualifiedNodeValue;
    }
}

