/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.alloy.core;

import com.liferay.ide.alloy.core.AlloyCore;
import com.liferay.ide.core.util.LaunchHelper;
import com.liferay.ide.core.util.ZipUtil;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import java.io.File;
import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.osgi.framework.Bundle;

public class LautRunner {
    private static final String LAUT_ENTRY = "/laut";
    private static final String LAUT_PATH = "com.liferay.laut.LautRunnerPath";
    private static final String LAUT_ZIP = "/laut.zip";
    private static final String[] lautExeFiles = new String[]{"run.sh", "node/bin/node"};
    private static CLibrary libc = null;

    static {
        LautRunner.initializeLautRunner();
    }

    private static CLibrary getLibC() {
        if (libc == null && !Platform.isWindows()) {
            try {
                libc = (CLibrary)Native.loadLibrary((String)"c", CLibrary.class);
            }
            catch (Exception e) {
                AlloyCore.logError(e);
            }
        }
        return libc;
    }

    private static void initializeLautRunner() {
        File lautRunnerFile;
        String lautRunnerPath = System.getProperty(LAUT_PATH);
        if (lautRunnerPath != null && !(lautRunnerFile = new File(lautRunnerPath)).exists()) {
            lautRunnerPath = null;
        }
        if (lautRunnerPath == null) {
            String LAUT_RUNNER_BUNDLE = new StringBuffer("com.liferay.laut").append(".").append(org.eclipse.core.runtime.Platform.getOS()).append(".").append(org.eclipse.core.runtime.Platform.getWS()).append(".").append(org.eclipse.core.runtime.Platform.getOSArch()).toString();
            Bundle lautRunnerBundle = org.eclipse.core.runtime.Platform.getBundle((String)LAUT_RUNNER_BUNDLE);
            if (lautRunnerBundle == null) {
                AlloyCore.logError("Unable to find laut bundle.");
            } else {
                URL lautZipUrl;
                URL lautUrl = lautRunnerBundle.getEntry(LAUT_PATH);
                if (lautUrl == null && (lautZipUrl = lautRunnerBundle.getEntry(LAUT_ZIP)) != null) {
                    try {
                        File lautZipFile = new File(FileLocator.toFileURL((URL)lautZipUrl).getFile());
                        File lautBundleDir = new File(FileLocator.toFileURL((URL)lautRunnerBundle.getEntry("")).getFile());
                        File lautDir = new File(lautBundleDir, "laut");
                        if (!lautBundleDir.canWrite()) {
                            lautDir = AlloyCore.getDefault().getStateLocation().append("laut").toFile();
                        }
                        lautDir.mkdirs();
                        ZipUtil.unzip((File)lautZipFile, (File)lautDir.getParentFile());
                        lautUrl = lautRunnerBundle.getEntry(LAUT_ENTRY);
                        if (lautUrl != null) {
                            File lautRunnerDir = new File(FileLocator.toFileURL((URL)lautUrl).getFile());
                            String lautRunnerDirPath = lautRunnerDir.getAbsolutePath();
                            System.setProperty(LAUT_PATH, lautRunnerDirPath);
                            LautRunner.setSDKExecutableFlags((IPath)new Path(lautRunnerDirPath));
                        }
                    }
                    catch (Exception e) {
                        AlloyCore.logError("Unable to intialize Laut bundle", e);
                    }
                }
            }
        }
    }

    public static void setSDKExecutableFlags(IPath lautDir) {
        if (LautRunner.getLibC() == null) {
            return;
        }
        String[] stringArray = lautExeFiles;
        int n = lautExeFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String exeFile = stringArray[n2];
            LautRunner.getLibC().chmod(lautDir.append(exeFile).toOSString(), 493);
            ++n2;
        }
    }

    public void exec(IProject project, IProgressMonitor monitor) {
        ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType configType = lm.getLaunchConfigurationType("org.eclipse.ui.externaltools.ProgramLaunchConfigurationType");
        try {
            String projectName = project.getName();
            ILaunchConfigurationWorkingCopy config = configType.newInstance(null, lm.generateLaunchConfigurationName("laut " + projectName));
            config.setAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", true);
            config.setAttribute("org.eclipse.debug.ui.ATTR_CAPTURE_IN_CONSOLE", true);
            config.setAttribute("org.eclipse.debug.ui.ATTR_PRIVATE", true);
            config.setAttribute("org.eclipse.debug.core.ATTR_REFRESH_SCOPE", "${working_set:<?xml version=\"1.0\" encoding=\"UTF-8\"?><resources><item path=\"/" + project.getName() + "\" type=\"4\"/></resources>}");
            config.setAttribute("org.eclipse.ui.externaltools.ATTR_LAUNCH_CONFIGURATION_BUILD_SCOPE", "${projects:" + projectName + "}");
            config.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", this.getExecPath());
            config.setAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", "-f \"" + project.getLocation().toOSString() + "\"");
            config.setAttribute("org.eclipse.ui.externaltools.ATTR_WORKING_DIRECTORY", this.getWorkingPath().toOSString());
            new LaunchHelper().launch((ILaunchConfiguration)config, "run", monitor);
        }
        catch (CoreException e) {
            AlloyCore.logError("Problem launching laut tool.", (Exception)((Object)e));
        }
    }

    private String getExecPath() {
        return this.getWorkingPath().append(org.eclipse.core.runtime.Platform.getOS().contains("win") ? "run.bat" : "run.sh").toOSString();
    }

    private Path getWorkingPath() {
        return new Path(System.getProperty(LAUT_PATH));
    }

    public boolean hasUpdateAvailable() {
        return false;
    }

    static interface CLibrary
    extends Library {
        public int chmod(String var1, int var2);
    }
}

