/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.ui.form;

import com.liferay.ide.ui.form.TablePart;
import com.liferay.ide.ui.wizard.RenameDialog;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class EditableTablePart
extends TablePart {
    private boolean editable;
    private Action renameAction;

    public EditableTablePart(String[] buttonLabels) {
        super(buttonLabels);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public IAction getRenameAction() {
        if (this.renameAction == null) {
            this.renameAction = new RenameAction();
        }
        return this.renameAction;
    }

    protected StructuredViewer createStructuredViewer(Composite parent, int style, FormToolkit toolkit) {
        TableViewer tableViewer = (TableViewer)super.createStructuredViewer(parent, style, toolkit);
        return tableViewer;
    }

    private void doRename() {
        TableViewer viewer = this.getTableViewer();
        IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
        if (selection.size() == 1 && this.isEditable()) {
            Object obj = selection.getFirstElement();
            String oldName = obj.toString();
            RenameDialog dialog = new RenameDialog(this.getControl().getShell(), oldName);
            dialog.create();
            dialog.getShell().setText(Msgs.renameTitle);
            dialog.getShell().setSize(300, 150);
            if (dialog.open() == 0) {
                this.entryModified(obj, dialog.getNewName());
            }
        }
    }

    protected void entryModified(Object entry, String value) {
    }

    private static class Msgs
    extends NLS {
        public static String renameAction;
        public static String renameTitle;

        static {
            Msgs.initializeMessages((String)EditableTablePart.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }

    class NameModifier
    implements ICellModifier {
        NameModifier() {
        }

        public boolean canModify(Object object, String property) {
            return true;
        }

        public void modify(Object object, String property, Object value) {
            EditableTablePart.this.entryModified(object, value.toString());
        }

        public Object getValue(Object object, String property) {
            return object.toString();
        }
    }

    class RenameAction
    extends Action {
        public RenameAction() {
            super(Msgs.renameAction);
        }

        public void run() {
            EditableTablePart.this.doRename();
        }
    }
}

