/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.ui.util;

import com.liferay.ide.ui.LiferayUIPlugin;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.internal.wizards.newresource.ResourceMessages;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.osgi.framework.Bundle;

public class UIUtil {
    public static void async(Runnable runnable) {
        if (runnable != null) {
            try {
                Display.getDefault().asyncExec(runnable);
            }
            catch (Throwable throwable) {}
        }
    }

    private static boolean confirmPerspectiveSwitch(IWorkbenchWindow window, IPerspectiveDescriptor finalPersp) {
        IPreferenceStore store = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
        String pspm = store.getString("SWITCH_PERSPECTIVE_ON_PROJECT_CREATION");
        if (!"prompt".equals(pspm)) {
            return "always".equals(pspm);
        }
        String desc = finalPersp.getDescription();
        String message = desc == null || desc.length() == 0 ? NLS.bind((String)ResourceMessages.NewProject_perspSwitchMessage, (Object)finalPersp.getLabel()) : NLS.bind((String)ResourceMessages.NewProject_perspSwitchMessageWithDesc, (Object[])new String[]{finalPersp.getLabel(), desc});
        MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)window.getShell(), (String)ResourceMessages.NewProject_perspSwitchTitle, (String)message, null, (boolean)false, (IPreferenceStore)store, (String)"SWITCH_PERSPECTIVE_ON_PROJECT_CREATION");
        int result = dialog.getReturnCode();
        if (dialog.getToggleState()) {
            String preferenceValue = result == 2 ? "OPEN_PERSPECTIVE_REPLACE" : "NO_NEW_PERSPECTIVE";
            PrefUtil.getAPIPreferenceStore().setValue("PROJECT_OPEN_NEW_PERSPECTIVE", preferenceValue);
        }
        return result == 2;
    }

    public static Shell getActiveShell() {
        final Shell[] retval = new Shell[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                retval[0] = Display.getDefault().getActiveShell();
            }
        });
        return retval[0];
    }

    public static ImageDescriptor getPluginImageDescriptor(String symbolicName, String imagePath) {
        URL entry;
        Bundle bundle = Platform.getBundle((String)symbolicName);
        if (bundle != null && (entry = bundle.getEntry(imagePath)) != null) {
            return ImageDescriptor.createFromURL((URL)entry);
        }
        return null;
    }

    public static void postInfo(final String title, final String msg) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)title, (String)msg);
            }
        });
    }

    public static void postInfoWithToggle(final String title, final String msg, final String toggleMessage, final boolean toggleState, final IPersistentPreferenceStore store, final String key) {
        if (store == null || key == null || store.getString(key).equals("never")) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                MessageDialogWithToggle dialog = MessageDialogWithToggle.openInformation((Shell)Display.getDefault().getActiveShell(), (String)title, (String)msg, (String)toggleMessage, (boolean)toggleState, (IPreferenceStore)store, (String)key);
                try {
                    if (dialog.getToggleState()) {
                        store.setValue(key, "never");
                        store.save();
                    }
                }
                catch (IOException iOException) {}
            }
        });
    }

    public static boolean promptQuestion(final String title, final String message) {
        final boolean[] retval = new boolean[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                retval[0] = MessageDialog.openQuestion((Shell)UIUtil.getActiveShell(), (String)title, (String)message);
            }
        });
        return retval[0];
    }

    public static void refreshContent(ICommonContentExtensionSite site, final Object elementOrTreePath) {
        final NavigatorContentService s = (NavigatorContentService)site.getService();
        UIUtil.sync(new Runnable(){

            public void run() {
                try {
                    CommonViewer viewer = (CommonViewer)s.getViewer();
                    viewer.refresh(true);
                    viewer.setExpandedState(elementOrTreePath, true);
                }
                catch (Exception exception) {}
            }
        });
    }

    private static void replaceCurrentPerspective(IPerspectiveDescriptor persp) {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            page.setPerspective(persp);
        }
    }

    public static IViewPart showView(String viewId) {
        try {
            IViewPart view = PlatformUI.getWorkbench().getWorkbenchWindows()[0].getActivePage().showView(viewId);
            return view;
        }
        catch (PartInitException e) {
            LiferayUIPlugin.logError((Exception)((Object)e));
            return null;
        }
    }

    public static void switchToLiferayPerspective() {
        String perspSetting = PrefUtil.getAPIPreferenceStore().getString("PROJECT_OPEN_NEW_PERSPECTIVE");
        String promptSetting = IDEWorkbenchPlugin.getDefault().getPreferenceStore().getString("SWITCH_PERSPECTIVE_ON_PROJECT_CREATION");
        if (!promptSetting.equals("prompt") && perspSetting.equals("NO_NEW_PERSPECTIVE")) {
            return;
        }
        IPerspectiveRegistry reg = PlatformUI.getWorkbench().getPerspectiveRegistry();
        IPerspectiveDescriptor finalPersp = reg.findPerspectiveWithId("com.liferay.ide.eclipse.ui.perspective.liferay");
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            IPerspectiveDescriptor currentPersp;
            IWorkbenchPage page = window.getActivePage();
            if (page != null && finalPersp.equals(currentPersp = page.getPerspective())) {
                return;
            }
            if (!UIUtil.confirmPerspectiveSwitch(window, finalPersp)) {
                return;
            }
        }
        UIUtil.replaceCurrentPerspective(finalPersp);
    }

    public static void sync(Runnable runnable) {
        if (runnable != null) {
            try {
                Display.getDefault().syncExec(runnable);
            }
            catch (Throwable throwable) {}
        }
    }
}

