/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.hook.core.descriptor;

import com.liferay.ide.core.util.NodeUtil;
import com.liferay.ide.core.util.PropertiesUtil;
import com.liferay.ide.hook.core.HookCore;
import com.liferay.ide.project.core.BaseValidator;
import com.liferay.ide.project.core.LiferayProjectCore;
import com.liferay.ide.project.core.util.ProjectUtil;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.ValidatorMessage;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiferayHookDescriptorValidator
extends BaseValidator {
    public static final String CUSTOM_JSP_DIR_ELEMENT = "custom-jsp-dir";
    public static final String LANGUAGE_PROPERTIES_ELEMENT = "language-properties";
    public static final String MARKER_TYPE = "com.liferay.ide.hook.core.liferayHookDescriptorMarker";
    public static final String MESSAGE_CUSTOM_JSP_DIR_NOT_FOUND = Msgs.customJspDirectoryNotFound;
    public static final String MESSAGE_LANGUAGE_PROPERTIES_NOT_FOUND = Msgs.resourceNotFound;
    public static final String MESSAGE_PORTAL_PROPERTIES_NOT_FOUND = Msgs.resourceNotFound;
    public static final String MESSAGE_SERVICE_IMPL_NOT_FOUND = Msgs.serviceImplNotFound;
    private static final String MESSAGE_SERVICE_TYPE_INVALID = Msgs.serviceTypeInvalid;
    private static final String MESSAGE_SERVICE_TYPE_IS_NOT_INTERFACE = Msgs.serviceTypeNotInterface;
    public static final String MESSAGE_SERVICE_TYPE_NOT_FOUND = Msgs.serviceTypeNotFound;
    public static final String PORTAL_PROPERTIES_ELEMENT = "portal-properties";
    public static final String PREFERENCE_NODE_QUALIFIER = LiferayProjectCore.getDefault().getBundle().getSymbolicName();
    private static final String SERVICE_ELEMENT = "service";
    public static final String SERVICE_IMPL_ELEMENT = "service-impl";
    public static final String SERVICE_TYPE_ELEMENT = "service-type";

    protected void checkClassResourceElement(IDOMDocument document, IJavaProject javaProject, String preferenceNodeQualifier, IScopeContext[] preferenceScopes, List<Map<String, Object>> problems, String elementName, String preferenceKey, String message) {
        NodeList elements = document.getElementsByTagName(elementName);
        int i = 0;
        while (i < elements.getLength()) {
            Node item = elements.item(i);
            Map problem = this.checkClassResource(javaProject, item, PREFERENCE_NODE_QUALIFIER, preferenceScopes, preferenceKey, message);
            if (problem != null) {
                problems.add(problem);
            }
            ++i;
        }
    }

    protected void checkClassResourceElements(IDOMDocument document, IJavaProject javaProject, String preferenceNodeQualifier, IScopeContext[] preferenceScopes, List<Map<String, Object>> problems) {
        this.checkClassResourceElement(document, javaProject, preferenceNodeQualifier, preferenceScopes, problems, PORTAL_PROPERTIES_ELEMENT, "validation-liferay-hook-xml-portal-properties-not-found", MESSAGE_PORTAL_PROPERTIES_NOT_FOUND);
        this.checkClassResourceElement(document, javaProject, preferenceNodeQualifier, preferenceScopes, problems, LANGUAGE_PROPERTIES_ELEMENT, "validation-liferay-hook-xml-language-properties-not-found", MESSAGE_LANGUAGE_PROPERTIES_NOT_FOUND);
    }

    protected void checkDocrootElements(IDOMDocument document, IProject project, IScopeContext[] preferenceScopes, List<Map<String, Object>> problems) {
        this.checkDocrootElement(document, CUSTOM_JSP_DIR_ELEMENT, project, PREFERENCE_NODE_QUALIFIER, preferenceScopes, "validation-liferay-hook-xml-custom-jsp-dir-not-found", MESSAGE_CUSTOM_JSP_DIR_NOT_FOUND, problems);
    }

    protected void checkServiceElements(IDOMDocument document, IJavaProject javaProject, String preferenceNodeQualifier, IScopeContext[] preferenceScopes, List<Map<String, Object>> problems) {
        NodeList elements = document.getElementsByTagName(SERVICE_ELEMENT);
        int i = 0;
        while (i < elements.getLength()) {
            NodeList serviceImpls;
            Node itemServiceImpl;
            Element serviceTag = (Element)elements.item(i);
            NodeList serviceTypes = serviceTag.getElementsByTagName(SERVICE_TYPE_ELEMENT);
            Node itemServiceType = serviceTypes.item(0);
            boolean serviceTypeValid = false;
            String serviceTypeContent = null;
            Map problem = null;
            if (itemServiceType != null) {
                serviceTypeContent = NodeUtil.getTextContent((Node)itemServiceType);
                problem = this.checkClass(javaProject, itemServiceType, preferenceNodeQualifier, preferenceScopes, "validation-liferay-hook-xml-class-not-found", "validation-liferay-hook-xml-incorrect-class-hierarchy", null);
                if (problem != null) {
                    problems.add(problem);
                } else if (serviceTypeContent != null && serviceTypeContent.length() > 0) {
                    try {
                        IType typeServiceType = javaProject.findType(serviceTypeContent);
                        if (!typeServiceType.isInterface()) {
                            String msg = MessageFormat.format(MESSAGE_SERVICE_TYPE_IS_NOT_INTERFACE, serviceTypeContent);
                            problem = this.createMarkerValues(preferenceNodeQualifier, preferenceScopes, "validation-liferay-hook-xml-incorrect-class-hierarchy", (IDOMNode)itemServiceType, msg);
                            if (problem != null) {
                                problems.add(problem);
                            }
                        } else if (!serviceTypeContent.matches("com.liferay.*Service")) {
                            problem = this.createMarkerValues(preferenceNodeQualifier, preferenceScopes, "validation-liferay-hook-xml-incorrect-class-hierarchy", (IDOMNode)itemServiceType, MESSAGE_SERVICE_TYPE_INVALID);
                            if (problem != null) {
                                problems.add(problem);
                            }
                        } else {
                            serviceTypeValid = true;
                        }
                    }
                    catch (JavaModelException e) {
                        HookCore.logError(e);
                    }
                }
            }
            if ((itemServiceImpl = (serviceImpls = serviceTag.getElementsByTagName(SERVICE_IMPL_ELEMENT)).item(0)) != null && (problem = serviceTypeValid ? this.checkClass(javaProject, itemServiceImpl, preferenceNodeQualifier, preferenceScopes, "validation-liferay-hook-xml-class-not-found", "validation-liferay-hook-xml-incorrect-class-hierarchy", String.valueOf(serviceTypeContent) + "Wrapper") : this.checkClass(javaProject, itemServiceImpl, preferenceNodeQualifier, preferenceScopes, "validation-liferay-hook-xml-class-not-found", "validation-liferay-hook-xml-incorrect-class-hierarchy", null)) != null) {
                problems.add(problem);
            }
            ++i;
        }
    }

    protected void checkLanguagePropertiesEncoding(IDOMDocument document, IJavaProject javaProject, String preferenceNodeQualifier, IScopeContext[] preferenceScopes, String languagePropertiesEncodingPreferenceKey, List<Map<String, Object>> problems) {
        NodeList languagePropertiesNodes = document.getElementsByTagName(LANGUAGE_PROPERTIES_ELEMENT);
        int i = 0;
        while (i < languagePropertiesNodes.getLength()) {
            Node languageProperties = languagePropertiesNodes.item(i);
            try {
                IClasspathEntry[] classpathEntrys;
                IWorkspaceRoot workspaceRoot = javaProject.getJavaModel().getWorkspace().getRoot();
                IClasspathEntry[] iClasspathEntryArray = classpathEntrys = javaProject.getResolvedClasspath(true);
                int n = classpathEntrys.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry entry = iClasspathEntryArray[n2];
                    if (entry.getEntryKind() == 3) {
                        String languagePropertiesVal = NodeUtil.getTextContent((Node)languageProperties);
                        if (languagePropertiesVal.contains("*")) {
                            IFile[] languagePropertiesFiles;
                            String languagePropertiesValRegex = languagePropertiesVal.replaceAll("\\*", ".*");
                            IResource entryResource = workspaceRoot.findMember(entry.getPath().toString());
                            if (entryResource != null && (languagePropertiesFiles = PropertiesUtil.visitPropertiesFiles((IResource)entryResource, (String)languagePropertiesValRegex)) != null && languagePropertiesFiles.length > 0) {
                                IFile[] iFileArray = languagePropertiesFiles;
                                int n3 = languagePropertiesFiles.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    IFile file = iFileArray[n4];
                                    if (file.exists() && !file.getCharset().equals("UTF-8")) {
                                        String msg = MessageFormat.format(Msgs.languagePropertiesEncodingNotDefault, file.getName());
                                        problems.add(this.createMarkerValues(preferenceNodeQualifier, preferenceScopes, languagePropertiesEncodingPreferenceKey, (IDOMNode)languageProperties, msg));
                                    }
                                    ++n4;
                                }
                            }
                        } else {
                            IFile languagePropertiesFile = workspaceRoot.getFile(entry.getPath().append(languagePropertiesVal));
                            if (languagePropertiesFile.exists() && !languagePropertiesFile.getCharset().equals("UTF-8")) {
                                String msg = MessageFormat.format(Msgs.languagePropertiesEncodingNotDefault, languagePropertiesFile.getName());
                                problems.add(this.createMarkerValues(preferenceNodeQualifier, preferenceScopes, languagePropertiesEncodingPreferenceKey, (IDOMNode)languageProperties, msg));
                            }
                        }
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                HookCore.logError(e);
            }
            ++i;
        }
    }

    protected Map<String, Object>[] detectProblems(IFile liferayHookXml, IScopeContext[] preferenceScopes) throws CoreException {
        ArrayList<Map<String, Object>> problems;
        block9: {
            problems = new ArrayList<Map<String, Object>>();
            IStructuredModel liferayHookXmlModel = null;
            IDOMDocument liferayHookXmlDocument = null;
            try {
                try {
                    liferayHookXmlModel = StructuredModelManager.getModelManager().getModelForRead(liferayHookXml);
                    if (liferayHookXmlModel != null && liferayHookXmlModel instanceof IDOMModel) {
                        liferayHookXmlDocument = ((IDOMModel)liferayHookXmlModel).getDocument();
                        this.checkDocrootElements(liferayHookXmlDocument, liferayHookXml.getProject(), preferenceScopes, problems);
                        IJavaProject javaProject = JavaCore.create((IProject)liferayHookXml.getProject());
                        this.checkServiceElements(liferayHookXmlDocument, javaProject, PREFERENCE_NODE_QUALIFIER, preferenceScopes, problems);
                        this.checkClassResourceElements(liferayHookXmlDocument, javaProject, PREFERENCE_NODE_QUALIFIER, preferenceScopes, problems);
                        Map map = this.getAllClasseElements("LiferayHookClassElements.properties");
                        this.checkAllClassElements(map, javaProject, liferayHookXml, "validation-liferay-hook-xml-class-not-found", "validation-liferay-hook-xml-incorrect-class-hierarchy", preferenceScopes, PREFERENCE_NODE_QUALIFIER, problems);
                        this.checkLanguagePropertiesEncoding(liferayHookXmlDocument, javaProject, PREFERENCE_NODE_QUALIFIER, preferenceScopes, "validation-liferay-hook-xml-language-properties-encoding-not-found", problems);
                    }
                }
                catch (IOException e) {
                    HookCore.logError(e);
                    if (liferayHookXmlModel != null) {
                        liferayHookXmlModel.releaseFromRead();
                    }
                    break block9;
                }
            }
            catch (Throwable throwable) {
                if (liferayHookXmlModel != null) {
                    liferayHookXmlModel.releaseFromRead();
                }
                throw throwable;
            }
            if (liferayHookXmlModel != null) {
                liferayHookXmlModel.releaseFromRead();
            }
        }
        Map[] retval = new Map[problems.size()];
        return problems.toArray(retval);
    }

    public ValidationResult validate(IResource resource, int kind, ValidationState state, IProgressMonitor monitor) {
        if (resource.getType() != 1) {
            return null;
        }
        ValidationResult result = new ValidationResult();
        IFile liferayHookXml = (IFile)resource;
        IProject project = resource.getProject();
        if (liferayHookXml.isAccessible() && (ProjectUtil.isHookProject((IProject)project) || ProjectUtil.isPortletProject((IProject)project))) {
            IScopeContext[] scopes = new IScopeContext[]{new InstanceScope(), new DefaultScope()};
            ProjectScope projectScope = new ProjectScope(project);
            boolean useProjectSettings = projectScope.getNode(PREFERENCE_NODE_QUALIFIER).getBoolean("use-project-settings", false);
            if (useProjectSettings) {
                scopes = new IScopeContext[]{projectScope, new InstanceScope(), new DefaultScope()};
            }
            try {
                Map<String, Object>[] problems = this.detectProblems(liferayHookXml, scopes);
                int i = 0;
                while (i < problems.length) {
                    ValidatorMessage message = ValidatorMessage.create((String)problems[i].get("message").toString(), (IResource)resource);
                    message.setType(MARKER_TYPE);
                    message.setAttributes(problems[i]);
                    result.add(message);
                    ++i;
                }
            }
            catch (Exception e) {
                HookCore.logError(e);
            }
        }
        return result;
    }

    private static class Msgs
    extends NLS {
        public static String customJspDirectoryNotFound;
        public static String resourceNotFound;
        public static String serviceImplNotFound;
        public static String serviceTypeInvalid;
        public static String serviceTypeNotFound;
        public static String serviceTypeNotInterface;
        public static String languagePropertiesEncodingNotDefault;

        static {
            Msgs.initializeMessages((String)LiferayHookDescriptorValidator.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

